/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.connector.ByteBufferPool;
import io.undertow.servlet.spec.UpgradeServletInputStream;
import io.undertow.servlet.spec.UpgradeServletOutputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.WebConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class WebConnectionImpl
implements WebConnection {
    private final StreamConnection channel;
    private final UpgradeServletOutputStream outputStream;
    private final UpgradeServletInputStream inputStream;
    private final Executor ioExecutor;

    public WebConnectionImpl(StreamConnection channel, ByteBufferPool bufferPool, Executor ioExecutor) {
        this.channel = channel;
        this.ioExecutor = ioExecutor;
        this.outputStream = new UpgradeServletOutputStream((StreamSinkChannel)channel.getSinkChannel(), ioExecutor);
        this.inputStream = new UpgradeServletInputStream((StreamSourceChannel)channel.getSourceChannel(), bufferPool, ioExecutor);
        channel.getCloseSetter().set((ChannelListener)new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection channel) {
                try {
                    WebConnectionImpl.this.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void close() throws Exception {
        try {
            this.outputStream.closeBlocking();
        }
        catch (Throwable throwable) {
            IoUtils.safeClose((Closeable[])new Closeable[]{this.inputStream, this.channel});
            throw throwable;
        }
        IoUtils.safeClose((Closeable[])new Closeable[]{this.inputStream, this.channel});
    }
}

