/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowFunctionsOperation
extends AbstractShowOperation {
    private final FunctionScope functionScope;
    @Nullable
    private final String databaseName;

    public ShowFunctionsOperation(@Nullable String catalogName, @Nullable String databaseName) {
        this(FunctionScope.ALL, catalogName, databaseName, null);
    }

    public ShowFunctionsOperation(FunctionScope functionScope, @Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        this(functionScope, null, catalogName, databaseName, likeOp);
    }

    public ShowFunctionsOperation(FunctionScope functionScope, @Nullable String preposition, @Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
        this.functionScope = functionScope;
        this.databaseName = databaseName;
    }

    @Override
    protected Collection<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        switch (this.functionScope) {
            case USER: {
                if (this.preposition == null) {
                    return Arrays.asList(ctx.getFunctionCatalog().getUserDefinedFunctions());
                }
                return ctx.getFunctionCatalog().getUserDefinedFunctions(this.catalogName, this.databaseName).stream().map(FunctionIdentifier::getFunctionName).collect(Collectors.toList());
            }
            case ALL: {
                if (this.preposition == null) {
                    return Arrays.asList(ctx.getFunctionCatalog().getFunctions());
                }
                return Arrays.asList(ctx.getFunctionCatalog().getFunctions(this.catalogName, this.databaseName));
            }
        }
        throw new UnsupportedOperationException(String.format("SHOW FUNCTIONS with %s scope is not supported.", this.databaseName));
    }

    @Override
    protected String getOperationName() {
        return this.functionScope == FunctionScope.ALL ? "SHOW FUNCTIONS" : "SHOW USER FUNCTIONS";
    }

    @Override
    protected String getColumnName() {
        return "function name";
    }

    @Override
    public String getPrepositionSummaryString() {
        if (this.databaseName == null) {
            return super.getPrepositionSummaryString();
        }
        return super.getPrepositionSummaryString() + "." + this.databaseName;
    }

    @Internal
    public static enum FunctionScope {
        USER,
        ALL;

    }
}

