/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TopicMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.TopicMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TopicMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TopicMetaBaseSQLProvider> TOPIC_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TopicMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TopicMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new TopicMetaPostgreSQLProvider());

    public static TopicMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return TOPIC_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertTopicMeta(@Param(value="topicMeta") TopicPO topicPO) {
        return TopicMetaSQLProviderFactory.getProvider().insertTopicMeta(topicPO);
    }

    public static String insertTopicMetaOnDuplicateKeyUpdate(@Param(value="topicMeta") TopicPO topicPO) {
        return TopicMetaSQLProviderFactory.getProvider().insertTopicMetaOnDuplicateKeyUpdate(topicPO);
    }

    public static String listTopicPOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return TopicMetaSQLProviderFactory.getProvider().listTopicPOsBySchemaId(schemaId);
    }

    public static String listTopicPOsByTopicIds(@Param(value="topicIds") List<Long> topicIds) {
        return TopicMetaSQLProviderFactory.getProvider().listTopicPOsByTopicIds(topicIds);
    }

    public static String selectTopicMetaBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="topicName") String topicName) {
        return TopicMetaSQLProviderFactory.getProvider().selectTopicMetaBySchemaIdAndName(schemaId, topicName);
    }

    public static String selectTopicMetaById(@Param(value="topicId") Long topicId) {
        return TopicMetaSQLProviderFactory.getProvider().selectTopicMetaById(topicId);
    }

    public static String updateTopicMeta(@Param(value="newTopicMeta") TopicPO newTopicPO, @Param(value="oldTopicMeta") TopicPO oldTopicPO) {
        return TopicMetaSQLProviderFactory.getProvider().updateTopicMeta(newTopicPO, oldTopicPO);
    }

    public static String selectTopicIdBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="topicName") String name) {
        return TopicMetaSQLProviderFactory.getProvider().selectTopicIdBySchemaIdAndName(schemaId, name);
    }

    public static String softDeleteTopicMetasByTopicId(@Param(value="topicId") Long topicId) {
        return TopicMetaSQLProviderFactory.getProvider().softDeleteTopicMetasByTopicId(topicId);
    }

    public static String softDeleteTopicMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return TopicMetaSQLProviderFactory.getProvider().softDeleteTopicMetasByCatalogId(catalogId);
    }

    public static String softDeleteTopicMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return TopicMetaSQLProviderFactory.getProvider().softDeleteTopicMetasByMetalakeId(metalakeId);
    }

    public static String softDeleteTopicMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return TopicMetaSQLProviderFactory.getProvider().softDeleteTopicMetasBySchemaId(schemaId);
    }

    public static String deleteTopicMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TopicMetaSQLProviderFactory.getProvider().deleteTopicMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class TopicMetaMySQLProvider
    extends TopicMetaBaseSQLProvider {
        TopicMetaMySQLProvider() {
        }
    }

    static class TopicMetaH2Provider
    extends TopicMetaBaseSQLProvider {
        TopicMetaH2Provider() {
        }
    }
}

