/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.servlets;

import com.papertrail.profiler.CpuProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CpuProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = -668666696530287501L;
    private static final String CONTENT_TYPE = "pprof/raw";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";
    private final Lock lock = new ReentrantLock();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int duration = 10;
        if (req.getParameter("duration") != null) {
            try {
                duration = Integer.parseInt(req.getParameter("duration"));
            }
            catch (NumberFormatException e) {
                duration = 10;
            }
        }
        int frequency = 100;
        if (req.getParameter("frequency") != null) {
            try {
                frequency = Integer.parseInt(req.getParameter("frequency"));
                frequency = Math.min(Math.max(frequency, 1), 1000);
            }
            catch (NumberFormatException e) {
                frequency = 100;
            }
        }
        Thread.State state = "blocked".equalsIgnoreCase(req.getParameter("state")) ? Thread.State.BLOCKED : Thread.State.RUNNABLE;
        resp.setStatus(200);
        resp.setHeader(CACHE_CONTROL, NO_CACHE);
        resp.setContentType(CONTENT_TYPE);
        try (ServletOutputStream output = resp.getOutputStream();){
            this.doProfile((OutputStream)output, duration, frequency, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProfile(OutputStream out, int duration, int frequency, Thread.State state) throws IOException {
        if (this.lock.tryLock()) {
            try {
                CpuProfile profile = CpuProfile.record((Duration)Duration.ofSeconds(duration), (int)frequency, (Thread.State)state);
                if (profile == null) {
                    throw new RuntimeException("could not create CpuProfile");
                }
                profile.writeGoogleProfile(out);
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new RuntimeException("Only one profile request may be active at a time");
    }
}

