/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.apache.hertzbeat.common.cache.CommonCacheService;

public class CaffeineCacheServiceImpl<K, V>
implements CommonCacheService<K, V> {
    private final Cache<K, V> cache;

    public CaffeineCacheServiceImpl(int initialCapacity, long maximumSize, Duration expireAfterWrite, boolean useWeakKey) {
        this.cache = useWeakKey ? Caffeine.newBuilder().weakKeys().initialCapacity(initialCapacity).maximumSize(maximumSize).expireAfterWrite(expireAfterWrite).build() : Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(maximumSize).expireAfterWrite(expireAfterWrite).build();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V putAndGetOld(K key, V value) {
        Object oldValue = this.cache.getIfPresent(key);
        this.cache.put(key, value);
        return (V)oldValue;
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    public V remove(K key) {
        Object value = this.cache.getIfPresent(key);
        this.cache.invalidate(key);
        this.cache.cleanUp();
        return (V)value;
    }

    @Override
    public boolean clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
        return true;
    }
}

