// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

use std::ops::Deref;

/// Identifier for a shard in the cluster.
#[derive(Debug, Clone, Copy, Eq, PartialEq, Hash)]
pub struct ShardId(u16);

impl ShardId {
    pub fn new(id: u16) -> Self {
        Self(id)
    }

    pub fn id(&self) -> u16 {
        self.0
    }
}

impl Deref for ShardId {
    type Target = u16;

    fn deref(&self) -> &Self::Target {
        &self.0
    }
}

impl From<u16> for ShardId {
    fn from(id: u16) -> Self {
        Self(id)
    }
}
