/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.coordinator;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.core.exception.AbstractExceptionHandler;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequest;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.coordinator.DefaultCoordinator;
import org.apache.seata.server.store.StoreConfig;
import org.springframework.context.ApplicationListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftCoordinator
extends DefaultCoordinator
implements ApplicationListener<ClusterChangeEvent> {
    protected static final Map<String, Boolean> GROUP_PREVENT = new ConcurrentHashMap();

    public RaftCoordinator(RemotingServer remotingServer) {
        super(remotingServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> void exceptionHandleTemplate(AbstractExceptionHandler.Callback<T, S> callback, T request, S response) {
        String group = SeataClusterContext.bindGroup();
        try {
            if (!this.isPass(group)) {
                throw new TransactionException(TransactionExceptionCode.NotRaftLeader, " The current TC is not a leader node, interrupt processing !");
            }
            super.exceptionHandleTemplate(callback, request, response);
        }
        catch (TransactionException tex) {
            LOGGER.error("Catch TransactionException while do RPC, request: {}", request, (Object)tex);
            callback.onTransactionException(request, response, tex);
        }
        finally {
            SeataClusterContext.unbindGroup();
        }
    }

    private boolean isPass(String group) {
        return Optional.ofNullable((Boolean)GROUP_PREVENT.get(group)).orElse(false);
    }

    public static void setPrevent(String group, boolean prevent) {
        if (StoreConfig.getSessionMode() == SessionMode.RAFT) {
            GROUP_PREVENT.put(group, prevent);
        }
    }

    public void onApplicationEvent(ClusterChangeEvent event) {
        RaftCoordinator.setPrevent((String)event.getGroup(), (boolean)event.isLeader());
    }
}

