/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolverUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResolverUtils.class);
    private static final Pattern ZONE_RE = Pattern.compile("(txt\\.)?([^.]+).*");

    private ResolverUtils() {
    }

    public static List<AwsEndpoint>[] splitByZone(List<AwsEndpoint> eurekaEndpoints, String myZone) {
        if (eurekaEndpoints.isEmpty()) {
            return new List[]{Collections.emptyList(), Collections.emptyList()};
        }
        if (myZone == null) {
            return new List[]{Collections.emptyList(), new ArrayList<AwsEndpoint>(eurekaEndpoints)};
        }
        ArrayList<AwsEndpoint> myZoneList = new ArrayList<AwsEndpoint>(eurekaEndpoints.size());
        ArrayList<AwsEndpoint> remainingZonesList = new ArrayList<AwsEndpoint>(eurekaEndpoints.size());
        for (AwsEndpoint endpoint : eurekaEndpoints) {
            if (myZone.equalsIgnoreCase(endpoint.getZone())) {
                myZoneList.add(endpoint);
                continue;
            }
            remainingZonesList.add(endpoint);
        }
        return new List[]{myZoneList, remainingZonesList};
    }

    public static String extractZoneFromHostName(String hostName) {
        Matcher matcher = ZONE_RE.matcher(hostName);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public static <T extends EurekaEndpoint> List<T> randomize(List<T> list) {
        ArrayList<T> randomList = new ArrayList<T>(list);
        if (randomList.size() < 2) {
            return randomList;
        }
        Collections.shuffle(randomList, ThreadLocalRandom.current());
        return randomList;
    }

    public static <T extends EurekaEndpoint> boolean identical(List<T> firstList, List<T> secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        HashSet<T> compareSet = new HashSet<T>(firstList);
        compareSet.removeAll(secondList);
        return compareSet.isEmpty();
    }

    public static AwsEndpoint instanceInfoToEndpoint(EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, InstanceInfo instanceInfo) {
        String zone = null;
        DataCenterInfo dataCenterInfo = instanceInfo.getDataCenterInfo();
        zone = dataCenterInfo instanceof AmazonInfo ? ((AmazonInfo)dataCenterInfo).get(AmazonInfo.MetaDataKey.availabilityZone) : instanceInfo.getMetadata().get("zone");
        String networkAddress = transportConfig.applicationsResolverUseIp() ? (instanceInfo.getDataCenterInfo() instanceof AmazonInfo ? ((AmazonInfo)instanceInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.localIpv4) : instanceInfo.getIPAddr()) : instanceInfo.getHostName();
        if (networkAddress == null) {
            logger.error("Cannot resolve InstanceInfo {} to a proper resolver endpoint, skipping", (Object)instanceInfo);
            return null;
        }
        return new AwsEndpoint(networkAddress, instanceInfo.getPort(), false, clientConfig.getEurekaServerURLContext(), clientConfig.getRegion(), zone);
    }
}

