/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.tools;

import java.util.Map;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.mcp.service.ModifyConfirmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.annotation.McpToolParam;
import org.springframework.stereotype.Service;

@Service
public class ModifyConfirmTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyConfirmTools.class);
    private final ModifyConfirmService modifyConfirmService;

    public ModifyConfirmTools(ModifyConfirmService modifyConfirmService) {
        this.modifyConfirmService = modifyConfirmService;
    }

    @McpTool(description="Before modifying (update or delete) a transaction or lock, the user MUST manually confirm.You are NOT allowed to fabricate or auto-confirm on behalf of the user.")
    public Map<String, String> confirmAndGetKey(@McpToolParam(description="The confirmation string provided by the USER (not generated by the LLM).The content must repeat the modification action clearly.") String userInputStr) {
        if (StringUtils.isBlank((String)userInputStr)) {
            throw new IllegalArgumentException("User confirmation string is required.");
        }
        if (!userInputStr.contains("\u786e\u8ba4") && !userInputStr.contains("confirm")) {
            throw new IllegalArgumentException("Confirmation string must explicitly contain '\u786e\u8ba4' or 'confirm' and repeat the modification content. This must come from the user.");
        }
        Map<String, String> keyMap = this.modifyConfirmService.confirmAndGetKey();
        LOGGER.info("the user obtains a modify key:{}", (Object)keyMap.get("modify_key"));
        return keyMap;
    }
}

