/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.BrokerConfigMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsBrokerConfigMapperImpl
implements BrokerConfigMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsBrokerConfigMapperImpl.class);
    private final ConcurrentHashMap<Integer, BrokerConfEntity> brokerConfCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> brokerIpIndexCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ConcurrentHashSet<Integer>> regionIndexCache = new ConcurrentHashMap();

    @Override
    public boolean addBrokerConf(BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        if (this.brokerConfCache.get(entity.getBrokerId()) != null || this.brokerIpIndexCache.get(entity.getBrokerIp()) != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for ").append(WebFieldDef.BROKERID.name).append("(").append(entity.getBrokerId()).append(") or ").append(WebFieldDef.BROKERIP.name).append("(").append(entity.getBrokerIp()).append(") value!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (!WebParameterUtils.isValidPortsSet(entity.getBrokerPort(), entity.getBrokerTLSPort(), entity.getBrokerWebPort(), strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(entity, strBuff, result)) {
            this.putRecord2Caches(entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updBrokerConf(BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity curEntity = this.brokerConfCache.get(entity.getBrokerId());
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure for ").append(WebFieldDef.BROKERID.name).append("(").append(entity.getBrokerId()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        BrokerConfEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(entity);
        if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getBrokerPort(), entity.getBrokerTLSPort(), entity.getBrokerWebPort(), entity.getRegionId(), entity.getGroupId(), entity.getManageStatus(), entity.getTopicProps())) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Broker configure not changed!");
            return result.isSuccess();
        }
        if (!WebParameterUtils.isValidPortsSet(newEntity.getBrokerPort(), newEntity.getBrokerTLSPort(), newEntity.getBrokerWebPort(), strBuff, result)) {
            return result.isSuccess();
        }
        if (!this.isValidMngStatusChange(newEntity, curEntity, strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.putRecord2Caches(newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updBrokerMngStatus(BaseEntity opEntity, int brokerId, ManageStatus newMngStatus, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity curEntity = this.brokerConfCache.get(brokerId);
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure for ").append(WebFieldDef.BROKERID.name).append("(").append(brokerId).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (curEntity.getManageStatus() == newMngStatus) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), strBuff.append("Unchanged  ").append(WebFieldDef.MANAGESTATUS.name).append("(").append(newMngStatus.getDescription()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        BrokerConfEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(opEntity);
        if (!newEntity.updModifyInfo(opEntity.getDataVerId(), -2, -2, -2, -2, -2, newMngStatus, null)) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Broker configure not changed!");
            return result.isSuccess();
        }
        if (!this.isValidMngStatusChange(newEntity, curEntity, strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.putRecord2Caches(newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean delBrokerConf(int brokerId, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity curEntity = this.brokerConfCache.get(brokerId);
        if (curEntity == null) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        this.delConfigFromPersistent(brokerId, strBuff);
        this.delRecordFromCaches(brokerId);
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(BrokerConfEntity qryEntity) {
        HashMap<Integer, BrokerConfEntity> retMap = new HashMap<Integer, BrokerConfEntity>();
        if (qryEntity == null) {
            for (BrokerConfEntity entity : this.brokerConfCache.values()) {
                retMap.put(entity.getBrokerId(), entity);
            }
        } else {
            for (BrokerConfEntity entity : this.brokerConfCache.values()) {
                if (entity == null || !entity.isMatched(qryEntity)) continue;
                retMap.put(entity.getBrokerId(), entity);
            }
        }
        return retMap;
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(Set<Integer> brokerIdSet, Set<String> brokerIpSet, BrokerConfEntity qryEntity) {
        HashSet<Integer> idHitSet = null;
        HashSet<Integer> ipHitSet = null;
        HashSet<Integer> totalMatchedSet = null;
        HashMap<Integer, BrokerConfEntity> retMap = new HashMap<Integer, BrokerConfEntity>();
        if (brokerIdSet != null && !brokerIdSet.isEmpty()) {
            idHitSet = new HashSet<Integer>();
            for (Integer brokerId : brokerIdSet) {
                BrokerConfEntity entity = this.brokerConfCache.get(brokerId);
                if (entity == null) continue;
                idHitSet.add(brokerId);
            }
            if (idHitSet.isEmpty()) {
                return retMap;
            }
        }
        if (brokerIpSet != null && !brokerIpSet.isEmpty()) {
            ipHitSet = new HashSet<Integer>();
            for (String brokerIp : brokerIpSet) {
                Integer brokerId;
                brokerId = this.brokerIpIndexCache.get(brokerIp);
                if (brokerId == null) continue;
                ipHitSet.add(brokerId);
            }
            if (ipHitSet.isEmpty()) {
                return retMap;
            }
        }
        if (idHitSet != null || ipHitSet != null) {
            if (idHitSet == null) {
                totalMatchedSet = new HashSet<Integer>(ipHitSet);
            } else if (ipHitSet == null) {
                totalMatchedSet = new HashSet(idHitSet);
            } else {
                totalMatchedSet = new HashSet();
                for (Integer record : idHitSet) {
                    if (!ipHitSet.contains(record)) continue;
                    totalMatchedSet.add(record);
                }
            }
        }
        if (totalMatchedSet == null) {
            for (BrokerConfEntity entity : this.brokerConfCache.values()) {
                if (entity == null || qryEntity != null && !entity.isMatched(qryEntity)) continue;
                retMap.put(entity.getBrokerId(), entity);
            }
        } else {
            for (Integer brokerId : totalMatchedSet) {
                BrokerConfEntity entity = this.brokerConfCache.get(brokerId);
                if (entity == null || qryEntity != null && !entity.isMatched(qryEntity)) continue;
                retMap.put(entity.getBrokerId(), entity);
            }
        }
        return retMap;
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerId(int brokerId) {
        return this.brokerConfCache.get(brokerId);
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerIp(String brokerIp) {
        Integer brokerId = this.brokerIpIndexCache.get(brokerIp);
        if (brokerId == null) {
            return null;
        }
        return this.brokerConfCache.get(brokerId);
    }

    @Override
    public Map<Integer, Set<Integer>> getBrokerIdByRegionId(Set<Integer> regionIdSet) {
        HashSet<Integer> qryKey = new HashSet<Integer>();
        HashMap<Integer, Set<Integer>> retInfo = new HashMap<Integer, Set<Integer>>();
        if (regionIdSet == null || regionIdSet.isEmpty()) {
            qryKey.addAll(this.regionIndexCache.keySet());
        } else {
            qryKey.addAll(regionIdSet);
        }
        for (Integer regionId : qryKey) {
            ConcurrentHashSet<Integer> brokerIdSet = this.regionIndexCache.get(regionId);
            if (brokerIdSet == null || brokerIdSet.isEmpty()) continue;
            retInfo.put(regionId, (Set<Integer>)brokerIdSet);
        }
        return retInfo;
    }

    protected void clearCachedData() {
        this.brokerIpIndexCache.clear();
        this.regionIndexCache.clear();
        this.brokerConfCache.clear();
    }

    protected void putRecord2Caches(BrokerConfEntity entity) {
        ConcurrentHashSet<Integer> brokerIdSet;
        this.brokerConfCache.put(entity.getBrokerId(), entity);
        Integer brokerId = this.brokerIpIndexCache.get(entity.getBrokerIp());
        if (brokerId == null || brokerId.intValue() != entity.getBrokerId()) {
            this.brokerIpIndexCache.put(entity.getBrokerIp(), entity.getBrokerId());
        }
        if ((brokerIdSet = this.regionIndexCache.get(entity.getRegionId())) == null) {
            ConcurrentHashSet<Integer> tmpBrokerIdSet = new ConcurrentHashSet();
            brokerIdSet = this.regionIndexCache.putIfAbsent(entity.getRegionId(), tmpBrokerIdSet);
            if (brokerIdSet == null) {
                brokerIdSet = tmpBrokerIdSet;
            }
        }
        brokerIdSet.add((Object)entity.getBrokerId());
    }

    protected abstract boolean putConfig2Persistent(BrokerConfEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(int var1, StringBuilder var2);

    private void delRecordFromCaches(int brokerId) {
        BrokerConfEntity curEntity = this.brokerConfCache.remove(brokerId);
        if (curEntity == null) {
            return;
        }
        this.brokerIpIndexCache.remove(curEntity.getBrokerIp());
        ConcurrentHashSet<Integer> brokerIdSet = this.regionIndexCache.get(curEntity.getRegionId());
        if (brokerIdSet == null) {
            return;
        }
        brokerIdSet.remove((Object)brokerId);
    }

    private boolean isValidMngStatusChange(BrokerConfEntity newEntity, BrokerConfEntity curEntity, StringBuilder strBuff, ProcessResult result) {
        if (newEntity.getManageStatus() == curEntity.getManageStatus()) {
            return true;
        }
        if (newEntity.getManageStatus().getCode() < ManageStatus.STATUS_MANAGE_ONLINE.getCode() && curEntity.getManageStatus().getCode() >= ManageStatus.STATUS_MANAGE_ONLINE.getCode() || newEntity.getManageStatus().getCode() > ManageStatus.STATUS_MANAGE_ONLINE.getCode() && curEntity.getManageStatus().getCode() < ManageStatus.STATUS_MANAGE_ONLINE.getCode()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append("Illegal manage status, cannot reverse ").append(WebFieldDef.MANAGESTATUS.name).append(" from ").append(curEntity.getManageStatus().getDescription()).append(" to ").append(newEntity.getManageStatus().getDescription()).append(" for the broker(").append(WebFieldDef.BROKERID.name).append("=").append(curEntity.getBrokerId()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        return true;
    }
}

