/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbTopicAuthControlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsTopicCtrlMapperImpl;

public class BdbTopicCtrlMapperImpl
extends AbsTopicCtrlMapperImpl {
    private EntityStore topicCtrlStore;
    private final PrimaryIndex<String, BdbTopicAuthControlEntity> topicCtrlIndex;

    public BdbTopicCtrlMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.topicCtrlStore = new EntityStore((Environment)repEnv, "bdbTopicAuthControl", storeConfig);
        this.topicCtrlIndex = this.topicCtrlStore.getPrimaryIndex(String.class, BdbTopicAuthControlEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.topicCtrlStore != null) {
            try {
                this.topicCtrlStore.close();
                this.topicCtrlStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close topic control failure ", e);
            }
        }
        logger.info("[BDB Impl] topic configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        EntityCursor cursor = null;
        logger.info("[BDB Impl] load topic configure start...");
        this.clearCachedData();
        try {
            cursor = this.topicCtrlIndex.entities();
            for (BdbTopicAuthControlEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] found Null data while loading topic control!");
                    continue;
                }
                this.putRecord2Caches(new TopicCtrlEntity(bdbEntity));
                ++totalCnt;
            }
        }
        catch (Exception e) {
            logger.error("[BDB Impl] load topic control failure ", (Throwable)e);
            throw new LoadMetaException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" topic control configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbTopicAuthControlEntity bdbEntity = entity.buildBdbTopicAuthControlEntity();
        try {
            this.topicCtrlIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put topic control failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put topic control configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(String topicName, StringBuilder strBuff) {
        try {
            this.topicCtrlIndex.delete((Object)topicName);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete topic control failure ", e);
            return false;
        }
        return true;
    }
}

