/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.EntityLookupConfiguration;
import org.springframework.data.rest.core.config.EntityLookupRegistrar;
import org.springframework.data.rest.core.config.EnumTranslationConfiguration;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.ResourceMapping;
import org.springframework.data.rest.core.config.ResourceMappingConfiguration;
import org.springframework.data.rest.core.mapping.ExposureConfiguration;
import org.springframework.data.rest.core.mapping.RepositoryDetectionStrategy;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.AnnotationLinkRelationProvider;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryRestConfiguration {
    static final URI NO_URI = URI.create("");
    private URI baseUri = NO_URI;
    private URI basePath = NO_URI;
    private int defaultPageSize = 20;
    private int maxPageSize = 1000;
    private String pageParamName = "page";
    private String limitParamName = "size";
    private String sortParamName = "sort";
    private MediaType defaultMediaType = MediaTypes.HAL_JSON;
    private boolean useHalAsDefaultJsonMediaType = true;
    private Boolean returnBodyOnCreate = null;
    private Boolean returnBodyOnUpdate = null;
    private List<Class<?>> exposeIdsFor = new ArrayList();
    private ResourceMappingConfiguration domainMappings = new ResourceMappingConfiguration();
    private ResourceMappingConfiguration repoMappings = new ResourceMappingConfiguration();
    private RepositoryDetectionStrategy repositoryDetectionStrategy = RepositoryDetectionStrategy.RepositoryDetectionStrategies.DEFAULT;
    private boolean exposeRepositoryMethodsByDefault = true;
    private final ProjectionDefinitionConfiguration projectionConfiguration;
    private final MetadataConfiguration metadataConfiguration;
    private final EntityLookupConfiguration entityLookupConfiguration;
    private final ExposureConfiguration exposureConfiguration;
    private final EnumTranslationConfiguration enumTranslationConfiguration;
    private LinkRelationProvider linkRelationProvider;
    private boolean enableEnumTranslation = false;

    public RepositoryRestConfiguration(ProjectionDefinitionConfiguration projectionConfiguration, MetadataConfiguration metadataConfiguration, EnumTranslationConfiguration enumTranslationConfiguration) {
        Assert.notNull((Object)projectionConfiguration, (String)"ProjectionDefinitionConfiguration must not be null!");
        Assert.notNull((Object)metadataConfiguration, (String)"MetadataConfiguration must not be null!");
        Assert.notNull((Object)enumTranslationConfiguration, (String)"EnumTranslationConfiguration must not be null!");
        this.projectionConfiguration = projectionConfiguration;
        this.metadataConfiguration = metadataConfiguration;
        this.enumTranslationConfiguration = enumTranslationConfiguration;
        this.entityLookupConfiguration = new EntityLookupConfiguration();
        this.exposureConfiguration = new ExposureConfiguration();
        this.linkRelationProvider = new DelegatingLinkRelationProvider(new LinkRelationProvider[]{new AnnotationLinkRelationProvider(), new EvoInflectorLinkRelationProvider()});
    }

    @Deprecated
    public URI getBaseUri() {
        return this.basePath != NO_URI ? this.basePath : this.baseUri;
    }

    public URI getBasePath() {
        return this.basePath;
    }

    public RepositoryRestConfiguration setBasePath(String basePath) {
        Assert.isTrue((!basePath.startsWith("http") ? 1 : 0) != 0, (String)"Use a path not a URI");
        basePath = StringUtils.trimTrailingCharacter((String)basePath, (char)'/');
        this.basePath = URI.create(basePath.startsWith("/") ? basePath : "/".concat(basePath));
        Assert.isTrue((!this.basePath.isAbsolute() ? 1 : 0) != 0, (String)"Absolute URIs are not supported as base path!");
        return this;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public RepositoryRestConfiguration setDefaultPageSize(int defaultPageSize) {
        Assert.isTrue((defaultPageSize > 0 ? 1 : 0) != 0, (String)"Page size must be greater than 0.");
        this.defaultPageSize = defaultPageSize;
        return this;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public RepositoryRestConfiguration setMaxPageSize(int maxPageSize) {
        Assert.isTrue((this.defaultPageSize > 0 ? 1 : 0) != 0, (String)"Maximum page size must be greater than 0.");
        this.maxPageSize = maxPageSize;
        return this;
    }

    public String getPageParamName() {
        return this.pageParamName;
    }

    public RepositoryRestConfiguration setPageParamName(String pageParamName) {
        Assert.notNull((Object)pageParamName, (String)"Page param name cannot be null.");
        this.pageParamName = pageParamName;
        return this;
    }

    public String getLimitParamName() {
        return this.limitParamName;
    }

    public RepositoryRestConfiguration setLimitParamName(String limitParamName) {
        Assert.notNull((Object)limitParamName, (String)"Limit param name cannot be null.");
        this.limitParamName = limitParamName;
        return this;
    }

    public String getSortParamName() {
        return this.sortParamName;
    }

    public RepositoryRestConfiguration setSortParamName(String sortParamName) {
        Assert.notNull((Object)sortParamName, (String)"Sort param name cannot be null.");
        this.sortParamName = sortParamName;
        return this;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public RepositoryRestConfiguration setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
        return this;
    }

    public boolean useHalAsDefaultJsonMediaType() {
        return this.useHalAsDefaultJsonMediaType;
    }

    public RepositoryRestConfiguration useHalAsDefaultJsonMediaType(boolean useHalAsDefaultJsonMediaType) {
        this.useHalAsDefaultJsonMediaType = useHalAsDefaultJsonMediaType;
        return this;
    }

    public RepositoryRestConfiguration setReturnBodyForPutAndPost(Boolean returnBody) {
        this.setReturnBodyOnCreate(returnBody);
        this.setReturnBodyOnUpdate(returnBody);
        return this;
    }

    @Deprecated
    public Boolean isReturnBodyOnCreate() {
        return this.returnBodyOnCreate;
    }

    public boolean returnBodyOnCreate(String acceptHeader) {
        return this.returnBodyOnCreate == null ? StringUtils.hasText((String)acceptHeader) : this.returnBodyOnCreate;
    }

    public RepositoryRestConfiguration setReturnBodyOnCreate(Boolean returnBody) {
        this.returnBodyOnCreate = returnBody;
        return this;
    }

    @Deprecated
    public Boolean isReturnBodyOnUpdate() {
        return this.returnBodyOnUpdate;
    }

    public boolean returnBodyOnUpdate(String acceptHeader) {
        return this.returnBodyOnUpdate == null ? StringUtils.hasText((String)acceptHeader) : this.returnBodyOnUpdate;
    }

    public RepositoryRestConfiguration setReturnBodyOnUpdate(Boolean returnBodyOnUpdate) {
        this.returnBodyOnUpdate = returnBodyOnUpdate;
        return this;
    }

    @Deprecated
    public ResourceMapping setResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.setResourceMappingFor(domainType);
    }

    @Deprecated
    public ResourceMapping getResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.getResourceMappingFor(domainType);
    }

    @Deprecated
    public boolean hasResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.hasResourceMappingFor(domainType);
    }

    @Deprecated
    public ResourceMappingConfiguration getDomainTypesResourceMappingConfiguration() {
        return this.domainMappings;
    }

    @Deprecated
    public ResourceMapping setResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.setResourceMappingFor(repositoryInterface);
    }

    @Deprecated
    public ResourceMapping getResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.getResourceMappingFor(repositoryInterface);
    }

    @Deprecated
    public boolean hasResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.hasResourceMappingFor(repositoryInterface);
    }

    @Deprecated
    public ResourceMapping findRepositoryMappingForPath(String path) {
        Class<?> type = this.repoMappings.findTypeForPath(path);
        if (null == type) {
            return null;
        }
        return this.repoMappings.getResourceMappingFor(type);
    }

    public boolean isIdExposedFor(Class<?> domainType) {
        return this.exposeIdsFor.contains(domainType);
    }

    public RepositoryRestConfiguration exposeIdsFor(Class<?> ... domainTypes) {
        Collections.addAll(this.exposeIdsFor, domainTypes);
        return this;
    }

    @Deprecated
    public ProjectionDefinitionConfiguration projectionConfiguration() {
        return this.getProjectionConfiguration();
    }

    public ProjectionDefinitionConfiguration getProjectionConfiguration() {
        return this.projectionConfiguration;
    }

    @Deprecated
    public MetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }

    public MetadataConfiguration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public RepositoryRestConfiguration setEnableEnumTranslation(boolean enableEnumTranslation) {
        this.enableEnumTranslation = enableEnumTranslation;
        return this;
    }

    public boolean isEnableEnumTranslation() {
        return this.enableEnumTranslation;
    }

    public EnumTranslationConfiguration getEnumTranslationConfiguration() {
        return this.enumTranslationConfiguration;
    }

    public RepositoryDetectionStrategy getRepositoryDetectionStrategy() {
        return this.repositoryDetectionStrategy;
    }

    public RepositoryRestConfiguration setRepositoryDetectionStrategy(RepositoryDetectionStrategy repositoryDetectionStrategy) {
        this.repositoryDetectionStrategy = repositoryDetectionStrategy == null ? RepositoryDetectionStrategy.RepositoryDetectionStrategies.DEFAULT : repositoryDetectionStrategy;
        return this;
    }

    public boolean exposeRepositoryMethodsByDefault() {
        return this.exposeRepositoryMethodsByDefault;
    }

    public void setExposeRepositoryMethodsByDefault(boolean exposeRepositoryMethodsByDefault) {
        this.exposeRepositoryMethodsByDefault = exposeRepositoryMethodsByDefault;
    }

    public void disableDefaultExposure() {
        this.setRepositoryDetectionStrategy(RepositoryDetectionStrategy.RepositoryDetectionStrategies.ANNOTATED);
        this.setExposeRepositoryMethodsByDefault(false);
    }

    public EntityLookupRegistrar withEntityLookup() {
        return this.entityLookupConfiguration;
    }

    public List<EntityLookup<?>> getEntityLookups(Repositories repositories) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        return this.entityLookupConfiguration.getEntityLookups(repositories);
    }

    public boolean isLookupType(Class<?> type) {
        return this.entityLookupConfiguration.isLookupType(type);
    }

    @Deprecated
    public LinkRelationProvider getRelProvider() {
        return this.linkRelationProvider;
    }

    @Deprecated
    public void setRelProvider(LinkRelationProvider relProvider) {
        this.setLinkRelationProvider(relProvider);
    }

    public LinkRelationProvider getLinkRelationProvider() {
        return this.linkRelationProvider;
    }

    public RepositoryRestConfiguration setLinkRelationProvider(LinkRelationProvider provider) {
        Assert.notNull((Object)provider, (String)"LinkRelationProvider must not be null!");
        this.linkRelationProvider = provider;
        return this;
    }

    public ExposureConfiguration getExposureConfiguration() {
        return this.exposureConfiguration;
    }
}

