/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.OutParameter;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.StatementConfiguration;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner() {
    }

    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public QueryRunner(DataSource ds) {
        super(ds);
    }

    public QueryRunner(StatementConfiguration stmtConfig) {
        super(stmtConfig);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public QueryRunner(DataSource ds, StatementConfiguration stmtConfig) {
        super(ds, stmtConfig);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken, StatementConfiguration stmtConfig) {
        super(ds, pmdKnownBroken, stmtConfig);
    }

    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.batch(conn, false, sql, params);
    }

    public int[] batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.batch(conn, true, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batch(Connection conn, boolean closeConn, String sql, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, (Object[])params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, param);
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.query(conn, false, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, (Object[])null);
    }

    @Deprecated
    public <T> T query(String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, param);
    }

    @Deprecated
    public <T> T query(String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (!closeConn) throw new SQLException("Null SQL statement");
            this.close(conn);
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (!closeConn) throw new SQLException("Null ResultSetHandler");
            this.close(conn);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        T result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rs = this.wrap(stmt.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, false, sql, (Object[])null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, false, sql, param);
    }

    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.update(conn, false, sql, params);
    }

    public int update(String sql) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, (Object[])null);
    }

    public int update(String sql, Object param) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, param);
    }

    public int update(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rows = stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.insert(this.prepareConnection(), true, sql, rsh, (Object[])null);
    }

    public <T> T insert(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.insert(this.prepareConnection(), true, sql, rsh, params);
    }

    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.insert(conn, false, sql, rsh, (Object[])null);
    }

    public <T> T insert(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.insert(conn, false, sql, rsh, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T insert(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        T generatedKeys = null;
        try {
            stmt = conn.prepareStatement(sql, 1);
            this.fillStatement(stmt, params);
            stmt.executeUpdate();
            ResultSet resultSet = stmt.getGeneratedKeys();
            generatedKeys = rsh.handle(resultSet);
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return generatedKeys;
    }

    public <T> T insertBatch(String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        return this.insertBatch(this.prepareConnection(), true, sql, rsh, params);
    }

    public <T> T insertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        return this.insertBatch(conn, false, sql, rsh, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T insertBatch(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        T generatedKeys = null;
        try {
            stmt = this.prepareStatement(conn, sql, 1);
            for (int i = 0; i < params.length; ++i) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
            }
            stmt.executeBatch();
            ResultSet rs = stmt.getGeneratedKeys();
            generatedKeys = rsh.handle(rs);
        }
        catch (SQLException e) {
            try {
                this.rethrow(e, sql, (Object[])params);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
                throw throwable;
            }
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        this.close(stmt);
        if (closeConn) {
            this.close(conn);
        }
        return generatedKeys;
    }

    public int execute(Connection conn, String sql, Object ... params) throws SQLException {
        return this.execute(conn, false, sql, params);
    }

    public int execute(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.execute(conn, true, sql, params);
    }

    public <T> List<T> execute(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.execute(conn, false, sql, rsh, params);
    }

    public <T> List<T> execute(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.execute(conn, true, sql, rsh, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        CallableStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareCall(conn, sql);
            this.fillStatement(stmt, params);
            stmt.execute();
            rows = stmt.getUpdateCount();
            this.retrieveOutParameters(stmt, params);
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> execute(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null ResultSetHandler");
        }
        CallableStatement stmt = null;
        LinkedList<T> results = new LinkedList<T>();
        try {
            stmt = this.prepareCall(conn, sql);
            this.fillStatement(stmt, params);
            boolean moreResultSets = stmt.execute();
            ResultSet rs = null;
            while (moreResultSets) {
                try {
                    rs = this.wrap(stmt.getResultSet());
                    results.add(rsh.handle(rs));
                    moreResultSets = stmt.getMoreResults();
                }
                finally {
                    this.close(rs);
                }
            }
            this.retrieveOutParameters(stmt, params);
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return results;
    }

    private void retrieveOutParameters(CallableStatement stmt, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof OutParameter)) continue;
                ((OutParameter)params[i]).setValue(stmt, i + 1);
            }
        }
    }
}

