/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.RankProcessStrategy;
import org.apache.flink.table.planner.plan.utils.RankUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AppendOnlyFirstNFunction;
import org.apache.flink.table.runtime.operators.rank.AppendOnlyTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ComparableRecordComparator;
import org.apache.flink.table.runtime.operators.rank.FastTop1Function;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.RetractableTopNFunction;
import org.apache.flink.table.runtime.operators.rank.UpdatableTopNFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-rank", version=1, consumedOptions={"table.exec.rank.topn-cache-size"}, producedTransformations={"rank"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecRank
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String RANK_TRANSFORMATION = "rank";
    public static final String FIELD_NAME_RANK_TYPE = "rankType";
    public static final String FIELD_NAME_PARTITION_SPEC = "partition";
    public static final String FIELD_NAME_SORT_SPEC = "orderBy";
    public static final String FIELD_NAME_RANK_RANG = "rankRange";
    public static final String FIELD_NAME_RANK_STRATEGY = "rankStrategy";
    public static final String FIELD_NAME_GENERATE_UPDATE_BEFORE = "generateUpdateBefore";
    public static final String FIELD_NAME_OUTPUT_RANK_NUMBER = "outputRowNumber";
    @JsonProperty(value="rankType")
    private final RankType rankType;
    @JsonProperty(value="partition")
    private final PartitionSpec partitionSpec;
    @JsonProperty(value="orderBy")
    private final SortSpec sortSpec;
    @JsonProperty(value="rankRange")
    private final RankRange rankRange;
    @JsonProperty(value="rankStrategy")
    private final RankProcessStrategy rankStrategy;
    @JsonProperty(value="outputRowNumber")
    private final boolean outputRankNumber;
    @JsonProperty(value="generateUpdateBefore")
    private final boolean generateUpdateBefore;

    public StreamExecRank(ReadableConfig tableConfig, RankType rankType, PartitionSpec partitionSpec, SortSpec sortSpec, RankRange rankRange, RankProcessStrategy rankStrategy, boolean outputRankNumber, boolean generateUpdateBefore, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecRank.class), ExecNodeContext.newPersistedConfig(StreamExecRank.class, tableConfig), rankType, partitionSpec, sortSpec, rankRange, rankStrategy, outputRankNumber, generateUpdateBefore, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecRank(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="rankType") RankType rankType, @JsonProperty(value="partition") PartitionSpec partitionSpec, @JsonProperty(value="orderBy") SortSpec sortSpec, @JsonProperty(value="rankRange") RankRange rankRange, @JsonProperty(value="rankStrategy") RankProcessStrategy rankStrategy, @JsonProperty(value="outputRowNumber") boolean outputRankNumber, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.rankType = (RankType)Preconditions.checkNotNull((Object)rankType);
        this.rankRange = (RankRange)Preconditions.checkNotNull((Object)rankRange);
        this.rankStrategy = (RankProcessStrategy)Preconditions.checkNotNull((Object)rankStrategy);
        this.sortSpec = (SortSpec)Preconditions.checkNotNull((Object)sortSpec);
        this.partitionSpec = (PartitionSpec)Preconditions.checkNotNull((Object)partitionSpec);
        this.outputRankNumber = outputRankNumber;
        this.generateUpdateBefore = generateUpdateBefore;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Object processFunction;
        switch (this.rankType) {
            case ROW_NUMBER: {
                break;
            }
            case RANK: {
                throw new TableException("RANK() on streaming table is not supported currently");
            }
            case DENSE_RANK: {
                throw new TableException("DENSE_RANK() on streaming table is not supported currently");
            }
            default: {
                throw new TableException(String.format("Streaming tables do not support %s rank function.", this.rankType));
            }
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        InternalTypeInfo inputRowTypeInfo = InternalTypeInfo.of((RowType)inputType);
        int[] sortFields = this.sortSpec.getFieldIndices();
        RowDataKeySelector sortKeySelector = KeySelectorUtil.getRowDataSelector(sortFields, (InternalTypeInfo<RowData>)inputRowTypeInfo);
        int[] sortKeyPositions = IntStream.range(0, sortFields.length).toArray();
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        IntStream.range(0, sortFields.length).forEach(idx -> builder.addField(idx, this.sortSpec.getFieldSpec(idx).getIsAscendingOrder(), this.sortSpec.getFieldSpec(idx).getNullIsLast()));
        SortSpec sortSpecInSortKey = builder.build();
        GeneratedRecordComparator sortKeyComparator = ComparatorCodeGenerator.gen(config.getTableConfig(), "StreamExecSortComparator", RowType.of((LogicalType[])this.sortSpec.getFieldTypes(inputType)), sortSpecInSortKey);
        long cacheSize = (Long)config.get(ExecutionConfigOptions.TABLE_EXEC_RANK_TOPN_CACHE_SIZE);
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig((long)config.getStateRetentionTime());
        if (this.rankStrategy instanceof RankProcessStrategy.AppendFastStrategy) {
            processFunction = sortFields.length == 1 && TypeCheckUtils.isProcTime((LogicalType)((LogicalType)inputType.getChildren().get(sortFields[0]))) && this.sortSpec.getFieldSpec(0).getIsAscendingOrder() ? new AppendOnlyFirstNFunction(ttlConfig, inputRowTypeInfo, sortKeyComparator, sortKeySelector, this.rankType, this.rankRange, this.generateUpdateBefore, this.outputRankNumber) : (RankUtil.isTop1(this.rankRange) ? new FastTop1Function(ttlConfig, inputRowTypeInfo, sortKeyComparator, sortKeySelector, this.rankType, this.rankRange, this.generateUpdateBefore, this.outputRankNumber, cacheSize) : new AppendOnlyTopNFunction(ttlConfig, inputRowTypeInfo, sortKeyComparator, sortKeySelector, this.rankType, this.rankRange, this.generateUpdateBefore, this.outputRankNumber, cacheSize));
        } else if (this.rankStrategy instanceof RankProcessStrategy.UpdateFastStrategy) {
            if (RankUtil.isTop1(this.rankRange)) {
                processFunction = new FastTop1Function(ttlConfig, inputRowTypeInfo, sortKeyComparator, sortKeySelector, this.rankType, this.rankRange, this.generateUpdateBefore, this.outputRankNumber, cacheSize);
            } else {
                RankProcessStrategy.UpdateFastStrategy updateFastStrategy = (RankProcessStrategy.UpdateFastStrategy)this.rankStrategy;
                int[] primaryKeys = updateFastStrategy.getPrimaryKeys();
                RowDataKeySelector rowKeySelector = KeySelectorUtil.getRowDataSelector(primaryKeys, (InternalTypeInfo<RowData>)inputRowTypeInfo);
                processFunction = new UpdatableTopNFunction(ttlConfig, inputRowTypeInfo, rowKeySelector, sortKeyComparator, sortKeySelector, this.rankType, this.rankRange, this.generateUpdateBefore, this.outputRankNumber, cacheSize);
            }
        } else if (this.rankStrategy instanceof RankProcessStrategy.RetractStrategy) {
            EqualiserCodeGenerator equaliserCodeGen = new EqualiserCodeGenerator((LogicalType[])inputType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new));
            GeneratedRecordEqualiser generatedEqualiser = equaliserCodeGen.generateRecordEqualiser("RankValueEqualiser");
            ComparableRecordComparator comparator = new ComparableRecordComparator(sortKeyComparator, sortKeyPositions, this.sortSpec.getFieldTypes(inputType), this.sortSpec.getAscendingOrders(), this.sortSpec.getNullsIsLast());
            processFunction = new RetractableTopNFunction(ttlConfig, inputRowTypeInfo, comparator, sortKeySelector, this.rankType, this.rankRange, generatedEqualiser, this.generateUpdateBefore, this.outputRankNumber);
        } else {
            throw new TableException(String.format("rank strategy:%s is not supported.", this.rankStrategy));
        }
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)processFunction);
        processFunction.setKeyContext((KeyContext)operator);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(RANK_TRANSFORMATION, config), operator, InternalTypeInfo.of((RowType)((RowType)this.getOutputType())), inputTransform.getParallelism());
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.partitionSpec.getFieldIndices(), (InternalTypeInfo<RowData>)inputRowTypeInfo);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }
}

