/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupCombineOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingGroupCombineOperator;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingSortedGroupCombineOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;

@Public
public class GroupCombineOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, GroupCombineOperator<IN, OUT>> {
    private final GroupCombineFunction<IN, OUT> function;
    private final Grouping<IN> grouper;
    private final String defaultName;

    public GroupCombineOperator(DataSet<IN> input, TypeInformation<OUT> resultType, GroupCombineFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.function = function;
        this.grouper = null;
        this.defaultName = defaultName;
    }

    public GroupCombineOperator(Grouping<IN> input, TypeInformation<OUT> resultType, GroupCombineFunction<IN, OUT> function, String defaultName) {
        super(input != null ? input.getInputDataSet() : null, resultType);
        this.function = function;
        this.grouper = input;
        this.defaultName = defaultName;
    }

    protected GroupCombineFunction<IN, OUT> getFunction() {
        return this.function;
    }

    @Override
    @Internal
    public SingleInputSemanticProperties getSemanticProperties() {
        SingleInputSemanticProperties props = super.getSemanticProperties();
        if (props != null && this.grouper != null && this.grouper.keys instanceof Keys.SelectorFunctionKeys) {
            int offset = ((Keys.SelectorFunctionKeys)this.grouper.keys).getKeyType().getTotalFields();
            if (this.grouper instanceof SortedGrouping) {
                offset += ((SortedGrouping)this.grouper).getSortSelectionFunctionKey().getKeyType().getTotalFields();
            }
            props = SemanticPropUtil.addSourceFieldOffset(props, this.getInputType().getTotalFields(), offset);
        }
        return props;
    }

    protected GroupCombineOperatorBase<?, OUT, ?> translateToDataFlow(Operator<IN> input) {
        String name;
        String string = name = this.getName() != null ? this.getName() : "GroupCombine at " + this.defaultName;
        if (this.grouper == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupCombineOperatorBase po = new GroupCombineOperatorBase(this.function, operatorInfo, new int[0], name);
            po.setInput(input);
            po.setParallelism(1);
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.SelectorFunctionKeys) {
            Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.grouper.getKeys();
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouping = (SortedGrouping)this.grouper;
                Keys.SelectorFunctionKeys sortKeys = sortedGrouping.getSortSelectionFunctionKey();
                Ordering groupOrder = sortedGrouping.getGroupOrdering();
                PlanUnwrappingSortedGroupCombineOperator po = GroupCombineOperator.translateSelectorFunctionSortedReducer(selectorKeys, sortKeys, groupOrder, this.function, this.getResultType(), name, input);
                po.setParallelism(this.getParallelism());
                return po;
            }
            PlanUnwrappingGroupCombineOperator po = GroupCombineOperator.translateSelectorFunctionReducer(selectorKeys, this.function, this.getResultType(), name, input);
            po.setParallelism(this.getParallelism());
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouper.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupCombineOperatorBase po = new GroupCombineOperatorBase(this.function, operatorInfo, logicalKeyPositions, name);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouper = (SortedGrouping)this.grouper;
                int[] sortKeyPositions = sortedGrouper.getGroupSortKeyPositions();
                Order[] sortOrders = sortedGrouper.getGroupSortOrders();
                Ordering o = new Ordering();
                for (int i = 0; i < sortKeyPositions.length; ++i) {
                    o.appendOrdering(Integer.valueOf(sortKeyPositions[i]), null, sortOrders[i]);
                }
                po.setGroupOrder(o);
            }
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    private static <IN, OUT, K> PlanUnwrappingGroupCombineOperator<IN, OUT, K> translateSelectorFunctionReducer(Keys.SelectorFunctionKeys<IN, ?> rawKeys, GroupCombineFunction<IN, OUT> function, TypeInformation<OUT> outputType, String name, Operator<IN> input) {
        Keys.SelectorFunctionKeys<IN, ?> keys = rawKeys;
        TypeInformation<Tuple2<?, IN>> typeInfoWithKey = KeyFunctions.createTypeWithKey(keys);
        Operator<Tuple2<?, IN>> keyedInput = KeyFunctions.appendKeyExtractor(input, keys);
        PlanUnwrappingGroupCombineOperator reducer = new PlanUnwrappingGroupCombineOperator(function, keys, name, outputType, typeInfoWithKey);
        reducer.setInput(keyedInput);
        return reducer;
    }

    private static <IN, OUT, K1, K2> PlanUnwrappingSortedGroupCombineOperator<IN, OUT, K1, K2> translateSelectorFunctionSortedReducer(Keys.SelectorFunctionKeys<IN, ?> rawGroupingKey, Keys.SelectorFunctionKeys<IN, ?> rawSortingKeys, Ordering groupOrder, GroupCombineFunction<IN, OUT> function, TypeInformation<OUT> outputType, String name, Operator<IN> input) {
        Keys.SelectorFunctionKeys<IN, ?> groupingKey = rawGroupingKey;
        Keys.SelectorFunctionKeys<IN, ?> sortingKey = rawSortingKeys;
        TypeInformation<Tuple3<?, ?, IN>> typeInfoWithKey = KeyFunctions.createTypeWithKey(groupingKey, sortingKey);
        Operator<Tuple3<?, ?, IN>> inputWithKey = KeyFunctions.appendKeyExtractor(input, groupingKey, sortingKey);
        PlanUnwrappingSortedGroupCombineOperator reducer = new PlanUnwrappingSortedGroupCombineOperator(function, groupingKey, sortingKey, name, outputType, typeInfoWithKey);
        reducer.setInput(inputWithKey);
        reducer.setGroupOrder(groupOrder);
        return reducer;
    }
}

