/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgSendReceiveStats
implements Runnable {
    private final boolean isProducer;
    private static final Logger logger = LoggerFactory.getLogger(MsgSendReceiveStats.class);
    private static final ConcurrentHashMap<String, AtomicLong> counterMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicLong> befCountMap = new ConcurrentHashMap();
    private final AtomicBoolean isStarted = new AtomicBoolean(true);

    public MsgSendReceiveStats(boolean isProducer) {
        this.isProducer = isProducer;
    }

    @Override
    public void run() {
        while (this.isStarted.get()) {
            try {
                for (Map.Entry<String, AtomicLong> entry : counterMap.entrySet()) {
                    long currCount = entry.getValue().get();
                    AtomicLong befCount = befCountMap.get(entry.getKey());
                    if (befCount == null) {
                        AtomicLong tmpCount = new AtomicLong(0L);
                        befCount = befCountMap.putIfAbsent(entry.getKey(), tmpCount);
                        if (befCount == null) {
                            befCount = tmpCount;
                        }
                    }
                    if (this.isProducer) {
                        logger.info("********* Current {} Message sent count is {}, dlt is {}", new Object[]{entry.getKey(), currCount, currCount - befCount.get()});
                    } else {
                        logger.info("********* Current {} Message received count is {}, dlt is {}", new Object[]{entry.getKey(), currCount, currCount - befCount.get()});
                    }
                    befCountMap.get(entry.getKey()).set(currCount);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ThreadUtils.sleep((long)30000L);
        }
    }

    public void addMsgCount(String topicName, int msgCnt) {
        if (msgCnt > 0) {
            AtomicLong tmpCount;
            AtomicLong currCount = counterMap.get(topicName);
            if (currCount == null && (currCount = counterMap.putIfAbsent(topicName, tmpCount = new AtomicLong(0L))) == null) {
                currCount = tmpCount;
            }
            if (currCount.addAndGet(msgCnt) % 1000L == 0L) {
                if (this.isProducer) {
                    logger.info("Sent " + topicName + " messages:" + currCount.get());
                } else {
                    logger.info("Received " + topicName + " messages:" + currCount.get());
                }
            }
        }
    }

    public void stopStats() {
        this.isStarted.set(false);
    }
}

