/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.common;

import org.apache.inlong.sdk.dataproxy.common.ErrorCode;

public class ProcessResult {
    private int errCode = ErrorCode.UNKNOWN_ERROR.getErrCode();
    private String errMsg = ErrorCode.UNKNOWN_ERROR.getErrMsg();
    private Object retData = null;

    public ProcessResult() {
    }

    public ProcessResult(ErrorCode errCode) {
        this.errCode = errCode.getErrCode();
        this.errMsg = errCode.getErrMsg();
    }

    public ProcessResult(ErrorCode errCode, String errMsg) {
        this.errCode = errCode.getErrCode();
        this.errMsg = errMsg;
    }

    public boolean setSuccess() {
        this.errCode = ErrorCode.OK.getErrCode();
        this.errMsg = ErrorCode.OK.getErrMsg();
        this.retData = null;
        return this.isSuccess();
    }

    public boolean setSuccess(Object retData) {
        this.errCode = ErrorCode.OK.getErrCode();
        this.errMsg = ErrorCode.OK.getErrMsg();
        this.retData = retData;
        return this.isSuccess();
    }

    public boolean setFailResult(ProcessResult other) {
        this.errCode = other.getErrCode();
        this.errMsg = other.getErrMsg();
        this.retData = other.getRetData();
        return this.isSuccess();
    }

    public boolean setFailResult(ErrorCode errCode) {
        this.errCode = errCode.getErrCode();
        this.errMsg = errCode.getErrMsg();
        this.retData = null;
        return this.isSuccess();
    }

    public boolean setFailResult(ErrorCode errCode, String errMsg) {
        this.errCode = errCode.getErrCode();
        this.errMsg = errMsg;
        this.retData = null;
        return this.isSuccess();
    }

    public boolean isSuccess() {
        return this.errCode == ErrorCode.OK.getErrCode();
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public Object getRetData() {
        return this.retData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProcessResult{");
        sb.append("errCode=").append(this.errCode);
        sb.append(", errMsg='").append(this.errMsg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

