/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq.tube;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.sink.common.EventHandler;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfile;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSinkContext;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;
import org.apache.inlong.dataproxy.utils.DateTimeUtils;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.corebase.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeHandler
implements MessageQueueHandler {
    private static final Logger logger = LoggerFactory.getLogger(TubeHandler.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private static String MASTER_HOST_PORT_LIST = "master-host-port-list";
    private CacheClusterConfig config;
    private String clusterName;
    private MessageQueueZoneSinkContext sinkContext;
    private String masterHostAndPortList;
    private long linkMaxAllowedDelayedMsgCount;
    private long sessionWarnDelayedMsgCount;
    private long sessionMaxAllowedDelayedMsgCount;
    private long nettyWriteBufferHighWaterMark;
    private TubeMultiSessionFactory sessionFactory;
    private MessageProducer producer;
    private final Set<String> topicSet = new HashSet<String>();
    private final ThreadLocal<EventHandler> handlerLocal = new ThreadLocal();

    @Override
    public void init(CacheClusterConfig config, MessageQueueZoneSinkContext sinkContext) {
        this.config = config;
        this.clusterName = config.getClusterName();
        this.sinkContext = sinkContext;
    }

    @Override
    public void start() {
        try {
            TubeClientConfig conf = this.initTubeConfig();
            logger.info("try to create producer:{}", (Object)conf.toJsonString());
            this.sessionFactory = new TubeMultiSessionFactory(conf);
            this.producer = this.sessionFactory.createProducer();
            logger.info("create new producer success:{}", (Object)this.producer);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void publishTopic(Set<String> newTopicSet) {
        if (this.producer == null || newTopicSet == null || newTopicSet.isEmpty()) {
            return;
        }
        try {
            Set published = this.producer.publish(newTopicSet);
            this.topicSet.addAll(newTopicSet);
            logger.info("Publish topics to {}, need publish are {}, published are {}", new Object[]{this.clusterName, newTopicSet, published});
        }
        catch (Throwable e) {
            logger.warn("Publish topics to {} failure", (Object)this.clusterName, (Object)e);
        }
    }

    private TubeClientConfig initTubeConfig() throws Exception {
        Context context = this.sinkContext.getProducerContext();
        Context configContext = new Context(context.getParameters());
        configContext.putAll(this.config.getParams());
        this.masterHostAndPortList = configContext.getString(MASTER_HOST_PORT_LIST);
        this.linkMaxAllowedDelayedMsgCount = configContext.getLong("link_max_allowed_delayed_msg_count", Long.valueOf(80000L));
        this.sessionWarnDelayedMsgCount = configContext.getLong("session_warn_delayed_msg_count", Long.valueOf(2000000L));
        this.sessionMaxAllowedDelayedMsgCount = configContext.getLong("session_max_allowed_delayed_msg_count", Long.valueOf(4000000L));
        this.nettyWriteBufferHighWaterMark = configContext.getLong("netty_write_buffer_high_water_mark", Long.valueOf(0xF00000L));
        TubeClientConfig tubeClientConfig = new TubeClientConfig(this.masterHostAndPortList);
        tubeClientConfig.setLinkMaxAllowedDelayedMsgCount(this.linkMaxAllowedDelayedMsgCount);
        tubeClientConfig.setSessionWarnDelayedMsgCount(this.sessionWarnDelayedMsgCount);
        tubeClientConfig.setSessionMaxAllowedDelayedMsgCount(this.sessionMaxAllowedDelayedMsgCount);
        tubeClientConfig.setNettyWriteBufferHighWaterMark(this.nettyWriteBufferHighWaterMark);
        tubeClientConfig.setHeartbeatPeriodMs(15000L);
        tubeClientConfig.setRpcTimeoutMs(20000L);
        return tubeClientConfig;
    }

    @Override
    public void stop() {
        if (this.producer != null) {
            try {
                this.producer.shutdown();
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.shutdown();
            }
            catch (TubeClientException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("tube handler stopped");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(PackProfile profile) {
        String topic = null;
        try {
            IdTopicConfig idConfig = ConfigManager.getInstance().getSinkIdTopicConfig(profile.getInlongGroupId(), profile.getInlongStreamId());
            if (idConfig == null) {
                if (!CommonConfigHolder.getInstance().isEnableUnConfigTopicAccept()) {
                    this.sinkContext.fileMetricIncWithDetailStats("sink.topic.missing", profile.getUid());
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                topic = CommonConfigHolder.getInstance().getRandDefTopics();
                if (StringUtils.isEmpty((CharSequence)topic)) {
                    this.sinkContext.fileMetricIncWithDetailStats("default.topic.empty", profile.getUid());
                    this.sinkContext.addSendResultMetric(profile, this.clusterName, profile.getUid(), false, 0L);
                    this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(profile);
                    profile.fail(DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE, "");
                    return false;
                }
                this.sinkContext.fileMetricIncWithDetailStats("default.topic.used", profile.getUid());
            } else {
                topic = idConfig.getTopicName();
            }
            if (this.producer == null) {
                this.sinkContext.fileMetricIncWithDetailStats("sink.producer.null", topic);
                this.sinkContext.processSendFail(profile, this.clusterName, topic, 0L, DataProxyErrCode.PRODUCER_IS_NULL, "");
                return false;
            }
            if (!this.topicSet.contains(topic)) {
                this.producer.publish(topic);
                this.topicSet.add(topic);
            }
            if (profile instanceof SimplePackProfile) {
                this.sendSimplePackProfile((SimplePackProfile)profile, idConfig, topic);
                return true;
            }
            this.sendBatchPackProfile((BatchPackProfile)profile, idConfig, topic);
            return true;
        }
        catch (Throwable ex) {
            this.sinkContext.fileMetricIncWithDetailStats("sink.send.exception", topic);
            this.sinkContext.processSendFail(profile, this.clusterName, profile.getUid(), 0L, DataProxyErrCode.SEND_REQUEST_TO_MQ_FAILURE, ex.getMessage());
            if (!logCounter.shouldPrint()) return false;
            logger.error("Send Message to Tube failure", ex);
            return false;
        }
    }

    private void sendBatchPackProfile(final BatchPackProfile batchProfile, IdTopicConfig idConfig, final String topic) throws Exception {
        EventHandler handler = this.handlerLocal.get();
        if (handler == null) {
            handler = this.sinkContext.createEventHandler();
            this.handlerLocal.set(handler);
        }
        Map<String, String> headers = handler.parseHeader(idConfig, batchProfile, this.sinkContext.getNodeId(), this.sinkContext.getCompressType());
        byte[] bodyBytes = handler.parseBody(idConfig, batchProfile, this.sinkContext.getCompressType());
        Message message = new Message(topic, bodyBytes);
        long dataTimeL = Long.parseLong(headers.get("packTime"));
        message.putSystemHeader(batchProfile.getInlongStreamId(), DateTimeUtils.ms2yyyyMMddHHmm(dataTimeL));
        headers.forEach((arg_0, arg_1) -> ((Message)message).setAttrKeyVal(arg_0, arg_1));
        this.sinkContext.addSendMetric(batchProfile, this.clusterName, topic, bodyBytes.length);
        final long sendTime = System.currentTimeMillis();
        MessageSentCallback callback = new MessageSentCallback(){

            public void onMessageSent(MessageSentResult result) {
                if (result.isSuccess()) {
                    TubeHandler.this.sinkContext.fileMetricIncSumStats("sink.success");
                    TubeHandler.this.sinkContext.addSendResultMetric(batchProfile, TubeHandler.this.clusterName, topic, true, sendTime);
                    TubeHandler.this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(batchProfile);
                    batchProfile.ack();
                } else {
                    TubeHandler.this.sinkContext.fileMetricIncWithDetailStats("sink.failure", topic + "." + result.getErrCode());
                    TubeHandler.this.sinkContext.processSendFail(batchProfile, TubeHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, result.getErrMsg());
                    if (logCounter.shouldPrint()) {
                        logger.error("Send ProfileV1 to tube failure {}", (Object)result.getErrMsg());
                    }
                }
            }

            public void onException(Throwable ex) {
                TubeHandler.this.sinkContext.fileMetricIncWithDetailStats("sink.rcvexcept", topic);
                TubeHandler.this.sinkContext.processSendFail(batchProfile, TubeHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                if (logCounter.shouldPrint()) {
                    logger.error("Send ProfileV1 to tube exception", ex);
                }
            }
        };
        this.producer.sendMessage(message, callback);
    }

    private void sendSimplePackProfile(final SimplePackProfile simpleProfile, IdTopicConfig idConfig, final String topic) throws Exception {
        this.sinkContext.addSendMetric(simpleProfile, this.clusterName, topic, simpleProfile.getEvent().getBody().length);
        Message message = new Message(topic, simpleProfile.getEvent().getBody());
        long dataTimeL = Long.parseLong(simpleProfile.getProperties().get("msg.pkg.time"));
        message.putSystemHeader(simpleProfile.getInlongStreamId(), DateTimeUtils.ms2yyyyMMddHHmm(dataTimeL));
        final long sendTime = System.currentTimeMillis();
        Map<String, String> headers = simpleProfile.getPropsToMQ(sendTime);
        headers.forEach((arg_0, arg_1) -> ((Message)message).setAttrKeyVal(arg_0, arg_1));
        MessageSentCallback callback = new MessageSentCallback(){

            public void onMessageSent(MessageSentResult result) {
                if (result.isSuccess()) {
                    TubeHandler.this.sinkContext.fileMetricAddSuccStats(simpleProfile, topic, result.getPartition().getHost());
                    TubeHandler.this.sinkContext.addSendResultMetric(simpleProfile, TubeHandler.this.clusterName, topic, true, sendTime);
                    TubeHandler.this.sinkContext.getMqZoneSink().releaseAcquiredSizePermit(simpleProfile);
                    simpleProfile.ack();
                } else {
                    TubeHandler.this.sinkContext.fileMetricAddFailStats(simpleProfile, topic, result.getPartition().getHost(), topic + "." + result.getErrCode());
                    TubeHandler.this.sinkContext.processSendFail(simpleProfile, TubeHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, result.getErrMsg());
                    if (logCounter.shouldPrint()) {
                        logger.error("Send SimpleProfileV0 to tube failure: {}", (Object)result.getErrMsg());
                    }
                }
            }

            public void onException(Throwable ex) {
                TubeHandler.this.sinkContext.fileMetricAddExceptStats(simpleProfile, topic, "", topic);
                TubeHandler.this.sinkContext.processSendFail(simpleProfile, TubeHandler.this.clusterName, topic, sendTime, DataProxyErrCode.MQ_RETURN_ERROR, ex.getMessage());
                if (logCounter.shouldPrint()) {
                    logger.error("Send Message to {} tube exception", (Object)topic, (Object)ex);
                }
            }
        };
        this.producer.sendMessage(message, callback);
    }
}

