/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import io.netty.channel.Channel;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.dataproxy.utils.ConfStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtils {
    private static final Logger logger = LoggerFactory.getLogger(AddressUtils.class);
    private static final String localIp = AddressUtils.getLocalIp();

    public static String getLocalIp() {
        if (localIp != null) {
            return localIp;
        }
        String ip = "127.0.0.1";
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        return ip;
    }

    public static String getChannelLocalIP(Channel channel) {
        return AddressUtils.getChannelIP(channel, true);
    }

    public static String getChannelRemoteIP(Channel channel) {
        return AddressUtils.getChannelIP(channel, false);
    }

    private static String getChannelIP(Channel channel, boolean isLocal) {
        SocketAddress address;
        if (channel == null) {
            return null;
        }
        SocketAddress socketAddress = address = isLocal ? channel.localAddress() : channel.remoteAddress();
        if (address == null) {
            return null;
        }
        String strAddrIP = address.toString();
        try {
            strAddrIP = strAddrIP.substring(1, strAddrIP.indexOf(58));
            return strAddrIP;
        }
        catch (Exception ee) {
            if (isLocal) {
                logger.warn("Fail to get the local IP, localAddress = {}", (Object)address);
            } else {
                logger.warn("Fail to get the remote IP, remoteAddress = {}", (Object)address);
            }
            return null;
        }
    }

    public static String getSelfHost() {
        String localIp = null;
        Map<String, String> envMap = System.getenv();
        if (envMap.containsKey("inlongHostIp")) {
            String tmpVal = envMap.get("inlongHostIp");
            if (ConfStringUtils.isValidIp(tmpVal)) {
                localIp = tmpVal.trim();
            } else {
                logger.error("{}({}) config in system env not valid", (Object)"inlongHostIp", (Object)tmpVal);
            }
        }
        if (StringUtils.isBlank(localIp) || "127.0.0.1".equals(localIp) || "0.0.0.0".equals(localIp)) {
            localIp = AddressUtils.getLocalIp();
        }
        return localIp;
    }
}

