/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import java.util.Arrays;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class AsciiSet {
    private final boolean[] store;

    public static Builder create() {
        return new Builder();
    }

    public static AsciiSet of(String value) {
        return new Builder().chars(value).build();
    }

    AsciiSet(boolean[] store) {
        this.store = Arrays.copyOf(store, store.length);
    }

    public boolean contains(char value) {
        if (value > '\u007f') {
            return false;
        }
        return this.store[value];
    }

    public boolean contains(CharSequence value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!this.contains(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int value) {
        if (value < 0 || value > 127) {
            return false;
        }
        return this.store[value];
    }

    public boolean containsOnly(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (this.contains(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Builder copy() {
        Builder b = new Builder();
        System.arraycopy(this.store, 0, b.store, 0, 128);
        return b;
    }

    public static class Builder {
        final boolean[] store = new boolean[128];

        public AsciiSet build() {
            return new AsciiSet(this.store);
        }

        public Builder chars(char ... value) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] >= '\u0080') continue;
                this.store[value[i]] = true;
            }
            return this;
        }

        public Builder chars(String value) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') continue;
                this.store[c] = true;
            }
            return this;
        }

        public Builder range(char start, char end) {
            for (char c = start; c <= end; c = (char)(c + '\u0001')) {
                if (c >= '\u0080') continue;
                this.store[c] = true;
            }
            return this;
        }

        public Builder ranges(String ... value) {
            for (String ss : value) {
                if (ss.length() != 3 || ss.charAt(1) != '-') {
                    throw ThrowableUtils.illegalArg("Value passed to ranges() must be 3 characters", new Object[0]);
                }
                this.range(ss.charAt(0), ss.charAt(2));
            }
            return this;
        }
    }
}

