/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.Utils;

public class InvalidAnnotationException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    @SafeVarargs
    public static void assertNoInvalidAnnotations(MethodInfo onMethod, Class<? extends Annotation> ... types) throws InvalidAnnotationException {
        Arrays.stream(types).map(t -> onMethod.getAnnotations(t).findFirst().map(AnnotationInfo::inner).orElse(null)).filter(Objects::nonNull).findFirst().ifPresent(a -> {
            throw new InvalidAnnotationException("@{0} annotation cannot be used in a @{1} bean.  Method=''{2}''", Utils.cns((Object)a), Utils.cns((Object)onMethod.getDeclaringClass()), onMethod);
        });
    }

    public InvalidAnnotationException(String message, Object ... args) {
        super(message, args);
    }

    @Override
    public InvalidAnnotationException setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }
}

