/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerIdNotRegisteredException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveDelegationTokenRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.RemoveUserScramCredentialRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ActivationRecordsGenerator;
import org.apache.kafka.controller.ClientQuotaControlManager;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ClusterFeatureSupportDescriber;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.ControllerResultAndOffset;
import org.apache.kafka.controller.DelegationTokenControlManager;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.LogReplayTracker;
import org.apache.kafka.controller.OffsetControlManager;
import org.apache.kafka.controller.ProducerIdControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.ReplicationControlManager;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.controller.ScramControlManager;
import org.apache.kafka.controller.errors.ControllerExceptions;
import org.apache.kafka.controller.errors.EventHandlerExceptionInfo;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.deferred.DeferredEvent;
import org.apache.kafka.deferred.DeferredEventQueue;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.metadata.migration.ZkRecordConsumer;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.util.RecordRedactor;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.FaultHandlerException;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.kafka.snapshot.SnapshotReader;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.slf4j.Logger;

public final class QuorumController
implements Controller {
    private static final int MAX_RECORDS_PER_BATCH = 10000;
    static final int MAX_RECORDS_PER_USER_OP = 10000;
    static final String MAYBE_FENCE_REPLICAS = "maybeFenceReplicas";
    private static final String MAYBE_BALANCE_PARTITION_LEADERS = "maybeBalancePartitionLeaders";
    private static final String MAYBE_ELECT_UNCLEAN_LEADERS = "maybeElectUncleanLeaders";
    private static final String WRITE_NO_OP_RECORD = "writeNoOpRecord";
    private static final String SWEEP_EXPIRED_DELEGATION_TOKENS = "sweepExpiredDelegationTokens";
    private final FaultHandler nonFatalFaultHandler;
    private final FaultHandler fatalFaultHandler;
    private final Logger log;
    private final int nodeId;
    private final String clusterId;
    private final KafkaEventQueue queue;
    private final Time time;
    private final QuorumControllerMetrics controllerMetrics;
    private final SnapshotRegistry snapshotRegistry;
    private final DeferredEventQueue deferredEventQueue;
    private final DeferredEventQueue deferredUnstableEventQueue;
    private final OffsetControlManager offsetControl;
    private final Consumer<ConfigResource> resourceExists;
    private final ConfigurationControlManager configurationControl;
    private final ClientQuotaControlManager clientQuotaControlManager;
    private final QuorumClusterFeatureSupportDescriber clusterSupportDescriber;
    private final ClusterControlManager clusterControl;
    private final FeatureControlManager featureControl;
    private final ProducerIdControlManager producerIdControlManager;
    private final ReplicationControlManager replicationControl;
    private final ScramControlManager scramControlManager;
    private final long delegationTokenExpiryCheckIntervalMs;
    private final DelegationTokenControlManager delegationTokenControlManager;
    private final AclControlManager aclControlManager;
    private final LogReplayTracker logReplayTracker;
    private final RaftClient<ApiMessageAndVersion> raftClient;
    private final QuorumMetaLogListener metaLogListener;
    private volatile int curClaimEpoch;
    private final OptionalLong leaderImbalanceCheckIntervalNs;
    private final OptionalLong maxIdleIntervalNs;
    private ImbalanceSchedule imbalancedScheduled = ImbalanceSchedule.DEFERRED;
    private ImbalanceSchedule uncleanScheduled = ImbalanceSchedule.DEFERRED;
    private boolean noOpRecordScheduled = false;
    private final BootstrapMetadata bootstrapMetadata;
    private final ZkRecordConsumer zkRecordConsumer;
    private final boolean zkMigrationEnabled;
    private final boolean eligibleLeaderReplicasEnabled;
    private final long uncleanLeaderElectionCheckIntervalNs;
    private final int maxRecordsPerBatch;
    private final RecordRedactor recordRedactor;

    private OptionalInt latestController() {
        return this.raftClient.leaderAndEpoch().leaderId();
    }

    private void handleEventEnd(String name, long startProcessingTimeNs) {
        long endProcessingTime = this.time.nanoseconds();
        long deltaNs = endProcessingTime - startProcessingTimeNs;
        this.log.debug("Processed {} in {} us", (Object)name, (Object)TimeUnit.MICROSECONDS.convert(deltaNs, TimeUnit.NANOSECONDS));
        this.controllerMetrics.updateEventQueueProcessingTime(TimeUnit.NANOSECONDS.toMillis(deltaNs));
    }

    private Throwable handleEventException(String name, OptionalLong startProcessingTimeNs, Throwable exception) {
        OptionalLong deltaUs;
        if (startProcessingTimeNs.isPresent()) {
            long endProcessingTime = this.time.nanoseconds();
            long deltaNs = endProcessingTime - startProcessingTimeNs.getAsLong();
            deltaUs = OptionalLong.of(TimeUnit.MICROSECONDS.convert(deltaNs, TimeUnit.NANOSECONDS));
        } else {
            deltaUs = OptionalLong.empty();
        }
        EventHandlerExceptionInfo info = EventHandlerExceptionInfo.fromInternal(exception, () -> this.latestController());
        int epoch = this.curClaimEpoch;
        if (epoch == -1) {
            epoch = this.offsetControl.lastCommittedEpoch();
        }
        String failureMessage = info.failureMessage(epoch, deltaUs, this.isActiveController(), this.offsetControl.lastCommittedOffset());
        if (info.isTimeoutException() && !deltaUs.isPresent()) {
            this.controllerMetrics.incrementOperationsTimedOut();
        }
        if (info.isFault()) {
            this.nonFatalFaultHandler.handleFault(name + ": " + failureMessage, exception);
        } else {
            this.log.info("{}: {}", (Object)name, (Object)failureMessage);
        }
        if (info.causesFailover() && this.isActiveController()) {
            this.renounce();
        }
        return info.effectiveExternalException();
    }

    private long updateEventStartMetricsAndGetTime(OptionalLong eventCreatedTimeNs) {
        long now = this.time.nanoseconds();
        this.controllerMetrics.incrementOperationsStarted();
        if (eventCreatedTimeNs.isPresent()) {
            this.controllerMetrics.updateEventQueueTime(TimeUnit.NANOSECONDS.toMillis(now - eventCreatedTimeNs.getAsLong()));
        }
        return now;
    }

    void appendControlEvent(String name, Runnable handler) {
        ControllerEvent event = new ControllerEvent(name, handler);
        this.queue.append((EventQueue.Event)event);
    }

    void appendControlEventWithDeadline(String name, Runnable handler, long deadlineNs) {
        ControllerEvent event = new ControllerEvent(name, handler);
        this.queue.appendWithDeadline(deadlineNs, (EventQueue.Event)event);
    }

    OffsetControlManager offsetControl() {
        return this.offsetControl;
    }

    ReplicationControlManager replicationControl() {
        return this.replicationControl;
    }

    ClusterControlManager clusterControl() {
        return this.clusterControl;
    }

    FeatureControlManager featureControl() {
        return this.featureControl;
    }

    ConfigurationControlManager configurationControl() {
        return this.configurationControl;
    }

    public ZkRecordConsumer zkRecordConsumer() {
        return this.zkRecordConsumer;
    }

    <T> CompletableFuture<T> appendReadEvent(String name, OptionalLong deadlineNs, Supplier<T> handler) {
        ControllerReadEvent<T> event = new ControllerReadEvent<T>(name, handler);
        if (deadlineNs.isPresent()) {
            this.queue.appendWithDeadline(deadlineNs.getAsLong(), event);
        } else {
            this.queue.append(event);
        }
        return event.future();
    }

    static long appendRecords(Logger log, ControllerResult<?> result, int maxRecordsPerBatch, Function<List<ApiMessageAndVersion>, Long> appender) {
        try {
            List<ApiMessageAndVersion> records = result.records();
            if (result.isAtomic()) {
                if (records.size() > maxRecordsPerBatch) {
                    throw new IllegalStateException("Attempted to atomically commit " + records.size() + " records, but maxRecordsPerBatch is " + maxRecordsPerBatch);
                }
                long offset = appender.apply(records);
                if (log.isTraceEnabled()) {
                    log.trace("Atomically appended {} record(s) ending with offset {}.", (Object)records.size(), (Object)offset);
                }
                return offset;
            }
            int startIndex = 0;
            int numBatches = 0;
            while (true) {
                ++numBatches;
                int endIndex = startIndex + maxRecordsPerBatch;
                if (endIndex > records.size()) {
                    long offset = appender.apply(records.subList(startIndex, records.size()));
                    if (log.isTraceEnabled()) {
                        log.trace("Appended {} record(s) in {} batch(es), ending with offset {}.", new Object[]{records.size(), numBatches, offset});
                    }
                    return offset;
                }
                appender.apply(records.subList(startIndex, endIndex));
                startIndex += maxRecordsPerBatch;
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    <T> CompletableFuture<T> appendWriteEvent(String name, OptionalLong deadlineNs, ControllerWriteOperation<T> op) {
        return this.appendWriteEvent(name, deadlineNs, op, EnumSet.noneOf(ControllerOperationFlag.class));
    }

    <T> CompletableFuture<T> appendWriteEvent(String name, OptionalLong deadlineNs, ControllerWriteOperation<T> op, EnumSet<ControllerOperationFlag> flags) {
        ControllerWriteEvent<T> event = new ControllerWriteEvent<T>(name, op, flags);
        if (deadlineNs.isPresent()) {
            this.queue.appendWithDeadline(deadlineNs.getAsLong(), event);
        } else {
            this.queue.append(event);
        }
        return event.future();
    }

    private boolean isActiveController() {
        return QuorumController.isActiveController(this.curClaimEpoch);
    }

    private static boolean isActiveController(int claimEpoch) {
        return claimEpoch != -1;
    }

    private void claim(int epoch, long newNextWriteOffset) {
        try {
            if (this.curClaimEpoch != -1) {
                throw new RuntimeException("Cannot claim leadership because we are already the active controller.");
            }
            this.curClaimEpoch = epoch;
            this.offsetControl.activate(newNextWriteOffset);
            this.clusterControl.activate();
            ControllerWriteEvent<Void> activationEvent = new ControllerWriteEvent<Void>("completeActivation[" + epoch + "]", new CompleteActivationEvent(), EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME, ControllerOperationFlag.RUNS_IN_PREMIGRATION));
            this.queue.prepend(activationEvent);
        }
        catch (Throwable e) {
            this.fatalFaultHandler.handleFault("exception while claiming leadership", e);
        }
    }

    void renounce() {
        try {
            if (this.curClaimEpoch == -1) {
                throw new RuntimeException("Cannot renounce leadership because we are not the current leader.");
            }
            this.raftClient.resign(this.curClaimEpoch);
            this.curClaimEpoch = -1;
            this.deferredEventQueue.failAll((Exception)ControllerExceptions.newWrongControllerException(OptionalInt.empty()));
            this.deferredUnstableEventQueue.failAll((Exception)ControllerExceptions.newWrongControllerException(OptionalInt.empty()));
            this.offsetControl.deactivate();
            this.clusterControl.deactivate();
            this.cancelMaybeFenceReplicas();
            this.cancelMaybeBalancePartitionLeaders();
            this.cancelMaybeNextElectUncleanLeaders();
            this.cancelNextWriteNoOpRecord();
        }
        catch (Throwable e) {
            this.fatalFaultHandler.handleFault("exception while renouncing leadership", e);
        }
    }

    private <T> void scheduleDeferredWriteEvent(String name, long deadlineNs, ControllerWriteOperation<T> op, EnumSet<ControllerOperationFlag> flags) {
        if (!flags.contains((Object)ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME)) {
            throw new RuntimeException("deferred events should not update the queue time.");
        }
        ControllerWriteEvent<T> event = new ControllerWriteEvent<T>(name, op, flags);
        this.queue.scheduleDeferred(name, (Function)new EventQueue.EarliestDeadlineFunction(deadlineNs), event);
        ((ControllerWriteEvent)event).future.exceptionally(e -> {
            if (ControllerExceptions.isTimeoutException(e)) {
                this.log.error("Cancelling deferred write event {} because the event queue is now closed.", (Object)name);
                return null;
            }
            if (e instanceof NotControllerException) {
                this.log.debug("Cancelling deferred write event {} because this controller is no longer active.", (Object)name);
                return null;
            }
            this.log.error("Unexpected exception while executing deferred write event {}. Rescheduling for a minute from now.", (Object)name, e);
            this.scheduleDeferredWriteEvent(name, deadlineNs + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES), op, flags);
            return null;
        });
    }

    private void rescheduleMaybeFenceStaleBrokers() {
        long nextCheckTimeNs = this.clusterControl.heartbeatManager().nextCheckTimeNs();
        if (nextCheckTimeNs == Long.MAX_VALUE) {
            this.cancelMaybeFenceReplicas();
            return;
        }
        this.scheduleDeferredWriteEvent(MAYBE_FENCE_REPLICAS, nextCheckTimeNs, () -> {
            ControllerResult<Void> result = this.replicationControl.maybeFenceOneStaleBroker();
            this.rescheduleMaybeFenceStaleBrokers();
            return result;
        }, EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME));
    }

    private void cancelMaybeFenceReplicas() {
        this.queue.cancelDeferred(MAYBE_FENCE_REPLICAS);
    }

    private void maybeScheduleNextBalancePartitionLeaders() {
        if (this.imbalancedScheduled != ImbalanceSchedule.SCHEDULED && this.leaderImbalanceCheckIntervalNs.isPresent() && this.replicationControl.arePartitionLeadersImbalanced()) {
            this.log.debug("Scheduling write event for {} because scheduled ({}), checkIntervalNs ({}) and isImbalanced ({})", new Object[]{MAYBE_BALANCE_PARTITION_LEADERS, this.imbalancedScheduled, this.leaderImbalanceCheckIntervalNs, this.replicationControl.arePartitionLeadersImbalanced()});
            ControllerWriteEvent event = new ControllerWriteEvent(MAYBE_BALANCE_PARTITION_LEADERS, () -> {
                long startTimeNs = this.time.nanoseconds();
                ControllerResult<Boolean> result = this.replicationControl.maybeBalancePartitionLeaders();
                long endTimeNs = this.time.nanoseconds();
                long durationNs = endTimeNs - startTimeNs;
                this.log.info("maybeBalancePartitionLeaders: generated {} records in {} microseconds.{}", new Object[]{result.records().size(), TimeUnit.NANOSECONDS.toMicros(durationNs), result.response() != false ? " Rescheduling immediately." : ""});
                this.imbalancedScheduled = result.response() != false ? ImbalanceSchedule.IMMEDIATELY : ImbalanceSchedule.DEFERRED;
                return result;
            }, EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME));
            long delayNs = this.time.nanoseconds();
            delayNs = this.imbalancedScheduled == ImbalanceSchedule.DEFERRED ? (delayNs += this.leaderImbalanceCheckIntervalNs.getAsLong()) : (delayNs += TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS));
            this.queue.scheduleDeferred(MAYBE_BALANCE_PARTITION_LEADERS, (Function)new EventQueue.EarliestDeadlineFunction(delayNs), event);
            this.imbalancedScheduled = ImbalanceSchedule.SCHEDULED;
        }
    }

    private void cancelMaybeBalancePartitionLeaders() {
        this.imbalancedScheduled = ImbalanceSchedule.DEFERRED;
        this.queue.cancelDeferred(MAYBE_BALANCE_PARTITION_LEADERS);
    }

    private void maybeScheduleNextElectUncleanLeaders() {
        if (this.uncleanScheduled != ImbalanceSchedule.SCHEDULED && this.replicationControl.areSomePartitionsLeaderless()) {
            this.log.debug("Scheduling write event for {} because scheduled ({}), and areSomePartitionsLeaderless ({})", new Object[]{MAYBE_ELECT_UNCLEAN_LEADERS, this.uncleanScheduled, this.replicationControl.areSomePartitionsLeaderless()});
            ControllerWriteEvent event = new ControllerWriteEvent(MAYBE_ELECT_UNCLEAN_LEADERS, () -> {
                long startTimeNs = this.time.nanoseconds();
                ControllerResult<Boolean> result = this.replicationControl.maybeElectUncleanLeaders();
                long endTimeNs = this.time.nanoseconds();
                long durationNs = endTimeNs - startTimeNs;
                this.log.info("maybeElectUncleanLeaders: generated {} records in {} microseconds.{}", new Object[]{result.records().size(), TimeUnit.NANOSECONDS.toMicros(durationNs), result.response() != false ? " Rescheduling immediately." : ""});
                this.uncleanScheduled = result.response() != false ? ImbalanceSchedule.IMMEDIATELY : ImbalanceSchedule.DEFERRED;
                return result;
            }, EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME));
            long delayNs = this.time.nanoseconds();
            delayNs = this.uncleanScheduled == ImbalanceSchedule.DEFERRED ? (delayNs += this.uncleanLeaderElectionCheckIntervalNs) : (delayNs += TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS));
            this.queue.scheduleDeferred(MAYBE_ELECT_UNCLEAN_LEADERS, (Function)new EventQueue.EarliestDeadlineFunction(delayNs), event);
            this.uncleanScheduled = ImbalanceSchedule.SCHEDULED;
        }
    }

    private void cancelMaybeNextElectUncleanLeaders() {
        this.uncleanScheduled = ImbalanceSchedule.DEFERRED;
        this.queue.cancelDeferred(MAYBE_ELECT_UNCLEAN_LEADERS);
    }

    private void maybeScheduleNextWriteNoOpRecord() {
        if (!this.noOpRecordScheduled && this.maxIdleIntervalNs.isPresent() && this.featureControl.metadataVersion().isNoOpRecordSupported()) {
            this.log.debug("Scheduling write event for {} because maxIdleIntervalNs ({}) and metadataVersion ({})", new Object[]{WRITE_NO_OP_RECORD, this.maxIdleIntervalNs.getAsLong(), this.featureControl.metadataVersion()});
            ControllerWriteEvent event = new ControllerWriteEvent(WRITE_NO_OP_RECORD, () -> {
                this.noOpRecordScheduled = false;
                this.maybeScheduleNextWriteNoOpRecord();
                return ControllerResult.of(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0)), null);
            }, EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME, ControllerOperationFlag.RUNS_IN_PREMIGRATION));
            long delayNs = this.time.nanoseconds() + this.maxIdleIntervalNs.getAsLong();
            this.queue.scheduleDeferred(WRITE_NO_OP_RECORD, (Function)new EventQueue.EarliestDeadlineFunction(delayNs), event);
            this.noOpRecordScheduled = true;
        }
    }

    private void cancelNextWriteNoOpRecord() {
        this.noOpRecordScheduled = false;
        this.queue.cancelDeferred(WRITE_NO_OP_RECORD);
    }

    private void maybeScheduleNextExpiredDelegationTokenSweep() {
        if (this.featureControl.metadataVersion().isDelegationTokenSupported() && this.delegationTokenControlManager.isEnabled()) {
            this.log.debug("Scheduling write event for {} because DelegationTokens are enabled.", (Object)SWEEP_EXPIRED_DELEGATION_TOKENS);
            ControllerWriteEvent event = new ControllerWriteEvent(SWEEP_EXPIRED_DELEGATION_TOKENS, () -> {
                this.maybeScheduleNextExpiredDelegationTokenSweep();
                return ControllerResult.of(this.delegationTokenControlManager.sweepExpiredDelegationTokens(), null);
            }, EnumSet.of(ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME));
            long delayNs = this.time.nanoseconds() + TimeUnit.NANOSECONDS.convert(this.delegationTokenExpiryCheckIntervalMs, TimeUnit.MILLISECONDS);
            this.queue.scheduleDeferred(SWEEP_EXPIRED_DELEGATION_TOKENS, (Function)new EventQueue.EarliestDeadlineFunction(delayNs), event);
        }
    }

    private void handleFeatureControlChange() {
        if (this.isActiveController()) {
            if (this.featureControl.metadataVersion().isNoOpRecordSupported()) {
                this.maybeScheduleNextWriteNoOpRecord();
            } else {
                this.cancelNextWriteNoOpRecord();
            }
        }
    }

    private void replay(ApiMessage message, Optional<OffsetAndEpoch> snapshotId, long offset) {
        if (this.log.isTraceEnabled()) {
            if (snapshotId.isPresent()) {
                this.log.trace("Replaying snapshot {} record {}", (Object)Snapshots.filenameFromSnapshotId((OffsetAndEpoch)snapshotId.get()), (Object)this.recordRedactor.toLoggableString(message));
            } else {
                this.log.trace("Replaying log record {} with offset {}", (Object)this.recordRedactor.toLoggableString(message), (Object)offset);
            }
        }
        this.logReplayTracker.replay(message);
        MetadataRecordType type = MetadataRecordType.fromId(message.apiKey());
        switch (type) {
            case REGISTER_BROKER_RECORD: {
                this.clusterControl.replay((RegisterBrokerRecord)message, offset);
                break;
            }
            case UNREGISTER_BROKER_RECORD: {
                this.clusterControl.replay((UnregisterBrokerRecord)message);
                break;
            }
            case TOPIC_RECORD: {
                this.replicationControl.replay((TopicRecord)message);
                break;
            }
            case PARTITION_RECORD: {
                this.replicationControl.replay((PartitionRecord)message);
                break;
            }
            case CONFIG_RECORD: {
                this.configurationControl.replay((ConfigRecord)message);
                break;
            }
            case PARTITION_CHANGE_RECORD: {
                this.replicationControl.replay((PartitionChangeRecord)message);
                break;
            }
            case FENCE_BROKER_RECORD: {
                this.clusterControl.replay((FenceBrokerRecord)message);
                break;
            }
            case UNFENCE_BROKER_RECORD: {
                this.clusterControl.replay((UnfenceBrokerRecord)message);
                break;
            }
            case REMOVE_TOPIC_RECORD: {
                this.replicationControl.replay((RemoveTopicRecord)message);
                break;
            }
            case FEATURE_LEVEL_RECORD: {
                this.featureControl.replay((FeatureLevelRecord)message);
                this.handleFeatureControlChange();
                break;
            }
            case CLIENT_QUOTA_RECORD: {
                this.clientQuotaControlManager.replay((ClientQuotaRecord)message);
                break;
            }
            case PRODUCER_IDS_RECORD: {
                this.producerIdControlManager.replay((ProducerIdsRecord)message);
                break;
            }
            case BROKER_REGISTRATION_CHANGE_RECORD: {
                this.clusterControl.replay((BrokerRegistrationChangeRecord)message);
                break;
            }
            case ACCESS_CONTROL_ENTRY_RECORD: {
                this.aclControlManager.replay((AccessControlEntryRecord)message);
                break;
            }
            case REMOVE_ACCESS_CONTROL_ENTRY_RECORD: {
                this.aclControlManager.replay((RemoveAccessControlEntryRecord)message);
                break;
            }
            case USER_SCRAM_CREDENTIAL_RECORD: {
                this.scramControlManager.replay((UserScramCredentialRecord)message);
                break;
            }
            case REMOVE_USER_SCRAM_CREDENTIAL_RECORD: {
                this.scramControlManager.replay((RemoveUserScramCredentialRecord)message);
                break;
            }
            case DELEGATION_TOKEN_RECORD: {
                this.delegationTokenControlManager.replay((DelegationTokenRecord)message);
                break;
            }
            case REMOVE_DELEGATION_TOKEN_RECORD: {
                this.delegationTokenControlManager.replay((RemoveDelegationTokenRecord)message);
                break;
            }
            case NO_OP_RECORD: {
                break;
            }
            case ZK_MIGRATION_STATE_RECORD: {
                this.featureControl.replay((ZkMigrationStateRecord)message);
                break;
            }
            case BEGIN_TRANSACTION_RECORD: {
                this.offsetControl.replay((BeginTransactionRecord)message, offset);
                break;
            }
            case END_TRANSACTION_RECORD: {
                this.offsetControl.replay((EndTransactionRecord)message, offset);
                break;
            }
            case ABORT_TRANSACTION_RECORD: {
                this.offsetControl.replay((AbortTransactionRecord)message, offset);
                break;
            }
            case REGISTER_CONTROLLER_RECORD: {
                this.clusterControl.replay((RegisterControllerRecord)message);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled record type " + (Object)((Object)type));
            }
        }
    }

    private QuorumController(FaultHandler nonFatalFaultHandler, FaultHandler fatalFaultHandler, LogContext logContext, int nodeId, String clusterId, KafkaEventQueue queue, Time time, KafkaConfigSchema configSchema, RaftClient<ApiMessageAndVersion> raftClient, QuorumFeatures quorumFeatures, short defaultReplicationFactor, int defaultNumPartitions, ReplicaPlacer replicaPlacer, OptionalLong leaderImbalanceCheckIntervalNs, OptionalLong maxIdleIntervalNs, long sessionTimeoutNs, QuorumControllerMetrics controllerMetrics, Optional<CreateTopicPolicy> createTopicPolicy, Optional<AlterConfigPolicy> alterConfigPolicy, ConfigurationValidator configurationValidator, Map<String, Object> staticConfig, BootstrapMetadata bootstrapMetadata, int maxRecordsPerBatch, boolean zkMigrationEnabled, DelegationTokenCache tokenCache, String tokenSecretKeyString, long delegationTokenMaxLifeMs, long delegationTokenExpiryTimeMs, long delegationTokenExpiryCheckIntervalMs, boolean eligibleLeaderReplicasEnabled, long uncleanLeaderElectionCheckIntervalMs, String interBrokerListenerName) {
        this.nonFatalFaultHandler = nonFatalFaultHandler;
        this.fatalFaultHandler = fatalFaultHandler;
        this.log = logContext.logger(QuorumController.class);
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.queue = queue;
        this.time = time;
        this.controllerMetrics = controllerMetrics;
        this.snapshotRegistry = new SnapshotRegistry(logContext);
        this.deferredEventQueue = new DeferredEventQueue(logContext);
        this.deferredUnstableEventQueue = new DeferredEventQueue(logContext);
        this.offsetControl = new OffsetControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).setMetrics(controllerMetrics).setTime(time).build();
        this.resourceExists = new ConfigResourceExistenceChecker();
        this.configurationControl = new ConfigurationControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).setKafkaConfigSchema(configSchema).setExistenceChecker(this.resourceExists).setAlterConfigPolicy(alterConfigPolicy).setValidator(configurationValidator).setStaticConfig(staticConfig).setNodeId(nodeId).build();
        this.clientQuotaControlManager = new ClientQuotaControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).build();
        this.clusterSupportDescriber = new QuorumClusterFeatureSupportDescriber();
        this.featureControl = new FeatureControlManager.Builder().setLogContext(logContext).setQuorumFeatures(quorumFeatures).setSnapshotRegistry(this.snapshotRegistry).setMetadataVersion(MetadataVersion.MINIMUM_KRAFT_VERSION).setClusterFeatureSupportDescriber(this.clusterSupportDescriber).build();
        this.clusterControl = new ClusterControlManager.Builder().setLogContext(logContext).setClusterId(clusterId).setTime(time).setSnapshotRegistry(this.snapshotRegistry).setSessionTimeoutNs(sessionTimeoutNs).setReplicaPlacer(replicaPlacer).setFeatureControlManager(this.featureControl).setZkMigrationEnabled(zkMigrationEnabled).setBrokerUncleanShutdownHandler(this::handleUncleanBrokerShutdown).setInterBrokerListenerName(interBrokerListenerName).build();
        this.producerIdControlManager = new ProducerIdControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).setClusterControlManager(this.clusterControl).build();
        this.leaderImbalanceCheckIntervalNs = leaderImbalanceCheckIntervalNs;
        this.maxIdleIntervalNs = maxIdleIntervalNs;
        this.replicationControl = new ReplicationControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setLogContext(logContext).setDefaultReplicationFactor(defaultReplicationFactor).setDefaultNumPartitions(defaultNumPartitions).setEligibleLeaderReplicasEnabled(eligibleLeaderReplicasEnabled).setMaxElectionsPerImbalance(1000).setConfigurationControl(this.configurationControl).setClusterControl(this.clusterControl).setCreateTopicPolicy(createTopicPolicy).setFeatureControl(this.featureControl).build();
        this.scramControlManager = new ScramControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).build();
        this.delegationTokenExpiryCheckIntervalMs = delegationTokenExpiryCheckIntervalMs;
        this.delegationTokenControlManager = new DelegationTokenControlManager.Builder().setLogContext(logContext).setTokenCache(tokenCache).setDelegationTokenSecretKey(tokenSecretKeyString).setDelegationTokenMaxLifeMs(delegationTokenMaxLifeMs).setDelegationTokenExpiryTimeMs(delegationTokenExpiryTimeMs).build();
        this.aclControlManager = new AclControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(this.snapshotRegistry).build();
        this.logReplayTracker = new LogReplayTracker.Builder().setLogContext(logContext).build();
        this.raftClient = raftClient;
        this.bootstrapMetadata = bootstrapMetadata;
        this.maxRecordsPerBatch = maxRecordsPerBatch;
        this.metaLogListener = new QuorumMetaLogListener();
        this.curClaimEpoch = -1;
        this.zkRecordConsumer = new MigrationRecordConsumer();
        this.zkMigrationEnabled = zkMigrationEnabled;
        this.recordRedactor = new RecordRedactor(configSchema);
        this.eligibleLeaderReplicasEnabled = eligibleLeaderReplicasEnabled;
        this.uncleanLeaderElectionCheckIntervalNs = TimeUnit.MILLISECONDS.toNanos(uncleanLeaderElectionCheckIntervalMs);
        this.log.info("Creating new QuorumController with clusterId {}.{}{}", new Object[]{clusterId, zkMigrationEnabled ? " ZK migration mode is enabled." : "", eligibleLeaderReplicasEnabled ? " Eligible leader replicas enabled." : ""});
        this.raftClient.register((RaftClient.Listener)this.metaLogListener);
    }

    @Override
    public CompletableFuture<AlterPartitionResponseData> alterPartition(ControllerRequestContext context, AlterPartitionRequestData request) {
        if (request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new AlterPartitionResponseData());
        }
        return this.appendWriteEvent("alterPartition", context.deadlineNs(), () -> this.replicationControl.alterPartition(context, request));
    }

    @Override
    public CompletableFuture<AlterUserScramCredentialsResponseData> alterUserScramCredentials(ControllerRequestContext context, AlterUserScramCredentialsRequestData request) {
        if (request.deletions().isEmpty() && request.upsertions().isEmpty()) {
            return CompletableFuture.completedFuture(new AlterUserScramCredentialsResponseData());
        }
        return this.appendWriteEvent("alterUserScramCredentials", context.deadlineNs(), () -> this.scramControlManager.alterCredentials(request, this.featureControl.metadataVersion()));
    }

    @Override
    public CompletableFuture<CreateDelegationTokenResponseData> createDelegationToken(ControllerRequestContext context, CreateDelegationTokenRequestData request) {
        return this.appendWriteEvent("createDelegationToken", context.deadlineNs(), () -> this.delegationTokenControlManager.createDelegationToken(context, request, this.featureControl.metadataVersion()));
    }

    @Override
    public CompletableFuture<RenewDelegationTokenResponseData> renewDelegationToken(ControllerRequestContext context, RenewDelegationTokenRequestData request) {
        return this.appendWriteEvent("renewDelegationToken", context.deadlineNs(), () -> this.delegationTokenControlManager.renewDelegationToken(context, request, this.featureControl.metadataVersion()));
    }

    @Override
    public CompletableFuture<ExpireDelegationTokenResponseData> expireDelegationToken(ControllerRequestContext context, ExpireDelegationTokenRequestData request) {
        return this.appendWriteEvent("expireDelegationToken", context.deadlineNs(), () -> this.delegationTokenControlManager.expireDelegationToken(context, request, this.featureControl.metadataVersion()));
    }

    @Override
    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, Set<String> describable) {
        if (request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new CreateTopicsResponseData());
        }
        return this.appendWriteEvent("createTopics", context.deadlineNs(), () -> this.replicationControl.createTopics(context, request, describable));
    }

    @Override
    public CompletableFuture<Void> unregisterBroker(ControllerRequestContext context, int brokerId) {
        return this.appendWriteEvent("unregisterBroker", context.deadlineNs(), () -> this.replicationControl.unregisterBroker(brokerId), EnumSet.of(ControllerOperationFlag.RUNS_IN_PREMIGRATION));
    }

    @Override
    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(ControllerRequestContext context, Collection<String> names) {
        if (names.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendReadEvent("findTopicIds", context.deadlineNs(), () -> this.replicationControl.findTopicIds(this.offsetControl.lastStableOffset(), names));
    }

    @Override
    public CompletableFuture<Map<String, Uuid>> findAllTopicIds(ControllerRequestContext context) {
        return this.appendReadEvent("findAllTopicIds", context.deadlineNs(), () -> this.replicationControl.findAllTopicIds(this.offsetControl.lastStableOffset()));
    }

    @Override
    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(ControllerRequestContext context, Collection<Uuid> ids) {
        if (ids.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendReadEvent("findTopicNames", context.deadlineNs(), () -> this.replicationControl.findTopicNames(this.offsetControl.lastStableOffset(), ids));
    }

    @Override
    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(ControllerRequestContext context, Collection<Uuid> ids) {
        if (ids.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("deleteTopics", context.deadlineNs(), () -> this.replicationControl.deleteTopics(context, ids));
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(ControllerRequestContext context, Map<ConfigResource, Collection<String>> resources) {
        return this.appendReadEvent("describeConfigs", context.deadlineNs(), () -> this.configurationControl.describeConfigs(this.offsetControl.lastStableOffset(), resources));
    }

    @Override
    public CompletableFuture<ElectLeadersResponseData> electLeaders(ControllerRequestContext context, ElectLeadersRequestData request) {
        if (request.topicPartitions() != null && request.topicPartitions().isEmpty()) {
            return CompletableFuture.completedFuture(new ElectLeadersResponseData());
        }
        return this.appendWriteEvent("electLeaders", context.deadlineNs(), () -> this.replicationControl.electLeaders(request));
    }

    @Override
    public CompletableFuture<FinalizedControllerFeatures> finalizedFeatures(ControllerRequestContext context) {
        return this.appendReadEvent("getFinalizedFeatures", context.deadlineNs(), () -> this.featureControl.finalizedFeatures(this.offsetControl.lastStableOffset()));
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean validateOnly) {
        if (configChanges.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("incrementalAlterConfigs", context.deadlineNs(), () -> {
            ControllerResult<Map<ConfigResource, ApiError>> result = this.configurationControl.incrementalAlterConfigs(configChanges, false);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(ControllerRequestContext context, AlterPartitionReassignmentsRequestData request) {
        if (request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new AlterPartitionReassignmentsResponseData());
        }
        return this.appendWriteEvent("alterPartitionReassignments", context.deadlineNs(), () -> this.replicationControl.alterPartitionReassignments(request));
    }

    @Override
    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ControllerRequestContext context, ListPartitionReassignmentsRequestData request) {
        if (request.topics() != null && request.topics().isEmpty()) {
            return CompletableFuture.completedFuture(new ListPartitionReassignmentsResponseData().setErrorMessage(null));
        }
        return this.appendReadEvent("listPartitionReassignments", context.deadlineNs(), () -> this.replicationControl.listPartitionReassignments(request.topics(), this.offsetControl.lastStableOffset()));
    }

    @Override
    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, String>> newConfigs, boolean validateOnly) {
        if (newConfigs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("legacyAlterConfigs", context.deadlineNs(), () -> {
            ControllerResult<Map<ConfigResource, ApiError>> result = this.configurationControl.legacyAlterConfigs(newConfigs, false);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(ControllerRequestContext context, final BrokerHeartbeatRequestData request) {
        return this.appendWriteEvent("processBrokerHeartbeat", context.deadlineNs(), new ControllerWriteOperation<BrokerHeartbeatReply>(){
            private final int brokerId;
            private boolean inControlledShutdown;
            {
                this.brokerId = request.brokerId();
                this.inControlledShutdown = false;
            }

            @Override
            public ControllerResult<BrokerHeartbeatReply> generateRecordsAndResult() {
                OptionalLong offsetForRegisterBrokerRecord = QuorumController.this.clusterControl.registerBrokerRecordOffset(this.brokerId);
                if (!offsetForRegisterBrokerRecord.isPresent()) {
                    throw new StaleBrokerEpochException(String.format("Receive a heartbeat from broker %d before registration", this.brokerId));
                }
                ControllerResult<BrokerHeartbeatReply> result = QuorumController.this.replicationControl.processBrokerHeartbeat(request, offsetForRegisterBrokerRecord.getAsLong());
                this.inControlledShutdown = result.response().inControlledShutdown();
                QuorumController.this.rescheduleMaybeFenceStaleBrokers();
                return result;
            }

            @Override
            public void processBatchEndOffset(long offset) {
                if (this.inControlledShutdown) {
                    QuorumController.this.clusterControl.heartbeatManager().maybeUpdateControlledShutdownOffset(this.brokerId, offset);
                }
            }
        }, EnumSet.of(ControllerOperationFlag.RUNS_IN_PREMIGRATION)).whenComplete((__, t) -> {
            if (ControllerExceptions.isTimeoutException(t)) {
                this.replicationControl.processExpiredBrokerHeartbeat(request);
                this.controllerMetrics.incrementTimedOutHeartbeats();
            }
        });
    }

    @Override
    public CompletableFuture<BrokerRegistrationReply> registerBroker(ControllerRequestContext context, BrokerRegistrationRequestData request) {
        return this.appendWriteEvent("registerBroker", context.deadlineNs(), () -> {
            HashMap<String, Short> controllerFeatures = new HashMap<String, Short>(this.featureControl.finalizedFeatures(Long.MAX_VALUE).featureMap());
            controllerFeatures.put("kraft.version", this.raftClient.kraftVersion().featureLevel());
            ControllerResult<BrokerRegistrationReply> result = this.clusterControl.registerBroker(request, this.offsetControl.nextWriteOffset(), new FinalizedControllerFeatures(controllerFeatures, Long.MAX_VALUE));
            this.rescheduleMaybeFenceStaleBrokers();
            return result;
        }, EnumSet.of(ControllerOperationFlag.RUNS_IN_PREMIGRATION));
    }

    @Override
    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(ControllerRequestContext context, Collection<ClientQuotaAlteration> quotaAlterations, boolean validateOnly) {
        if (quotaAlterations.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return this.appendWriteEvent("alterClientQuotas", context.deadlineNs(), () -> {
            ControllerResult<Map<ClientQuotaEntity, ApiError>> result = this.clientQuotaControlManager.alterClientQuotas(quotaAlterations);
            if (validateOnly) {
                return result.withoutRecords();
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(ControllerRequestContext context, AllocateProducerIdsRequestData request) {
        return this.appendWriteEvent("allocateProducerIds", context.deadlineNs(), () -> this.producerIdControlManager.generateNextProducerId(request.brokerId(), request.brokerEpoch())).thenApply(result -> new AllocateProducerIdsResponseData().setProducerIdStart(result.firstProducerId()).setProducerIdLen(result.size()));
    }

    @Override
    public CompletableFuture<UpdateFeaturesResponseData> updateFeatures(ControllerRequestContext context, UpdateFeaturesRequestData request) {
        return this.appendWriteEvent("updateFeatures", context.deadlineNs(), () -> {
            HashMap<String, Short> updates = new HashMap<String, Short>();
            HashMap<String, FeatureUpdate.UpgradeType> upgradeTypes = new HashMap<String, FeatureUpdate.UpgradeType>();
            request.featureUpdates().forEach(featureUpdate -> {
                String featureName = featureUpdate.feature();
                upgradeTypes.put(featureName, FeatureUpdate.UpgradeType.fromCode((int)featureUpdate.upgradeType()));
                updates.put(featureName, featureUpdate.maxVersionLevel());
            });
            return this.featureControl.updateFeatures(updates, upgradeTypes, request.validateOnly());
        }).thenApply(result -> {
            UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData();
            responseData.setResults(new UpdateFeaturesResponseData.UpdatableFeatureResultCollection(result.size()));
            result.forEach((featureName, error) -> responseData.results().add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature(featureName).setErrorCode(error.error().code()).setErrorMessage(error.message())));
            return responseData;
        });
    }

    @Override
    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, List<CreatePartitionsRequestData.CreatePartitionsTopic> topics, boolean validateOnly) {
        if (topics.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.appendWriteEvent("createPartitions", context.deadlineNs(), () -> {
            ControllerResult<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> result = this.replicationControl.createPartitions(context, topics);
            if (validateOnly) {
                this.log.debug("Validate-only CreatePartitions result(s): {}", result.response());
                return result.withoutRecords();
            }
            this.log.debug("CreatePartitions result(s): {}", result.response());
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> registerController(ControllerRequestContext context, ControllerRegistrationRequestData request) {
        return this.appendWriteEvent("registerController", context.deadlineNs(), () -> this.clusterControl.registerController(request), EnumSet.of(ControllerOperationFlag.RUNS_IN_PREMIGRATION));
    }

    @Override
    public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        return this.appendWriteEvent("createAcls", context.deadlineNs(), () -> this.aclControlManager.createAcls(aclBindings));
    }

    @Override
    public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> filters) {
        return this.appendWriteEvent("deleteAcls", context.deadlineNs(), () -> this.aclControlManager.deleteAcls(filters));
    }

    @Override
    public CompletableFuture<AssignReplicasToDirsResponseData> assignReplicasToDirs(ControllerRequestContext context, AssignReplicasToDirsRequestData request) {
        return this.appendWriteEvent("assignReplicasToDirs", context.deadlineNs(), () -> this.replicationControl.handleAssignReplicasToDirs(request));
    }

    @Override
    public CompletableFuture<Void> waitForReadyBrokers(int minBrokers) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.appendControlEvent("waitForReadyBrokers", () -> this.clusterControl.addReadyBrokersFuture(future, minBrokers));
        return future;
    }

    @Override
    public void beginShutdown() {
        this.queue.beginShutdown("QuorumController#beginShutdown");
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public int curClaimEpoch() {
        return this.curClaimEpoch;
    }

    @Override
    public void close() throws InterruptedException {
        this.queue.close();
        this.controllerMetrics.close();
    }

    Time time() {
        return this.time;
    }

    QuorumControllerMetrics controllerMetrics() {
        return this.controllerMetrics;
    }

    void handleUncleanBrokerShutdown(int brokerId, List<ApiMessageAndVersion> records) {
        this.replicationControl.handleBrokerUncleanShutdown(brokerId, records);
    }

    private static enum ImbalanceSchedule {
        SCHEDULED,
        DEFERRED,
        IMMEDIATELY;

    }

    class CompleteActivationEvent
    implements ControllerWriteOperation<Void> {
        CompleteActivationEvent() {
        }

        @Override
        public ControllerResult<Void> generateRecordsAndResult() {
            try {
                return ActivationRecordsGenerator.generate(arg_0 -> ((Logger)QuorumController.this.log).warn(arg_0), QuorumController.this.logReplayTracker.empty(), QuorumController.this.offsetControl.transactionStartOffset(), QuorumController.this.zkMigrationEnabled, QuorumController.this.bootstrapMetadata, QuorumController.this.featureControl);
            }
            catch (Throwable t) {
                throw QuorumController.this.fatalFaultHandler.handleFault("exception while completing controller activation", t);
            }
        }

        @Override
        public void processBatchEndOffset(long offset) {
            QuorumController.this.maybeScheduleNextExpiredDelegationTokenSweep();
            QuorumController.this.maybeScheduleNextBalancePartitionLeaders();
            QuorumController.this.maybeScheduleNextElectUncleanLeaders();
            QuorumController.this.maybeScheduleNextWriteNoOpRecord();
        }
    }

    class QuorumMetaLogListener
    implements RaftClient.Listener<ApiMessageAndVersion> {
        QuorumMetaLogListener() {
        }

        public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
            this.appendRaftEvent("handleCommit[baseOffset=" + reader.baseOffset() + "]", () -> {
                try {
                    boolean isActive = QuorumController.this.isActiveController();
                    while (reader.hasNext()) {
                        Batch batch = (Batch)reader.next();
                        long offset = batch.lastOffset();
                        int epoch = batch.epoch();
                        List messages = batch.records();
                        if (messages.isEmpty()) {
                            QuorumController.this.log.debug("Skipping handling commit for batch with no data records with offset {} and epoch {}.", (Object)offset, (Object)epoch);
                            QuorumController.this.offsetControl.handleCommitBatchMetrics((Batch<ApiMessageAndVersion>)batch);
                            continue;
                        }
                        if (isActive) {
                            QuorumController.this.log.debug("Completing purgatory items up to offset {} and epoch {}.", (Object)offset, (Object)epoch);
                            QuorumController.this.offsetControl.handleCommitBatch((Batch<ApiMessageAndVersion>)batch);
                            QuorumController.this.deferredEventQueue.completeUpTo(QuorumController.this.offsetControl.lastStableOffset());
                            QuorumController.this.deferredUnstableEventQueue.completeUpTo(QuorumController.this.offsetControl.lastCommittedOffset());
                            continue;
                        }
                        if (QuorumController.this.log.isDebugEnabled()) {
                            QuorumController.this.log.debug("Replaying commits from the active node up to offset {} and epoch {}.", (Object)offset, (Object)epoch);
                        }
                        int recordIndex = 0;
                        for (ApiMessageAndVersion message : messages) {
                            long recordOffset = batch.baseOffset() + (long)recordIndex;
                            try {
                                QuorumController.this.replay(message.message(), Optional.empty(), recordOffset);
                            }
                            catch (Throwable e) {
                                String failureMessage = String.format("Unable to apply %s record at offset %d on standby controller, from the batch with baseOffset %d", message.message().getClass().getSimpleName(), recordOffset, batch.baseOffset());
                                throw QuorumController.this.fatalFaultHandler.handleFault(failureMessage, e);
                            }
                            ++recordIndex;
                        }
                        QuorumController.this.offsetControl.handleCommitBatch((Batch<ApiMessageAndVersion>)batch);
                    }
                }
                finally {
                    reader.close();
                }
            });
        }

        public void handleLoadSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
            this.appendRaftEvent(String.format("handleLoadSnapshot[snapshotId=%s]", reader.snapshotId()), () -> {
                try {
                    String snapshotName = Snapshots.filenameFromSnapshotId((OffsetAndEpoch)reader.snapshotId());
                    if (QuorumController.this.isActiveController()) {
                        throw QuorumController.this.fatalFaultHandler.handleFault("Asked to load snapshot " + snapshotName + ", but we are the active controller at epoch " + QuorumController.this.curClaimEpoch);
                    }
                    QuorumController.this.offsetControl.beginLoadSnapshot(reader.snapshotId());
                    while (reader.hasNext()) {
                        Batch batch = (Batch)reader.next();
                        long offset = batch.lastOffset();
                        List messages = batch.records();
                        QuorumController.this.log.debug("Replaying snapshot {} batch with last offset of {}", (Object)snapshotName, (Object)offset);
                        int i = 1;
                        for (ApiMessageAndVersion message : messages) {
                            try {
                                QuorumController.this.replay(message.message(), Optional.of(reader.snapshotId()), reader.lastContainedLogOffset());
                            }
                            catch (Throwable e) {
                                String failureMessage = String.format("Unable to apply %s record from snapshot %s on standby controller, which was %d of %d record(s) in the batch with baseOffset %d.", message.message().getClass().getSimpleName(), reader.snapshotId(), i, messages.size(), batch.baseOffset());
                                throw QuorumController.this.fatalFaultHandler.handleFault(failureMessage, e);
                            }
                            ++i;
                        }
                    }
                    QuorumController.this.offsetControl.endLoadSnapshot(reader.lastContainedLogTimestamp());
                }
                catch (FaultHandlerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw QuorumController.this.fatalFaultHandler.handleFault("Error while loading snapshot " + reader.snapshotId(), e);
                }
                finally {
                    reader.close();
                }
            });
        }

        public void handleLeaderChange(LeaderAndEpoch newLeader) {
            this.appendRaftEvent("handleLeaderChange[" + newLeader.epoch() + "]", () -> {
                String newLeaderName;
                String string = newLeaderName = newLeader.leaderId().isPresent() ? String.valueOf(newLeader.leaderId().getAsInt()) : "(none)";
                if (newLeader.leaderId().isPresent()) {
                    QuorumController.this.controllerMetrics.incrementNewActiveControllers();
                }
                if (QuorumController.this.isActiveController()) {
                    if (newLeader.isLeader(QuorumController.this.nodeId)) {
                        QuorumController.this.log.warn("We were the leader in epoch {}, and are still the leader in the new epoch {}.", (Object)QuorumController.this.curClaimEpoch, (Object)newLeader.epoch());
                        QuorumController.this.curClaimEpoch = newLeader.epoch();
                    } else {
                        QuorumController.this.log.warn("Renouncing the leadership due to a metadata log event. We were the leader at epoch {}, but in the new epoch {}, the leader is {}. Reverting to last stable offset {}.", new Object[]{QuorumController.this.curClaimEpoch, newLeader.epoch(), newLeaderName, QuorumController.this.offsetControl.lastStableOffset()});
                        QuorumController.this.renounce();
                    }
                } else if (newLeader.isLeader(QuorumController.this.nodeId)) {
                    long newNextWriteOffset = QuorumController.this.raftClient.logEndOffset();
                    QuorumController.this.log.info("Becoming the active controller at epoch {}, next write offset {}.", (Object)newLeader.epoch(), (Object)newNextWriteOffset);
                    QuorumController.this.claim(newLeader.epoch(), newNextWriteOffset);
                } else {
                    QuorumController.this.log.info("In the new epoch {}, the leader is {}.", (Object)newLeader.epoch(), (Object)newLeaderName);
                }
            });
        }

        public void beginShutdown() {
            QuorumController.this.queue.beginShutdown("MetaLogManager.Listener");
        }

        private void appendRaftEvent(String name, Runnable runnable) {
            QuorumController.this.appendControlEvent(name, () -> {
                if (this != QuorumController.this.metaLogListener) {
                    QuorumController.this.log.debug("Ignoring {} raft event from an old registration", (Object)name);
                } else {
                    runnable.run();
                }
            });
        }
    }

    class MigrationRecordConsumer
    implements ZkRecordConsumer {
        private final EnumSet<ControllerOperationFlag> eventFlags = EnumSet.of(ControllerOperationFlag.RUNS_IN_PREMIGRATION);
        private volatile OffsetAndEpoch highestMigrationRecordOffset;

        MigrationRecordConsumer() {
        }

        @Override
        public CompletableFuture<?> beginMigration() {
            if (QuorumController.this.featureControl.metadataVersion().isMetadataTransactionSupported()) {
                QuorumController.this.log.info("Starting migration of ZooKeeper metadata to KRaft.");
                ControllerWriteEvent<Void> batchEvent = new ControllerWriteEvent<Void>("Begin ZK Migration Transaction", new MigrationWriteOperation(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("ZK Migration"), 0))), this.eventFlags);
                QuorumController.this.queue.append(batchEvent);
                return ((ControllerWriteEvent)batchEvent).future;
            }
            QuorumController.this.log.warn("Starting ZK Migration without metadata transactions enabled. This is not safe since a controller failover or processing error may lead to partially migrated metadata.");
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<?> acceptBatch(List<ApiMessageAndVersion> recordBatch) {
            ControllerWriteEvent<Void> batchEvent = new ControllerWriteEvent<Void>("ZK Migration Batch", new MigrationWriteOperation(recordBatch), this.eventFlags);
            QuorumController.this.queue.append(batchEvent);
            return ((ControllerWriteEvent)batchEvent).future;
        }

        @Override
        public CompletableFuture<OffsetAndEpoch> completeMigration() {
            QuorumController.this.log.info("Completing migration of ZooKeeper metadata to KRaft.");
            ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(2);
            records.add(ZkMigrationState.MIGRATION.toRecord());
            if (QuorumController.this.featureControl.metadataVersion().isMetadataTransactionSupported()) {
                records.add(new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
            }
            ControllerWriteEvent<Void> event = new ControllerWriteEvent<Void>("Complete ZK Migration", new MigrationWriteOperation(records), this.eventFlags);
            QuorumController.this.queue.append(event);
            return ((ControllerWriteEvent)event).future.thenApply(__ -> this.highestMigrationRecordOffset);
        }

        @Override
        public void abortMigration() {
            QuorumController.this.fatalFaultHandler.handleFault("Aborting the ZK migration");
        }

        class MigrationWriteOperation
        implements ControllerWriteOperation<Void> {
            private final List<ApiMessageAndVersion> batch;

            MigrationWriteOperation(List<ApiMessageAndVersion> batch) {
                this.batch = batch;
            }

            @Override
            public ControllerResult<Void> generateRecordsAndResult() {
                return ControllerResult.of(this.batch, null);
            }

            @Override
            public void processBatchEndOffset(long offset) {
                MigrationRecordConsumer.this.highestMigrationRecordOffset = new OffsetAndEpoch(offset, QuorumController.this.curClaimEpoch);
            }
        }
    }

    class ControllerWriteEvent<T>
    implements EventQueue.Event,
    DeferredEvent {
        private final String name;
        private final CompletableFuture<T> future;
        private final ControllerWriteOperation<T> op;
        private final long eventCreatedTimeNs;
        private final EnumSet<ControllerOperationFlag> flags;
        private OptionalLong startProcessingTimeNs;
        private ControllerResultAndOffset<T> resultAndOffset;

        ControllerWriteEvent(String name, ControllerWriteOperation<T> op, EnumSet<ControllerOperationFlag> flags) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = OptionalLong.empty();
            this.name = name;
            this.future = new CompletableFuture();
            this.op = op;
            this.flags = flags;
            this.resultAndOffset = null;
        }

        CompletableFuture<T> future() {
            return this.future;
        }

        public void run() throws Exception {
            this.startProcessingTimeNs = OptionalLong.of(QuorumController.this.updateEventStartMetricsAndGetTime(this.flags.contains((Object)ControllerOperationFlag.DOES_NOT_UPDATE_QUEUE_TIME) ? OptionalLong.empty() : OptionalLong.of(this.eventCreatedTimeNs)));
            int controllerEpoch = QuorumController.this.curClaimEpoch;
            if (!QuorumController.isActiveController(controllerEpoch)) {
                throw ControllerExceptions.newWrongControllerException(QuorumController.this.latestController());
            }
            if (QuorumController.this.featureControl.inPreMigrationMode() && !this.flags.contains((Object)ControllerOperationFlag.RUNS_IN_PREMIGRATION)) {
                QuorumController.this.log.info("Cannot run write operation {} in pre-migration mode. Returning NOT_CONTROLLER.", (Object)this.name);
                throw ControllerExceptions.newPreMigrationException(QuorumController.this.latestController());
            }
            ControllerResult<T> result = this.op.generateRecordsAndResult();
            if (result.records().isEmpty()) {
                this.op.processBatchEndOffset(QuorumController.this.offsetControl.nextWriteOffset() - 1L);
                OptionalLong maybeOffset = QuorumController.this.featureControl.inPreMigrationMode() && this.flags.contains((Object)ControllerOperationFlag.RUNS_IN_PREMIGRATION) ? QuorumController.this.deferredUnstableEventQueue.highestPendingOffset() : QuorumController.this.deferredEventQueue.highestPendingOffset();
                if (!maybeOffset.isPresent()) {
                    this.resultAndOffset = ControllerResultAndOffset.of(-1L, result);
                    QuorumController.this.log.debug("Completing read-only operation {} immediately because the purgatory is empty.", (Object)this);
                    this.complete(null);
                } else {
                    this.resultAndOffset = ControllerResultAndOffset.of(maybeOffset.getAsLong(), result);
                    QuorumController.this.log.debug("Read-only operation {} will be completed when the log reaches offset {}", (Object)this, (Object)this.resultAndOffset.offset());
                }
            } else {
                long offset = QuorumController.appendRecords(QuorumController.this.log, result, QuorumController.this.maxRecordsPerBatch, records -> {
                    int recordIndex = 0;
                    long lastOffset = QuorumController.this.raftClient.prepareAppend(controllerEpoch, records);
                    long baseOffset = lastOffset - (long)records.size() + 1L;
                    for (ApiMessageAndVersion message : records) {
                        long recordOffset = baseOffset + (long)recordIndex;
                        try {
                            QuorumController.this.replay(message.message(), Optional.empty(), recordOffset);
                        }
                        catch (Throwable e) {
                            String failureMessage = String.format("Unable to apply %s record at offset %d on active controller, from the batch with baseOffset %d", message.message().getClass().getSimpleName(), recordOffset, baseOffset);
                            throw QuorumController.this.fatalFaultHandler.handleFault(failureMessage, e);
                        }
                        ++recordIndex;
                    }
                    QuorumController.this.raftClient.schedulePreparedAppend();
                    QuorumController.this.offsetControl.handleScheduleAppend(lastOffset);
                    return lastOffset;
                });
                this.op.processBatchEndOffset(offset);
                this.resultAndOffset = ControllerResultAndOffset.of(offset, result);
                QuorumController.this.log.debug("Read-write operation {} will be completed when the log reaches offset {}.", (Object)this, (Object)this.resultAndOffset.offset());
            }
            QuorumController.this.maybeScheduleNextBalancePartitionLeaders();
            QuorumController.this.maybeScheduleNextElectUncleanLeaders();
            if (!this.future.isDone()) {
                if (QuorumController.this.featureControl.inPreMigrationMode() && this.flags.contains((Object)ControllerOperationFlag.RUNS_IN_PREMIGRATION)) {
                    QuorumController.this.deferredUnstableEventQueue.add(this.resultAndOffset.offset(), (DeferredEvent)this);
                } else {
                    QuorumController.this.deferredEventQueue.add(this.resultAndOffset.offset(), (DeferredEvent)this);
                }
            }
        }

        public void handleException(Throwable exception) {
            this.complete(exception);
        }

        public void complete(Throwable exception) {
            if (exception == null) {
                QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.getAsLong());
                this.future.complete(this.resultAndOffset.response());
            } else {
                this.future.completeExceptionally(QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception));
            }
        }

        public String toString() {
            return this.name + "(" + System.identityHashCode(this) + ")";
        }
    }

    static interface ControllerWriteOperation<T> {
        public ControllerResult<T> generateRecordsAndResult() throws Exception;

        default public void processBatchEndOffset(long offset) {
        }
    }

    static enum ControllerOperationFlag {
        DOES_NOT_UPDATE_QUEUE_TIME,
        RUNS_IN_PREMIGRATION;

    }

    class ControllerReadEvent<T>
    implements EventQueue.Event {
        private final String name;
        private final CompletableFuture<T> future;
        private final Supplier<T> handler;
        private final long eventCreatedTimeNs;
        private OptionalLong startProcessingTimeNs;

        ControllerReadEvent(String name, Supplier<T> handler) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = OptionalLong.empty();
            this.name = name;
            this.future = new CompletableFuture();
            this.handler = handler;
        }

        CompletableFuture<T> future() {
            return this.future;
        }

        public void run() throws Exception {
            this.startProcessingTimeNs = OptionalLong.of(QuorumController.this.updateEventStartMetricsAndGetTime(OptionalLong.of(this.eventCreatedTimeNs)));
            T value = this.handler.get();
            QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.getAsLong());
            this.future.complete(value);
        }

        public void handleException(Throwable exception) {
            this.future.completeExceptionally(QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception));
        }

        public String toString() {
            return this.name + "(" + System.identityHashCode(this) + ")";
        }
    }

    class ControllerEvent
    implements EventQueue.Event {
        private final String name;
        private final Runnable handler;
        private final long eventCreatedTimeNs;
        private OptionalLong startProcessingTimeNs;

        ControllerEvent(String name, Runnable handler) {
            this.eventCreatedTimeNs = QuorumController.this.time.nanoseconds();
            this.startProcessingTimeNs = OptionalLong.empty();
            this.name = name;
            this.handler = handler;
        }

        public void run() throws Exception {
            this.startProcessingTimeNs = OptionalLong.of(QuorumController.this.updateEventStartMetricsAndGetTime(OptionalLong.of(this.eventCreatedTimeNs)));
            QuorumController.this.log.debug("Executing {}.", (Object)this);
            this.handler.run();
            QuorumController.this.handleEventEnd(this.toString(), this.startProcessingTimeNs.getAsLong());
        }

        public void handleException(Throwable exception) {
            QuorumController.this.handleEventException(this.name, this.startProcessingTimeNs, exception);
        }

        public String toString() {
            return this.name;
        }
    }

    class QuorumClusterFeatureSupportDescriber
    implements ClusterFeatureSupportDescriber {
        QuorumClusterFeatureSupportDescriber() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Map<String, VersionRange>>> brokerSupported() {
            return QuorumController.this.clusterControl.brokerSupportedFeatures();
        }

        @Override
        public Iterator<Map.Entry<Integer, Map<String, VersionRange>>> controllerSupported() {
            return QuorumController.this.clusterControl.controllerSupportedFeatures();
        }
    }

    class ConfigResourceExistenceChecker
    implements Consumer<ConfigResource> {
        ConfigResourceExistenceChecker() {
        }

        @Override
        public void accept(ConfigResource configResource) {
            switch (configResource.type()) {
                case BROKER_LOGGER: {
                    break;
                }
                case BROKER: {
                    int nodeId;
                    if (configResource.name().isEmpty()) break;
                    try {
                        nodeId = Integer.parseInt(configResource.name());
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidRequestException("Invalid broker name " + configResource.name());
                    }
                    if (QuorumController.this.clusterControl.brokerRegistrations().containsKey(nodeId) || QuorumController.this.featureControl.isControllerId(nodeId)) break;
                    throw new BrokerIdNotRegisteredException("No node with id " + nodeId + " found.");
                }
                case TOPIC: {
                    if (QuorumController.this.replicationControl.getTopicId(configResource.name()) != null) break;
                    throw new UnknownTopicOrPartitionException("The topic '" + configResource.name() + "' does not exist.");
                }
            }
        }
    }

    public static class Builder {
        private final int nodeId;
        private final String clusterId;
        private FaultHandler nonFatalFaultHandler = null;
        private FaultHandler fatalFaultHandler = null;
        private Time time = Time.SYSTEM;
        private String threadNamePrefix = null;
        private LogContext logContext = null;
        private KafkaConfigSchema configSchema = KafkaConfigSchema.EMPTY;
        private RaftClient<ApiMessageAndVersion> raftClient = null;
        private QuorumFeatures quorumFeatures = null;
        private short defaultReplicationFactor = (short)3;
        private int defaultNumPartitions = 1;
        private ReplicaPlacer replicaPlacer = new StripedReplicaPlacer(new Random());
        private OptionalLong leaderImbalanceCheckIntervalNs = OptionalLong.empty();
        private OptionalLong maxIdleIntervalNs = OptionalLong.empty();
        private long sessionTimeoutNs = ClusterControlManager.DEFAULT_SESSION_TIMEOUT_NS;
        private QuorumControllerMetrics controllerMetrics = null;
        private Optional<CreateTopicPolicy> createTopicPolicy = Optional.empty();
        private Optional<AlterConfigPolicy> alterConfigPolicy = Optional.empty();
        private ConfigurationValidator configurationValidator = ConfigurationValidator.NO_OP;
        private Map<String, Object> staticConfig = Collections.emptyMap();
        private BootstrapMetadata bootstrapMetadata = null;
        private int maxRecordsPerBatch = 10000;
        private boolean zkMigrationEnabled = false;
        private boolean eligibleLeaderReplicasEnabled = false;
        private DelegationTokenCache tokenCache;
        private String tokenSecretKeyString;
        private long delegationTokenMaxLifeMs;
        private long delegationTokenExpiryTimeMs;
        private long delegationTokenExpiryCheckIntervalMs;
        private long uncleanLeaderElectionCheckIntervalMs = TimeUnit.MINUTES.toMillis(5L);
        private String interBrokerListenerName = "PLAINTEXT";

        public Builder(int nodeId, String clusterId) {
            this.nodeId = nodeId;
            this.clusterId = clusterId;
        }

        public Builder setNonFatalFaultHandler(FaultHandler nonFatalFaultHandler) {
            this.nonFatalFaultHandler = nonFatalFaultHandler;
            return this;
        }

        public Builder setFatalFaultHandler(FaultHandler fatalFaultHandler) {
            this.fatalFaultHandler = fatalFaultHandler;
            return this;
        }

        public int nodeId() {
            return this.nodeId;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public Builder setConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        public Builder setRaftClient(RaftClient<ApiMessageAndVersion> logManager) {
            this.raftClient = logManager;
            return this;
        }

        public Builder setQuorumFeatures(QuorumFeatures quorumFeatures) {
            this.quorumFeatures = quorumFeatures;
            return this;
        }

        public Builder setDefaultReplicationFactor(short defaultReplicationFactor) {
            this.defaultReplicationFactor = defaultReplicationFactor;
            return this;
        }

        public Builder setDefaultNumPartitions(int defaultNumPartitions) {
            this.defaultNumPartitions = defaultNumPartitions;
            return this;
        }

        public Builder setReplicaPlacer(ReplicaPlacer replicaPlacer) {
            this.replicaPlacer = replicaPlacer;
            return this;
        }

        public Builder setLeaderImbalanceCheckIntervalNs(OptionalLong value) {
            this.leaderImbalanceCheckIntervalNs = value;
            return this;
        }

        public Builder setMaxIdleIntervalNs(OptionalLong value) {
            this.maxIdleIntervalNs = value;
            return this;
        }

        public Builder setSessionTimeoutNs(long sessionTimeoutNs) {
            this.sessionTimeoutNs = sessionTimeoutNs;
            return this;
        }

        public Builder setMetrics(QuorumControllerMetrics controllerMetrics) {
            this.controllerMetrics = controllerMetrics;
            return this;
        }

        public Builder setBootstrapMetadata(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
            return this;
        }

        public Builder setMaxRecordsPerBatch(int maxRecordsPerBatch) {
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            return this;
        }

        public Builder setCreateTopicPolicy(Optional<CreateTopicPolicy> createTopicPolicy) {
            this.createTopicPolicy = createTopicPolicy;
            return this;
        }

        public Builder setAlterConfigPolicy(Optional<AlterConfigPolicy> alterConfigPolicy) {
            this.alterConfigPolicy = alterConfigPolicy;
            return this;
        }

        public Builder setConfigurationValidator(ConfigurationValidator configurationValidator) {
            this.configurationValidator = configurationValidator;
            return this;
        }

        public Builder setStaticConfig(Map<String, Object> staticConfig) {
            this.staticConfig = staticConfig;
            return this;
        }

        public Builder setZkMigrationEnabled(boolean zkMigrationEnabled) {
            this.zkMigrationEnabled = zkMigrationEnabled;
            return this;
        }

        public Builder setEligibleLeaderReplicasEnabled(boolean eligibleLeaderReplicasEnabled) {
            this.eligibleLeaderReplicasEnabled = eligibleLeaderReplicasEnabled;
            return this;
        }

        public Builder setDelegationTokenCache(DelegationTokenCache tokenCache) {
            this.tokenCache = tokenCache;
            return this;
        }

        public Builder setDelegationTokenSecretKey(String tokenSecretKeyString) {
            this.tokenSecretKeyString = tokenSecretKeyString;
            return this;
        }

        public Builder setDelegationTokenMaxLifeMs(long delegationTokenMaxLifeMs) {
            this.delegationTokenMaxLifeMs = delegationTokenMaxLifeMs;
            return this;
        }

        public Builder setDelegationTokenExpiryTimeMs(long delegationTokenExpiryTimeMs) {
            this.delegationTokenExpiryTimeMs = delegationTokenExpiryTimeMs;
            return this;
        }

        public Builder setDelegationTokenExpiryCheckIntervalMs(long delegationTokenExpiryCheckIntervalMs) {
            this.delegationTokenExpiryCheckIntervalMs = delegationTokenExpiryCheckIntervalMs;
            return this;
        }

        public Builder setUncleanLeaderElectionCheckIntervalMs(long uncleanLeaderElectionCheckIntervalMs) {
            this.uncleanLeaderElectionCheckIntervalMs = uncleanLeaderElectionCheckIntervalMs;
            return this;
        }

        public Builder setInterBrokerListenerName(String interBrokerListenerName) {
            this.interBrokerListenerName = interBrokerListenerName;
            return this;
        }

        public QuorumController build() throws Exception {
            if (this.raftClient == null) {
                throw new IllegalStateException("You must set a raft client.");
            }
            if (this.bootstrapMetadata == null) {
                throw new IllegalStateException("You must specify an initial metadata.version using the kafka-storage tool.");
            }
            if (this.quorumFeatures == null) {
                throw new IllegalStateException("You must specify the quorum features");
            }
            if (this.nonFatalFaultHandler == null) {
                throw new IllegalStateException("You must specify a non-fatal fault handler.");
            }
            if (this.fatalFaultHandler == null) {
                throw new IllegalStateException("You must specify a fatal fault handler.");
            }
            if (this.threadNamePrefix == null) {
                this.threadNamePrefix = String.format("quorum-controller-%d-", this.nodeId);
            }
            if (this.logContext == null) {
                this.logContext = new LogContext(String.format("[QuorumController id=%d] ", this.nodeId));
            }
            if (this.controllerMetrics == null) {
                this.controllerMetrics = new QuorumControllerMetrics(Optional.empty(), this.time, this.zkMigrationEnabled);
            }
            KafkaEventQueue queue = null;
            try {
                queue = new KafkaEventQueue(this.time, this.logContext, this.threadNamePrefix);
                return new QuorumController(this.nonFatalFaultHandler, this.fatalFaultHandler, this.logContext, this.nodeId, this.clusterId, queue, this.time, this.configSchema, this.raftClient, this.quorumFeatures, this.defaultReplicationFactor, this.defaultNumPartitions, this.replicaPlacer, this.leaderImbalanceCheckIntervalNs, this.maxIdleIntervalNs, this.sessionTimeoutNs, this.controllerMetrics, this.createTopicPolicy, this.alterConfigPolicy, this.configurationValidator, this.staticConfig, this.bootstrapMetadata, this.maxRecordsPerBatch, this.zkMigrationEnabled, this.tokenCache, this.tokenSecretKeyString, this.delegationTokenMaxLifeMs, this.delegationTokenExpiryTimeMs, this.delegationTokenExpiryCheckIntervalMs, this.eligibleLeaderReplicasEnabled, this.uncleanLeaderElectionCheckIntervalMs, this.interBrokerListenerName);
            }
            catch (Exception e) {
                Utils.closeQuietly(queue, (String)"event queue");
                throw e;
            }
        }
    }
}

