/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.security.scram.ScramCredential;

public record ScramCredentialData(byte[] salt, byte[] storedKey, byte[] serverKey, int iterations) {
    public static ScramCredentialData fromRecord(UserScramCredentialRecord record) {
        return new ScramCredentialData(record.salt(), record.storedKey(), record.serverKey(), record.iterations());
    }

    public UserScramCredentialRecord toRecord(String userName, ScramMechanism mechanism) {
        return new UserScramCredentialRecord().setName(userName).setMechanism(mechanism.type()).setSalt(this.salt).setStoredKey(this.storedKey).setServerKey(this.serverKey).setIterations(this.iterations);
    }

    public ScramCredential toCredential() {
        return new ScramCredential(this.salt, this.storedKey, this.serverKey, this.iterations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.salt), Arrays.hashCode(this.storedKey), Arrays.hashCode(this.serverKey), this.iterations);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(ScramCredentialData.class)) {
            return false;
        }
        ScramCredentialData other = (ScramCredentialData)o;
        return Arrays.equals(this.salt, other.salt) && Arrays.equals(this.storedKey, other.storedKey) && Arrays.equals(this.serverKey, other.serverKey) && this.iterations == other.iterations;
    }

    @Override
    public String toString() {
        return "ScramCredentialData(salt=[hidden], storedKey=[hidden], serverKey=[hidden], iterations=[hidden])";
    }
}

