/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.security.Key;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CachedFile;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksFileVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(JwksFileVerificationKeyResolver.class);
    private CachedFile<VerificationKeyResolver> delegate;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        File file = cu.validateFileUrl("sasl.oauthbearer.jwks.endpoint.url");
        this.delegate = new CachedFile<VerificationKeyResolver>(file, new VerificationKeyResolverTransformer(), CachedFile.RefreshPolicy.lastModifiedPolicy());
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (this.delegate == null) {
            throw new UnresolvableKeyException("VerificationKeyResolver delegate is null; please call configure() first");
        }
        return this.delegate.transformed().resolveKey(jws, nestingContext);
    }

    private static class VerificationKeyResolverTransformer
    implements CachedFile.Transformer<VerificationKeyResolver> {
        private VerificationKeyResolverTransformer() {
        }

        @Override
        public VerificationKeyResolver transform(File file, String contents) {
            JsonWebKeySet jwks;
            log.debug("Starting creation of new VerificationKeyResolver from {}", (Object)file.getPath());
            try {
                jwks = new JsonWebKeySet(contents);
            }
            catch (Exception e) {
                throw new ConfigException("sasl.oauthbearer.jwks.endpoint.url", file.getPath(), e.getMessage());
            }
            return new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
        }
    }
}

