/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.eclipse.aether.internal.impl.TrackingFileManager;

@Singleton
@Named
public final class DefaultTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTrackingFileManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties read(File file) {
        Path path = file.toPath();
        if (Files.isReadable(path)) {
            Object object = this.mutex(path);
            synchronized (object) {
                try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
                    Properties properties;
                    block19: {
                        FileLock unused = this.fileLock(fileChannel, true);
                        try {
                            Properties props = new Properties();
                            props.load(Channels.newInputStream(fileChannel));
                            properties = props;
                            if (unused == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (unused != null) {
                                try {
                                    unused.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        unused.close();
                    }
                    return properties;
                }
                catch (NoSuchFileException e) {
                    LOGGER.debug("No such file to read {}: {}", (Object)path, (Object)e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read tracking file '{}'", (Object)path, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties update(File file, Map<String, String> updates) {
        Path path = file.toPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create tracking file parent '{}'", (Object)path, (Object)e);
            throw new UncheckedIOException(e);
        }
        Object object = this.mutex(path);
        synchronized (object) {
            try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                Properties properties;
                block22: {
                    FileLock unused = this.fileLock(fileChannel, false);
                    try {
                        Properties props = new Properties();
                        if (fileChannel.size() > 0L) {
                            props.load(Channels.newInputStream(fileChannel));
                        }
                        for (Map.Entry<String, String> update : updates.entrySet()) {
                            if (update.getValue() == null) {
                                props.remove(update.getKey());
                                continue;
                            }
                            props.setProperty(update.getKey(), update.getValue());
                        }
                        LOGGER.debug("Writing tracking file '{}'", (Object)path);
                        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                        props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                        fileChannel.position(0L);
                        int written = fileChannel.write(ByteBuffer.wrap(stream.toByteArray()));
                        fileChannel.truncate(written);
                        properties = props;
                        if (unused == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    unused.close();
                }
                return properties;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to write tracking file '{}'", (Object)path, (Object)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(File file) {
        Path path = file.toPath();
        if (Files.isReadable(path)) {
            Object object = this.mutex(path);
            synchronized (object) {
                try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE);){
                    boolean bl;
                    block19: {
                        FileLock unused = this.fileLock(fileChannel, false);
                        try {
                            Files.delete(path);
                            bl = true;
                            if (unused == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (unused != null) {
                                try {
                                    unused.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        unused.close();
                    }
                    return bl;
                }
                catch (NoSuchFileException e) {
                    LOGGER.debug("No such file to delete {}: {}", (Object)path, (Object)e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete tracking file '{}'", (Object)path, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
        }
        return false;
    }

    private Object mutex(Path path) {
        return path.toAbsolutePath().normalize().toString().intern();
    }

    private FileLock fileLock(FileChannel channel, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, Long.MAX_VALUE, shared);
                break;
            }
            catch (OverlappingFileLockException e) {
                if (attempts <= 0) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

