/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.TrecContentSource;
import org.apache.lucene.benchmark.byTask.feeds.TrecDocParser;

public class TrecFTParser
extends TrecDocParser {
    private static final String DATE = "<DATE>";
    private static final String DATE_END = "</DATE>";
    private static final String HEADLINE = "<HEADLINE>";
    private static final String HEADLINE_END = "</HEADLINE>";

    @Override
    public DocData parse(DocData docData, String name, TrecContentSource trecSrc, StringBuilder docBuf, TrecDocParser.ParsePathType pathType) throws IOException {
        int mark = 0;
        Date date = null;
        String dateStr = TrecFTParser.extract(docBuf, DATE, DATE_END, -1, null);
        if (dateStr != null) {
            date = trecSrc.parseDate(dateStr);
        }
        String title = TrecFTParser.extract(docBuf, HEADLINE, HEADLINE_END, -1, null);
        docData.clear();
        docData.setName(name);
        docData.setDate(date);
        docData.setTitle(title);
        docData.setBody(TrecFTParser.stripTags(docBuf, mark));
        return docData;
    }
}

