---
title: Rollback a Release
author: 
  - Edwin Punzalan _epunzalan@apache.org_
date: 2010-01-03
---

<!-- Licensed to the Apache Software Foundation (ASF) under one-->
<!-- or more contributor license agreements.  See the NOTICE file-->
<!-- distributed with this work for additional information-->
<!-- regarding copyright ownership.  The ASF licenses this file-->
<!-- to you under the Apache License, Version 2.0 (the-->
<!-- "License"); you may not use this file except in compliance-->
<!-- with the License.  You may obtain a copy of the License at-->
<!---->
<!--   http://www.apache.org/licenses/LICENSE-2.0-->
<!---->
<!-- Unless required by applicable law or agreed to in writing,-->
<!-- software distributed under the License is distributed on an-->
<!-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY-->
<!-- KIND, either express or implied.  See the License for the-->
<!-- specific language governing permissions and limitations-->
<!-- under the License.-->
# Rollback a Release

To rollback a release, the following requirement must be met:

- You haven&apos;t run `release:clean` on the project. This means that the backup files and the release descriptor from the previous release command still exist.

When a release is rolled back, the following release phases are executed [by default](../../maven-release-manager/#rollback):

- All project POMs are reverted back to their pre-release state locally, and also in the SCM if the previous release command was able to successfully make changes in the SCM to the POMs. This is done by using the backup files created during `release:prepare`.
- The created branch/tag in SCM for the release is removed. **Note:** This is available from version 3\.0\.0-M1 . Before this version you will need to manually remove the branch/tag from your SCM. For more info see [MRELEASE-229](https://issues.apache.org/jira/browse/MRELEASE-229).

To rollback a release execute this command:

```
mvn release:rollback
```

**Note:** If an error occurs, or the process is cancelled, then running this command again will pick up from where the last one left off.

