/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.VersionRecord;

class Serializer {
    private final OutputStream _outputStream;
    private final MessageDigest _digest;
    private final byte[] _tmpBuf = new byte[8];

    Serializer(OutputStream outputStream) throws IOException {
        this._outputStream = outputStream;
        try {
            this._digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("The required message digest algorithm SHA-256 is not supported in this JVM");
        }
        this.add(new VersionRecord());
    }

    void add(Record record) throws IOException {
        this.write((byte)record.getType().ordinal());
        record.writeData(this);
    }

    public final void writeInt(long val) throws IOException {
        this._tmpBuf[0] = (byte)(val >>> 24);
        this._tmpBuf[1] = (byte)(val >>> 16);
        this._tmpBuf[2] = (byte)(val >>> 8);
        this._tmpBuf[3] = (byte)val;
        this.write(this._tmpBuf, 0, 4);
    }

    public final void writeLong(long val) throws IOException {
        this._tmpBuf[0] = (byte)(val >>> 56);
        this._tmpBuf[1] = (byte)(val >>> 48);
        this._tmpBuf[2] = (byte)(val >>> 40);
        this._tmpBuf[3] = (byte)(val >>> 32);
        this._tmpBuf[4] = (byte)(val >>> 24);
        this._tmpBuf[5] = (byte)(val >>> 16);
        this._tmpBuf[6] = (byte)(val >>> 8);
        this._tmpBuf[7] = (byte)val;
        this.write(this._tmpBuf, 0, 8);
    }

    void complete() throws IOException {
        this.write((byte)RecordType.DIGEST.ordinal());
        this._outputStream.write(this._digest.digest());
        this._outputStream.flush();
    }

    void write(int b) throws IOException {
        this._digest.update((byte)b);
        this._outputStream.write(b);
    }

    void write(byte[] b) throws IOException {
        this._digest.update(b);
        this._outputStream.write(b);
    }

    void write(byte[] input, int off, int len) throws IOException {
        this._digest.update(input, off, len);
        this._outputStream.write(input, off, len);
    }
}

