/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.subjects;

import java.text.MessageFormat;
import org.apache.qpid.server.logging.subjects.AbstractLogSubject;
import org.apache.qpid.server.transport.AMQPConnection;

public class ConnectionLogSubject
extends AbstractLogSubject {
    private final AMQPConnection<?> _connection;
    private boolean _upToDate = false;

    public ConnectionLogSubject(AMQPConnection<?> connection) {
        this._connection = connection;
    }

    private void updateLogString() {
        if (!this._upToDate) {
            if (this._connection.getAuthorizedPrincipal() != null) {
                if (this._connection.getAddressSpaceName() != null) {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this._connection.getConnectionId(), this._connection.getAuthorizedPrincipal().getName(), this._connection.getRemoteAddressString(), this._connection.getAddressSpaceName()) + "] ");
                    this._upToDate = true;
                } else {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2})", this._connection.getConnectionId(), this._connection.getAuthorizedPrincipal().getName(), this._connection.getRemoteAddressString()) + "] ");
                }
            } else {
                this.setLogString("[" + MessageFormat.format("con:{0}({1})", this._connection.getConnectionId(), this._connection.getRemoteAddressString()) + "] ");
            }
        }
    }

    @Override
    public String toLogString() {
        this.updateLogString();
        return super.toLogString();
    }
}

