/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTemporaryQueue;
import org.apache.qpid.jms.JmsTemporaryTopic;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.message.JmsBytesMessage;
import org.apache.qpid.jms.message.JmsDefaultUnresolvedDestinationTransformer;
import org.apache.qpid.jms.message.JmsMapMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsObjectMessage;
import org.apache.qpid.jms.message.JmsStreamMessage;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.message.JmsUnresolvedDestinationTransformer;

public final class JmsMessageTransformation {
    private static JmsUnresolvedDestinationTransformer unresolvedDestinationHandler = new JmsDefaultUnresolvedDestinationTransformer();

    public static JmsDestination transformDestination(JmsConnection connection, Destination destination) throws JMSException {
        JmsDestination result = null;
        if (destination != null) {
            if (destination instanceof JmsDestination) {
                result = (JmsDestination)destination;
            } else if (destination instanceof Queue && destination instanceof Topic) {
                String queueName = ((Queue)destination).getQueueName();
                String topicName = ((Topic)destination).getTopicName();
                result = queueName != null && topicName == null ? new JmsQueue(queueName) : (queueName == null && topicName != null ? new JmsTopic(topicName) : unresolvedDestinationHandler.transform(destination));
            } else {
                result = destination instanceof TemporaryQueue ? new JmsTemporaryQueue(((TemporaryQueue)destination).getQueueName()) : (destination instanceof TemporaryTopic ? new JmsTemporaryTopic(((TemporaryTopic)destination).getTopicName()) : (destination instanceof Queue ? new JmsQueue(((Queue)destination).getQueueName()) : (destination instanceof Topic ? new JmsTopic(((Topic)destination).getTopicName()) : unresolvedDestinationHandler.transform(destination))));
            }
        }
        return result;
    }

    public static JmsMessage transformMessage(JmsConnection connection, Message message) throws JMSException {
        JmsMessage jmsMessage = null;
        JmsMessageFactory factory = connection.getMessageFactory();
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            JmsBytesMessage msg = factory.createBytesMessage();
            try {
                while (true) {
                    msg.writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException messageEOFException) {
                jmsMessage = msg;
            }
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            JmsMapMessage msg = factory.createMapMessage();
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                msg.setObject(name, mapMsg.getObject(name));
            }
            jmsMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            JmsObjectMessage msg = factory.createObjectMessage();
            msg.setObject(objMsg.getObject());
            jmsMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            JmsStreamMessage msg = factory.createStreamMessage();
            Object obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    msg.writeObject(obj);
                }
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            jmsMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            JmsTextMessage msg = factory.createTextMessage();
            msg.setText(textMsg.getText());
            jmsMessage = msg;
        } else {
            jmsMessage = factory.createMessage();
        }
        JmsMessageTransformation.copyProperties(connection, message, jmsMessage);
        return jmsMessage;
    }

    public static void copyProperties(JmsConnection connection, Message source, JmsMessage target) throws JMSException {
        target.setJMSMessageID(source.getJMSMessageID());
        target.setJMSCorrelationID(source.getJMSCorrelationID());
        target.setJMSReplyTo(JmsMessageTransformation.transformDestination(connection, source.getJMSReplyTo()));
        target.setJMSDestination(JmsMessageTransformation.transformDestination(connection, source.getJMSDestination()));
        target.setJMSDeliveryMode(source.getJMSDeliveryMode());
        target.setJMSDeliveryTime(JmsMessageTransformation.getForeignMessageDeliveryTime(source));
        target.setJMSRedelivered(source.getJMSRedelivered());
        target.setJMSType(source.getJMSType());
        target.setJMSExpiration(source.getJMSExpiration());
        target.setJMSPriority(source.getJMSPriority());
        target.setJMSTimestamp(source.getJMSTimestamp());
        Enumeration propertyNames = source.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = source.getObjectProperty(name);
            target.setObjectProperty(name, obj);
        }
    }

    public static void setUnresolvedDestinationHandler(JmsUnresolvedDestinationTransformer handler) {
        unresolvedDestinationHandler = handler;
    }

    public static JmsUnresolvedDestinationTransformer getUnresolvedDestinationTransformer() {
        if (unresolvedDestinationHandler == null) {
            unresolvedDestinationHandler = new JmsDefaultUnresolvedDestinationTransformer();
        }
        return unresolvedDestinationHandler;
    }

    private static long getForeignMessageDeliveryTime(Message foreignMessage) throws JMSException {
        Method deliveryTimeMethod = null;
        try {
            Class clazz = foreignMessage.getClass();
            Method method = clazz.getMethod("getJMSDeliveryTime", null);
            if (!Modifier.isAbstract(method.getModifiers())) {
                deliveryTimeMethod = method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (deliveryTimeMethod != null) {
            return foreignMessage.getJMSDeliveryTime();
        }
        return 0L;
    }
}

