/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerDataMaskPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;

public class RangerDefaultDataMaskPolicyItemEvaluator
extends RangerDefaultPolicyItemEvaluator
implements RangerDataMaskPolicyItemEvaluator {
    private final RangerPolicy.RangerDataMaskPolicyItem dataMaskPolicyItem;
    private final RangerRequestExprResolver maskedValueExprResolver;
    private final RangerRequestExprResolver maskConditionExprResolver;

    public RangerDefaultDataMaskPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerPolicy.RangerDataMaskPolicyItem policyItem, int policyItemIndex, RangerPolicyEngineOptions options) {
        super(serviceDef, policy, policyItem, 4, policyItemIndex, options);
        this.dataMaskPolicyItem = policyItem;
        RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo = this.dataMaskPolicyItem != null ? this.dataMaskPolicyItem.getDataMaskInfo() : null;
        String maskedValue = dataMaskInfo != null ? dataMaskInfo.getValueExpr() : null;
        String maskCondition = dataMaskInfo != null ? dataMaskInfo.getConditionExpr() : null;
        this.maskedValueExprResolver = StringUtils.isNotBlank((CharSequence)maskedValue) && RangerRequestExprResolver.hasExpressions(maskedValue) ? new RangerRequestExprResolver(maskedValue, this.getServiceType()) : null;
        this.maskConditionExprResolver = StringUtils.isNotBlank((CharSequence)maskCondition) && RangerRequestExprResolver.hasExpressions(maskCondition) ? new RangerRequestExprResolver(maskCondition, this.getServiceType()) : null;
    }

    @Override
    public RangerPolicy.RangerPolicyItemDataMaskInfo getDataMaskInfo() {
        return this.dataMaskPolicyItem == null ? null : this.dataMaskPolicyItem.getDataMaskInfo();
    }

    @Override
    public void updateAccessResult(RangerPolicyEvaluator policyEvaluator, RangerAccessResult result, RangerPolicyResourceMatcher.MatchType matchType) {
        RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo = this.getDataMaskInfo();
        if (dataMaskInfo != null) {
            result.setMaskType(dataMaskInfo.getDataMaskType());
            if (this.maskedValueExprResolver != null) {
                result.setMaskedValue(this.maskedValueExprResolver.resolveExpressions(result.getAccessRequest()));
            } else {
                result.setMaskedValue(dataMaskInfo.getValueExpr());
            }
            if (this.maskConditionExprResolver != null) {
                result.setMaskCondition(this.maskConditionExprResolver.resolveExpressions(result.getAccessRequest()));
            } else {
                result.setMaskCondition(dataMaskInfo.getConditionExpr());
            }
            policyEvaluator.updateAccessResult(result, matchType, true, this.getComments());
        }
    }
}

