/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.atlas.authorizer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAtlasAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAtlasAuthorizer.class);
    private static final Logger PERF_LOG = RangerPerfTracer.getPerfLogger((String)"atlasauth.request");
    private static final Set<AtlasPrivilege> CLASSIFICATION_PRIVILEGES = new HashSet<AtlasPrivilege>(){
        {
            this.add(AtlasPrivilege.ENTITY_ADD_CLASSIFICATION);
            this.add(AtlasPrivilege.ENTITY_REMOVE_CLASSIFICATION);
            this.add(AtlasPrivilege.ENTITY_UPDATE_CLASSIFICATION);
        }
    };
    private static volatile RangerBasePlugin atlasPlugin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        RangerBasePlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAtlasPlugin.init()");
        }
        if ((plugin = atlasPlugin) == null) {
            Class<RangerAtlasPlugin> clazz = RangerAtlasPlugin.class;
            // MONITORENTER : org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer$RangerAtlasPlugin.class
            plugin = atlasPlugin;
            if (plugin == null) {
                plugin = new RangerAtlasPlugin();
                plugin.init();
                plugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler((Configuration)plugin.getConfig()));
                atlasPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("<== RangerAtlasPlugin.init()");
    }

    public void cleanUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> cleanUp ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasAdminAccessRequest request) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isAccessAllowed(" + request + ")");
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String action = request.getAction() != null ? request.getAction().getType() : null;
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl(Collections.singletonMap("atlas-service", "*"));
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups(), null);
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            ret = this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isAccessAllowed(" + request + "): " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasEntityAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isAccessAllowed(" + request + ")");
        }
        boolean ret = true;
        RangerPerfTracer perf = null;
        RangerAtlasAuditHandler auditHandler = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            if (!StringUtils.isEmpty((CharSequence)request.getEntityId()) || request.getClassification() != null || request.getEntity() != null) {
                auditHandler = new RangerAtlasAuditHandler(request, this.getServiceDef());
            }
            ret = this.isAccessAllowed(request, auditHandler);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isAccessAllowed(" + request + "): " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasTypeAccessRequest request) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isAccessAllowed(" + request + ")");
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String typeName = request.getTypeDef() != null ? request.getTypeDef().getName() : null;
            String typeCategory = request.getTypeDef() != null && request.getTypeDef().getCategory() != null ? request.getTypeDef().getCategory().name() : null;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            rangerResource.setValue("type", (Object)typeName);
            rangerResource.setValue("type-category", (Object)typeCategory);
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups(), null);
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            boolean isAuditDisabled = "type-read".equalsIgnoreCase(action);
            ret = isAuditDisabled ? this.checkAccess(rangerRequest, null) : this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isAccessAllowed(" + request + "): " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> isAccessAllowed(" + request + ")");
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String action = request.getAction() != null ? request.getAction().getType() : null;
            Set end1EntityTypeAndSuperTypes = request.getEnd1EntityTypeAndAllSuperTypes();
            HashSet end1Classifications = new HashSet(request.getEnd1EntityClassifications());
            String end1EntityId = request.getEnd1EntityId();
            Set end2EntityTypeAndSuperTypes = request.getEnd2EntityTypeAndAllSuperTypes();
            HashSet end2Classifications = new HashSet(request.getEnd2EntityClassifications());
            String end2EntityId = request.getEnd2EntityId();
            String relationShipType = request.getRelationshipType();
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups(), null);
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            rangerResource.setValue("relationship-type", (Object)relationShipType);
            HashSet classificationsWithSuperTypesEnd1 = new HashSet();
            for (String classificationToAuthorize : end1Classifications) {
                classificationsWithSuperTypesEnd1.addAll(request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
            }
            rangerResource.setValue("end-one-entity-type", (Object)end1EntityTypeAndSuperTypes);
            rangerResource.setValue("end-one-entity-classification", classificationsWithSuperTypesEnd1);
            rangerResource.setValue("end-one-entity", (Object)end1EntityId);
            HashSet classificationsWithSuperTypesEnd2 = new HashSet();
            for (String classificationToAuthorize : end2Classifications) {
                classificationsWithSuperTypesEnd2.addAll(request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
            }
            rangerResource.setValue("end-two-entity-type", (Object)end2EntityTypeAndSuperTypes);
            rangerResource.setValue("end-two-entity-classification", classificationsWithSuperTypesEnd2);
            rangerResource.setValue("end-two-entity", (Object)end2EntityId);
            ret = this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isAccessAllowed(" + request + "): " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrubSearchResults(AtlasSearchResultScrubRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> scrubSearchResults(" + request + ")");
        }
        RangerPerfTracer perf = null;
        try {
            AtlasSearchResult result;
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RangerAtlasAuthorizer.scrubSearchResults(" + request + ")"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(result = request.getSearchResult()).getEntities())) {
                for (AtlasEntityHeader entity : result.getEntities()) {
                    this.checkAccessAndScrub(entity, request);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)result.getFullTextResult())) {
                for (AtlasSearchResult.AtlasFullTextResult fullTextResult : result.getFullTextResult()) {
                    if (fullTextResult == null) continue;
                    this.checkAccessAndScrub(fullTextResult.getEntity(), request);
                }
            }
            if (MapUtils.isNotEmpty((Map)result.getReferredEntities())) {
                for (AtlasEntityHeader entity : result.getReferredEntities().values()) {
                    this.checkAccessAndScrub(entity, request);
                }
            }
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== scrubSearchResults(): " + request);
        }
    }

    public void filterTypesDef(AtlasTypesDefFilterRequest request) {
        AtlasTypesDef typesDef = request.getTypesDef();
        this.filterTypes((AtlasAccessRequest)request, typesDef.getEnumDefs());
        this.filterTypes((AtlasAccessRequest)request, typesDef.getStructDefs());
        this.filterTypes((AtlasAccessRequest)request, typesDef.getEntityDefs());
        this.filterTypes((AtlasAccessRequest)request, typesDef.getClassificationDefs());
        this.filterTypes((AtlasAccessRequest)request, typesDef.getRelationshipDefs());
        this.filterTypes((AtlasAccessRequest)request, typesDef.getBusinessMetadataDefs());
    }

    private void filterTypes(AtlasAccessRequest request, List<? extends AtlasBaseTypeDef> typeDefs) {
        if (typeDefs != null) {
            ListIterator<? extends AtlasBaseTypeDef> iter = typeDefs.listIterator();
            while (iter.hasNext()) {
                AtlasBaseTypeDef typeDef = iter.next();
                AtlasTypeAccessRequest typeRequest = new AtlasTypeAccessRequest(request.getAction(), typeDef, request.getUser(), request.getUserGroups());
                typeRequest.setClientIPAddress(request.getClientIPAddress());
                typeRequest.setForwardedAddresses(request.getForwardedAddresses());
                typeRequest.setRemoteIPAddress(request.getRemoteIPAddress());
                if (this.isAccessAllowed(typeRequest)) continue;
                iter.remove();
            }
        }
    }

    private RangerServiceDef getServiceDef() {
        RangerBasePlugin plugin = atlasPlugin;
        return plugin != null ? plugin.getServiceDef() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAccessAllowed(AtlasEntityAccessRequest request, RangerAtlasAuditHandler auditHandler) {
        boolean ret;
        block13: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> isAccessAllowed(" + request + ")");
            }
            ret = false;
            try {
                String action = request.getAction() != null ? request.getAction().getType() : null;
                Set entityTypes = request.getEntityTypeAndAllSuperTypes();
                String entityId = request.getEntityId();
                String classification = request.getClassification() != null ? request.getClassification().getTypeName() : null;
                RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
                RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
                String ownerUser = request.getEntity() != null ? (String)request.getEntity().getAttribute("owner") : null;
                rangerResource.setValue("entity-type", (Object)entityTypes);
                rangerResource.setValue("entity", (Object)entityId);
                rangerResource.setOwnerUser(ownerUser);
                rangerRequest.setAccessType(action);
                rangerRequest.setAction(action);
                rangerRequest.setUser(request.getUser());
                rangerRequest.setUserGroups(request.getUserGroups());
                rangerRequest.setClientIPAddress(request.getClientIPAddress());
                rangerRequest.setAccessTime(request.getAccessTime());
                rangerRequest.setResource((RangerAccessResource)rangerResource);
                rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
                rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
                if (AtlasPrivilege.ENTITY_ADD_LABEL.equals((Object)request.getAction()) || AtlasPrivilege.ENTITY_REMOVE_LABEL.equals((Object)request.getAction())) {
                    rangerResource.setValue("entity-label", (Object)request.getLabel());
                } else if (AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA.equals((Object)request.getAction())) {
                    rangerResource.setValue("entity-business-metadata", (Object)request.getBusinessMetadata());
                } else if (StringUtils.isNotEmpty((CharSequence)classification) && CLASSIFICATION_PRIVILEGES.contains(request.getAction())) {
                    rangerResource.setValue("classification", (Object)request.getClassificationTypeAndAllSuperTypes(classification));
                }
                if (CollectionUtils.isNotEmpty((Collection)request.getEntityClassifications())) {
                    for (String classificationToAuthorize : request.getEntityClassifications()) {
                        rangerResource.setValue("entity-classification", (Object)request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
                        ret = this.checkAccess(rangerRequest, auditHandler);
                        if (ret) continue;
                        break block13;
                    }
                    break block13;
                }
                rangerResource.setValue("entity-classification", (Object)"_NOT_CLASSIFIED");
                ret = this.checkAccess(rangerRequest, auditHandler);
            }
            finally {
                if (auditHandler != null) {
                    auditHandler.flushAudit();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== isAccessAllowed(" + request + "): " + ret);
        }
        return ret;
    }

    private boolean checkAccess(RangerAccessRequestImpl request) {
        boolean ret = false;
        RangerBasePlugin plugin = atlasPlugin;
        if (plugin != null) {
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
            ret = result != null && result.getIsAllowed();
        } else {
            LOG.warn("RangerAtlasPlugin not initialized. Access blocked!!!");
        }
        return ret;
    }

    private boolean checkAccess(RangerAccessRequestImpl request, RangerAtlasAuditHandler auditHandler) {
        boolean ret = false;
        RangerBasePlugin plugin = atlasPlugin;
        if (plugin != null) {
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            ret = result != null && result.getIsAllowed();
        } else {
            LOG.warn("RangerAtlasPlugin not initialized. Access blocked!!!");
        }
        return ret;
    }

    private void checkAccessAndScrub(AtlasEntityHeader entity, AtlasSearchResultScrubRequest request) {
        if (entity != null && request != null) {
            AtlasEntityAccessRequest entityAccessRequest = new AtlasEntityAccessRequest(request.getTypeRegistry(), AtlasPrivilege.ENTITY_READ, entity, request.getUser(), request.getUserGroups());
            entityAccessRequest.setClientIPAddress(request.getClientIPAddress());
            entityAccessRequest.setForwardedAddresses(request.getForwardedAddresses());
            entityAccessRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            if (!this.isAccessAllowed(entityAccessRequest, null)) {
                this.scrubEntityHeader(entity);
            }
        }
    }

    class RangerAtlasAuditHandler
    extends RangerDefaultAuditHandler {
        private final Map<String, AuthzAuditEvent> auditEvents;
        private final String resourcePath;
        private boolean denyExists = false;

        public RangerAtlasAuditHandler(AtlasEntityAccessRequest request, RangerServiceDef serviceDef) {
            String strClassifications;
            Set classifications = request.getEntityClassifications();
            String string = strClassifications = classifications == null ? "[]" : classifications.toString();
            if (request.getClassification() != null) {
                strClassifications = strClassifications + "," + request.getClassification().getTypeName();
            }
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            rangerResource.setServiceDef(serviceDef);
            rangerResource.setValue("entity-type", (Object)request.getEntityType());
            rangerResource.setValue("entity-classification", (Object)strClassifications);
            rangerResource.setValue("entity", (Object)request.getEntityId());
            if (AtlasPrivilege.ENTITY_ADD_LABEL.equals((Object)request.getAction()) || AtlasPrivilege.ENTITY_REMOVE_LABEL.equals((Object)request.getAction())) {
                rangerResource.setValue("entity-label", (Object)("label=" + request.getLabel()));
            } else if (AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA.equals((Object)request.getAction())) {
                rangerResource.setValue("entity-business-metadata", (Object)("business-metadata=" + request.getBusinessMetadata()));
            }
            this.auditEvents = new HashMap<String, AuthzAuditEvent>();
            this.resourcePath = rangerResource.getAsString();
        }

        public void processResult(RangerAccessResult result) {
            if (this.denyExists) {
                return;
            }
            AuthzAuditEvent auditEvent = super.getAuthzEvents(result);
            if (auditEvent != null) {
                if (this.resourcePath != null) {
                    auditEvent.setResourcePath(this.resourcePath);
                }
                if (!result.getIsAllowed()) {
                    this.denyExists = true;
                    this.auditEvents.clear();
                }
                this.auditEvents.put(auditEvent.getPolicyId() + auditEvent.getAccessType(), auditEvent);
            }
        }

        public void flushAudit() {
            if (this.auditEvents != null) {
                for (AuthzAuditEvent auditEvent : this.auditEvents.values()) {
                    this.logAuthzAudit(auditEvent);
                }
            }
        }
    }

    class RangerAtlasPlugin
    extends RangerBasePlugin {
        RangerAtlasPlugin() {
            super("atlas", "atlas");
        }
    }
}

