/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerValidityRecurrence;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerValidityScheduleValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerValidityScheduleValidator.class);
    private static final ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            sd.setLenient(false);
            return sd;
        }
    };
    private static final Set<String> validTimeZoneIds = new HashSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
    private final RangerValiditySchedule validitySchedule;
    private Date startTime;
    private Date endTime;
    private RangerValidityRecurrence.RecurrenceSchedule validityPeriodEstimator;
    private RangerValiditySchedule normalizedValiditySchedule;

    public RangerValidityScheduleValidator(@Nonnull RangerValiditySchedule validitySchedule) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerValidityScheduleValidator:: " + validitySchedule);
        }
        this.validitySchedule = validitySchedule;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerValidityScheduleValidator:: " + validitySchedule);
        }
    }

    public RangerValiditySchedule validate(List<ValidationFailureDetails> validationFailures) {
        RangerValiditySchedule ret = null;
        if (StringUtils.isEmpty((CharSequence)this.validitySchedule.getStartTime()) && StringUtils.isEmpty((CharSequence)this.validitySchedule.getEndTime()) && CollectionUtils.isEmpty(this.validitySchedule.getRecurrences())) {
            validationFailures.add(new ValidationFailureDetails(0, "startTime,endTime,recurrences", "", true, true, false, "empty values"));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.validitySchedule.getStartTime())) {
                try {
                    this.startTime = DATE_FORMATTER.get().parse(this.validitySchedule.getStartTime());
                }
                catch (ParseException exception) {
                    LOG.error("Error parsing startTime:[" + this.validitySchedule.getStartTime() + "]", (Throwable)exception);
                    validationFailures.add(new ValidationFailureDetails(0, "startTime", "", true, true, false, "invalid value"));
                }
            } else {
                this.startTime = new Date();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.validitySchedule.getEndTime())) {
                try {
                    this.endTime = DATE_FORMATTER.get().parse(this.validitySchedule.getEndTime());
                }
                catch (ParseException exception) {
                    LOG.error("Error parsing endTime:[" + this.validitySchedule.getEndTime() + "]", (Throwable)exception);
                    validationFailures.add(new ValidationFailureDetails(0, "endTime", "", true, true, false, "invalid value"));
                }
            } else {
                this.endTime = new Date(Long.MAX_VALUE);
            }
            if (this.startTime != null && this.endTime != null) {
                this.validityPeriodEstimator = new RangerValidityRecurrence.RecurrenceSchedule();
                this.normalizedValiditySchedule = new RangerValiditySchedule();
                boolean isValid = this.validateTimeRangeSpec(validationFailures);
                if (isValid) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("validityPeriodEstimator:[" + this.validityPeriodEstimator + "]");
                    }
                    this.normalizedValiditySchedule.setStartTime(this.validitySchedule.getStartTime());
                    this.normalizedValiditySchedule.setEndTime(this.validitySchedule.getEndTime());
                    this.normalizedValiditySchedule.setTimeZone(this.validitySchedule.getTimeZone());
                    ret = this.normalizedValiditySchedule;
                } else {
                    this.normalizedValiditySchedule = null;
                }
            }
        }
        return ret;
    }

    private boolean validateTimeRangeSpec(List<ValidationFailureDetails> validationFailures) {
        boolean ret;
        if (this.startTime.getTime() >= this.endTime.getTime()) {
            validationFailures.add(new ValidationFailureDetails(0, "startTime", "", false, true, false, "endTime is not later than startTime"));
            ret = false;
        } else {
            ret = true;
        }
        ret = this.validateTimeZone(this.validitySchedule.getTimeZone(), validationFailures) && ret;
        for (RangerValidityRecurrence recurrence : this.validitySchedule.getRecurrences()) {
            ret = this.validateValidityInterval(recurrence, validationFailures) && ret;
            if (!ret) continue;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute, validationFailures) && ret;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour, validationFailures) && ret;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth, validationFailures) && ret;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek, validationFailures) && ret;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month, validationFailures) && ret;
            ret = this.validateFieldSpec(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year, validationFailures) && ret;
            if (!(ret = ret && this.validateIntervalDuration(recurrence, validationFailures))) continue;
            RangerValidityRecurrence.RecurrenceSchedule schedule = new RangerValidityRecurrence.RecurrenceSchedule(this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute), this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour), this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth), this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek), this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month), this.getNormalizedValue(recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year));
            RangerValidityRecurrence normalizedRecurrence = new RangerValidityRecurrence(schedule, recurrence.getInterval());
            this.normalizedValiditySchedule.getRecurrences().add(normalizedRecurrence);
        }
        return ret;
    }

    private boolean validateTimeZone(String timeZone, List<ValidationFailureDetails> validationFailures) {
        boolean ret;
        validTimeZoneIds.removeAll(Arrays.asList("JST", "IST", "BET", "ACT", "AET", "AGT", "VST", "SystemV/AST4", "CNT", "NET", "SystemV/MST7", "PLT", "CST", "SST", "SystemV/CST6", "CTT", "PNT", "BST", "SystemV/YST9", "MIT", "ART", "AST", "PRT", "SystemV/HST10", "PST", "SystemV/EST5", "IET", "SystemV/PST8", "SystemV/CST6CDT", "NST", "EAT", "ECT", "SystemV/MST7MDT", "SystemV/YST9YDT", "CAT", "SystemV/PST8PDT", "SystemV/AST4ADT", "SystemV/EST5EDT"));
        boolean bl = ret = !StringUtils.isNotBlank((CharSequence)timeZone) || validTimeZoneIds.contains(timeZone);
        if (!ret) {
            validationFailures.add(new ValidationFailureDetails(0, "timeZone", "", false, true, false, "invalid timeZone"));
        }
        return ret;
    }

    private boolean validateValidityInterval(RangerValidityRecurrence recurrence, List<ValidationFailureDetails> validationFailures) {
        boolean ret;
        boolean bl = ret = recurrence.getInterval() != null && recurrence.getSchedule() != null;
        if (ret) {
            RangerValidityRecurrence.ValidityInterval validityInterval = recurrence.getInterval();
            if (validityInterval.getDays() < 0 || validityInterval.getHours() < 0 || validityInterval.getHours() > 23 || validityInterval.getMinutes() < 0 || validityInterval.getMinutes() > 59 || validityInterval.getDays() == 0 && validityInterval.getHours() == 0 && validityInterval.getMinutes() == 0) {
                validationFailures.add(new ValidationFailureDetails(0, "interval", "", false, true, false, "invalid interval"));
                ret = false;
            }
            if (StringUtils.isBlank((CharSequence)recurrence.getSchedule().getDayOfMonth()) && StringUtils.isBlank((CharSequence)recurrence.getSchedule().getDayOfWeek())) {
                validationFailures.add(new ValidationFailureDetails(0, "validitySchedule", "", false, true, false, "empty dayOfMonth and dayOfWeek"));
                ret = false;
            }
        } else {
            validationFailures.add(new ValidationFailureDetails(0, "recurrence", "schedule/interval", true, true, false, "empty schedule/interval in recurrence spec"));
        }
        return ret;
    }

    private boolean validateFieldSpec(RangerValidityRecurrence recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec field, List<ValidationFailureDetails> validationFailures) {
        int maximum;
        int minimum;
        boolean ret = true;
        String fieldValue = recurrence.getSchedule().getFieldValue(field);
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No value provided for [" + (Object)((Object)field) + "]");
            }
            if (StringUtils.equals((CharSequence)field.name(), (CharSequence)RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek.name()) || StringUtils.equals((CharSequence)field.name(), (CharSequence)RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth.name())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow blank value for dayOfWeek or dayOfMonth here. Check for both being null is done elsewhere.");
                }
            } else {
                validationFailures.add(new ValidationFailureDetails(0, field.toString(), "", false, true, false, "No value provided"));
            }
        }
        if (!(ret = this.validateCharacters(fieldValue, field.specialChars))) {
            validationFailures.add(new ValidationFailureDetails(0, field.toString(), "", false, true, false, "invalid character(s)"));
        } else {
            minimum = field == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month ? field.minimum + 1 : field.minimum;
            maximum = field == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month ? field.maximum + 1 : field.maximum;
            ret = this.validateRanges(recurrence, field, minimum, maximum, validationFailures);
        }
        if (ret) {
            if (field == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
                minimum = Integer.valueOf(formatter.format(this.startTime));
                maximum = Integer.valueOf(formatter.format(this.endTime));
            } else if (field == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month) {
                minimum = field.minimum + 1;
                maximum = field.maximum + 1;
            } else {
                minimum = field.minimum;
                maximum = field.maximum;
            }
            ret = this.validateRanges(recurrence, field, minimum, maximum, validationFailures);
        }
        return ret;
    }

    private boolean validateCharacters(String str, String permittedCharacters) {
        boolean ret = true;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            char[] chars;
            for (char c : chars = str.toCharArray()) {
                if (Character.isDigit(c) || Character.isWhitespace(c) || StringUtils.contains((CharSequence)permittedCharacters, (int)c)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    private boolean validateIntervalDuration(RangerValidityRecurrence recurrence, List<ValidationFailureDetails> validationFailures) {
        boolean ret = true;
        if (!validationFailures.isEmpty() || this.validityPeriodEstimator == null) {
            ret = false;
        } else {
            int minSchedulingInterval = 1;
            String minutes = this.validityPeriodEstimator.getFieldValue(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute);
            if (!StringUtils.equals((CharSequence)minutes, (CharSequence)"*")) {
                String hours;
                int n = minSchedulingInterval = StringUtils.isBlank((CharSequence)minutes) ? RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1 : Integer.valueOf(minutes);
                if (minSchedulingInterval == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1 && !StringUtils.equals((CharSequence)(hours = this.validityPeriodEstimator.getFieldValue(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour)), (CharSequence)"*")) {
                    int hour = StringUtils.isBlank((CharSequence)hours) ? RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour.maximum + 1 : Integer.valueOf(hours);
                    minSchedulingInterval = hour * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1);
                    if (hour == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour.maximum + 1) {
                        String dayOfMonths = this.validityPeriodEstimator.getFieldValue(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth);
                        String dayOfWeeks = this.validityPeriodEstimator.getFieldValue(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek);
                        int dayOfMonth = 1;
                        int dayOfWeek = 1;
                        if (!StringUtils.equals((CharSequence)dayOfMonths, (CharSequence)"*")) {
                            int n2 = dayOfMonth = StringUtils.isBlank((CharSequence)dayOfMonths) ? RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth.maximum + 1 : Integer.valueOf(dayOfMonths);
                        }
                        if (!StringUtils.equals((CharSequence)dayOfWeeks, (CharSequence)"*")) {
                            int n3 = dayOfWeek = StringUtils.isBlank((CharSequence)dayOfWeeks) ? RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek.maximum + 1 : Integer.valueOf(dayOfWeeks);
                        }
                        if (!StringUtils.equals((CharSequence)dayOfMonths, (CharSequence)"*") || !StringUtils.equals((CharSequence)dayOfWeeks, (CharSequence)"*")) {
                            String months;
                            int minDays = dayOfMonth > dayOfWeek ? dayOfWeek : dayOfMonth;
                            minSchedulingInterval = minDays * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour.maximum + 1) * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1);
                            if (dayOfMonth == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth.maximum + 1 && dayOfWeek == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek.maximum + 1 && !StringUtils.equals((CharSequence)(months = this.validityPeriodEstimator.getFieldValue(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month)), (CharSequence)"*")) {
                                int month = StringUtils.isBlank((CharSequence)months) ? RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month.maximum + 1 : Integer.valueOf(months);
                                minSchedulingInterval = month * 28 * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour.maximum + 1) * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1);
                                if (month == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month.maximum + 1) {
                                    minSchedulingInterval = 365 * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour.maximum + 1) * (RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute.maximum + 1);
                                }
                            }
                        }
                    }
                }
            }
            if (RangerValidityRecurrence.ValidityInterval.getValidityIntervalInMinutes(recurrence.getInterval()) > minSchedulingInterval && LOG.isDebugEnabled()) {
                LOG.warn("Specified scheduling interval:" + RangerValidityRecurrence.ValidityInterval.getValidityIntervalInMinutes(recurrence.getInterval()) + " minutes] is more than minimum possible scheduling interval:[" + minSchedulingInterval + " minutes].");
                LOG.warn("This may turn this (expected to be temporary) policy into effectively permanent policy.");
            }
        }
        return ret;
    }

    private boolean validateRanges(RangerValidityRecurrence recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec field, int minValidValue, int maxValidValue, List<ValidationFailureDetails> validationFailures) {
        boolean ret = true;
        String value = null;
        String fieldName = field.toString();
        String noWhiteSpace = StringUtils.deleteWhitespace((String)recurrence.getSchedule().getFieldValue(field));
        String[] specs = StringUtils.split((String)noWhiteSpace, (String)",");
        class Range {
            private int lower;
            private int upper;

            Range(int lower, int upper) {
                this.lower = lower;
                this.upper = upper;
            }
        }
        ArrayList<Range> rangeOfValues = new ArrayList<Range>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (String spec : specs) {
            if (!StringUtils.isNotEmpty((CharSequence)spec)) continue;
            if (spec.startsWith("-") || spec.endsWith("-")) {
                validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect range spec: " + spec));
                ret = false;
                continue;
            }
            String[] ranges = StringUtils.split((String)spec, (String)"-");
            if (ranges.length > 2) {
                validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect range spec: " + spec));
                ret = false;
                continue;
            }
            if (ranges.length == 2) {
                int val1 = minValidValue;
                int val2 = maxValidValue;
                if (!StringUtils.equals((CharSequence)ranges[0], (CharSequence)"*")) {
                    val1 = Integer.valueOf(ranges[0]);
                } else {
                    value = "*";
                }
                if (!StringUtils.equals((CharSequence)ranges[1], (CharSequence)"*")) {
                    val2 = Integer.valueOf(ranges[1]);
                } else {
                    value = "*";
                }
                if (field == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year) {
                    if (val1 < minValidValue && val2 > maxValidValue) {
                        validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect range: (" + val1 + ", " + val2 + "). valid range: (" + minValidValue + ", " + maxValidValue + ")"));
                        ret = false;
                    }
                } else {
                    if (val1 < minValidValue || val1 > maxValidValue) {
                        validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect lower range: " + val1 + ". valid range: (" + minValidValue + ", " + maxValidValue + ")"));
                        ret = false;
                    }
                    if (val2 < minValidValue || val2 > maxValidValue) {
                        validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect upper range: " + val2 + ". valid range: (" + minValidValue + ", " + maxValidValue + ")"));
                        ret = false;
                    }
                }
                if (!ret) continue;
                if (val1 >= val2) {
                    validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect range: min=" + val1 + ", max=" + val2));
                    ret = false;
                    continue;
                }
                value = "*";
                for (Range range : rangeOfValues) {
                    if (range.lower != val1 && range.upper != val2) continue;
                    validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "duplicate range"));
                    ret = false;
                    break;
                }
                if (!ret) continue;
                rangeOfValues.add(new Range(val1, val2));
                continue;
            }
            if (ranges.length == 1) {
                if (!StringUtils.equals((CharSequence)ranges[0], (CharSequence)"*")) {
                    int val = Integer.valueOf(ranges[0]);
                    if (val < minValidValue || val > maxValidValue) {
                        validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "incorrect value: " + val + ". Valid range: (" + minValidValue + "-" + maxValidValue + ")"));
                        ret = false;
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"*")) continue;
                    values.add(Integer.valueOf(ranges[0]));
                    continue;
                }
                value = "*";
                continue;
            }
            ret = false;
        }
        if (CollectionUtils.isNotEmpty(rangeOfValues)) {
            class RangeComparator
            implements Comparator<Range> {
                RangeComparator() {
                }

                @Override
                public int compare(Range me, Range other) {
                    int result = Integer.compare(me.lower, other.lower);
                    if (result == 0) {
                        result = Integer.compare(me.upper, other.upper);
                    }
                    return result;
                }
            }
            rangeOfValues.sort(new RangeComparator());
        }
        for (int i = 0; i < rangeOfValues.size(); ++i) {
            Range range = (Range)rangeOfValues.get(i);
            int upper = range.upper;
            for (int j = i + 1; j < rangeOfValues.size(); ++j) {
                Range r = (Range)rangeOfValues.get(j);
                if (upper <= r.lower) continue;
                validationFailures.add(new ValidationFailureDetails(0, fieldName, "", false, true, false, "overlapping range value"));
                ret = false;
            }
        }
        if (ret) {
            if (!StringUtils.equals(value, (CharSequence)"*")) {
                int minDiff;
                int n = minDiff = values.size() <= 1 ? maxValidValue + 1 : Integer.MAX_VALUE;
                if (values.size() > 1) {
                    Collections.sort(values);
                    for (int i = 0; i < values.size() - 1; ++i) {
                        int firstLastDiff;
                        int diff = (Integer)values.get(i + 1) - (Integer)values.get(i);
                        if (diff < minDiff) {
                            minDiff = diff;
                        }
                        if (minDiff <= (firstLastDiff = (Integer)values.get(0) + (maxValidValue - minValidValue + 1) - (Integer)values.get(values.size() - 1))) continue;
                        minDiff = firstLastDiff;
                    }
                }
                if (values.size() > 0) {
                    value = Integer.toString(minDiff);
                }
            }
            this.validityPeriodEstimator.setFieldValue(field, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set " + (Object)((Object)field) + " to " + value);
            }
        }
        return ret;
    }

    private String getNormalizedValue(RangerValidityRecurrence recurrence, RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec field) {
        String ret = null;
        if (RangerValidityRecurrence.ValidityInterval.getValidityIntervalInMinutes(recurrence.getInterval()) > 0) {
            String noWhiteSpace = StringUtils.deleteWhitespace((String)recurrence.getSchedule().getFieldValue(field));
            String[] specs = StringUtils.split((String)noWhiteSpace, (String)",");
            ArrayList<String> values = new ArrayList<String>();
            for (String spec : specs) {
                if (!StringUtils.isNotBlank((CharSequence)spec)) continue;
                values.add(spec);
            }
            if (values.size() > 0) {
                Collections.sort(values);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < values.size(); ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append((String)values.get(i));
                }
                ret = sb.toString();
            }
        }
        return ret;
    }
}

