/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.resourcematcher.AbstractStringResourceMatcher;

final class QuotedCaseSensitiveStartsWithMatcher
extends AbstractStringResourceMatcher {
    private final String quoteChars;

    QuotedCaseSensitiveStartsWithMatcher(String value, Map<String, String> options, String quoteChars) {
        super(value, options);
        this.quoteChars = quoteChars;
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
            return StringUtils.startsWith((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext));
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext));
    }

    @Override
    public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
        if (QuotedCaseSensitiveStartsWithMatcher.startsWithAnyChar(resourceValue, this.quoteChars)) {
            return StringUtils.startsWith((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue);
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue);
    }

    @Override
    int getPriority() {
        return 4 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

