/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.api;

import java.util.Properties;
import org.apache.ranger.authz.api.RangerAuthorizer;
import org.apache.ranger.authz.api.RangerAuthzApiErrorCode;
import org.apache.ranger.authz.api.RangerAuthzErrorCode;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizerFactory.class);
    public static final String PROPERTY_RANGER_AUTHORIZER_IMPL_CLASS = "ranger.authorizer.impl.class";
    public static final String DEFAULT_RANGER_AUTHORIZER_IMPL_CLASS = "org.apache.ranger.authz.embedded.RangerEmbeddedAuthorizer";

    public static RangerAuthorizer createAuthorizer(Properties properties) throws RangerAuthzException {
        String implClass = properties != null ? properties.getProperty(PROPERTY_RANGER_AUTHORIZER_IMPL_CLASS, DEFAULT_RANGER_AUTHORIZER_IMPL_CLASS) : DEFAULT_RANGER_AUTHORIZER_IMPL_CLASS;
        try {
            LOG.info("creating authorizer implementation of type: {}", (Object)implClass);
            return (RangerAuthorizer)Class.forName(implClass).getDeclaredConstructor(Properties.class).newInstance(properties);
        }
        catch (Exception e) {
            throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.AUTHORIZER_CREATION_FAILED, (Throwable)e, implClass);
        }
    }

    private RangerAuthorizerFactory() {
    }
}

