/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.SearchFilter;

public class ServicePredicateUtil
extends AbstractPredicateUtil {
    private ServiceStore serviceStore;

    public ServicePredicateUtil(ServiceStore serviceStore) {
        this.serviceStore = serviceStore;
    }

    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        super.addPredicates(filter, predicates);
        this.addPredicateForServiceType(filter.getParam("serviceType"), predicates);
        this.addPredicateForServiceId(filter.getParam("serviceId"), predicates);
        this.addPredicateForTagSeviceName(filter.getParam("tagServiceName"), predicates);
        this.addPredicateForTagSeviceId(filter.getParam("tagServiceId"), predicates);
    }

    private String getServiceType(String serviceName) {
        RangerService service = null;
        try {
            if (this.serviceStore != null) {
                service = this.serviceStore.getServiceByName(serviceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return service != null ? service.getType() : null;
    }

    private Long getServiceId(String serviceName) {
        RangerBaseModelObject service = null;
        try {
            if (this.serviceStore != null) {
                service = this.serviceStore.getServiceByName(serviceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return service != null ? service.getId() : null;
    }

    private Predicate addPredicateForServiceType(final String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)serviceType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals((CharSequence)serviceType, (CharSequence)ServicePredicateUtil.this.getServiceType(policy.getService()));
                } else if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals((CharSequence)serviceType, (CharSequence)service.getType());
                } else if (object instanceof RangerServiceDef) {
                    RangerServiceDef serviceDef = (RangerServiceDef)object;
                    ret = StringUtils.equals((CharSequence)serviceType, (CharSequence)serviceDef.getName());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceId(final String serviceId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    Long svcId = ServicePredicateUtil.this.getServiceId(policy.getService());
                    if (svcId != null) {
                        ret = StringUtils.equals((CharSequence)serviceId, (CharSequence)svcId.toString());
                    }
                } else if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    if (service.getId() != null) {
                        ret = StringUtils.equals((CharSequence)serviceId, (CharSequence)service.getId().toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagSeviceName(final String tagServiceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)tagServiceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals((CharSequence)tagServiceName, (CharSequence)service.getTagService());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagSeviceId(final String tagServiceId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)tagServiceId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    if (!StringUtils.isEmpty((CharSequence)service.getTagService())) {
                        RangerBaseModelObject tagService = null;
                        try {
                            tagService = ServicePredicateUtil.this.serviceStore.getServiceByName(service.getTagService());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ret = tagService != null && tagService.getId() != null && StringUtils.equals((CharSequence)tagServiceId, (CharSequence)tagService.getId().toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

