/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class RolePredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForRoleName(filter.getParam("roleName"), predicates);
        this.addPredicateForRoleId(filter.getParam("roleId"), predicates);
        this.addPredicateForGroupName(filter.getParam("groupName"), predicates);
        this.addPredicateForUserName(filter.getParam("userName"), predicates);
        this.addPredicateForPartialRoleName(filter.getParam("roleNamePartial"), predicates);
        this.addPredicateForPartialGroupName(filter.getParam("groupNamePartial"), predicates);
        this.addPredicateForPartialUserName(filter.getParam("userNamePartial"), predicates);
    }

    private Predicate addPredicateForRoleName(final String roleName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)roleName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    RangerRole role;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole) || (ret = StringUtils.equals((CharSequence)(role = (RangerRole)object).getName(), (CharSequence)roleName))) break block2;
                    List<RangerRole.RoleMember> roles = role.getRoles();
                    Iterator<RangerRole.RoleMember> iterator = roles.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((CharSequence)(member = iterator.next()).getName(), (CharSequence)roleName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialRoleName(final String roleNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)roleNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    RangerRole role;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole) || (ret = StringUtils.containsIgnoreCase((CharSequence)(role = (RangerRole)object).getName(), (CharSequence)roleNamePartial))) break block2;
                    List<RangerRole.RoleMember> roles = role.getRoles();
                    Iterator<RangerRole.RoleMember> iterator = roles.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((CharSequence)(member = iterator.next()).getName(), (CharSequence)roleNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForRoleId(final String roleId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)roleId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerRole) {
                    RangerRole role = (RangerRole)object;
                    ret = StringUtils.equals((CharSequence)roleId, (CharSequence)role.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForGroupName(final String groupName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> groups = role.getGroups();
                    Iterator<RangerRole.RoleMember> iterator = groups.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((CharSequence)(member = iterator.next()).getName(), (CharSequence)groupName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialGroupName(final String groupNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)groupNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> groups = role.getGroups();
                    Iterator<RangerRole.RoleMember> iterator = groups.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((CharSequence)(member = iterator.next()).getName(), (CharSequence)groupNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForUserName(final String userName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> users = role.getUsers();
                    Iterator<RangerRole.RoleMember> iterator = users.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((CharSequence)(member = iterator.next()).getName(), (CharSequence)userName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialUserName(final String userNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)userNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> users = role.getUsers();
                    Iterator<RangerRole.RoleMember> iterator = users.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((CharSequence)(member = iterator.next()).getName(), (CharSequence)userNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

