/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hadoop.AuthzContext;
import org.apache.ranger.authorization.hadoop.RangerHdfsAccessRequest;
import org.apache.ranger.authorization.hadoop.RangerHdfsAuditHandler;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.apache.ranger.authorization.hadoop.exceptions.RangerAccessControlException;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHdfsAuthorizer
extends INodeAttributeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsAuthorizer.class);
    private static final Logger PERF_HDFSAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hdfsauth.request");
    public static final String KEY_FILENAME = "FILENAME";
    public static final String KEY_BASE_FILENAME = "BASE_FILENAME";
    public static final String DEFAULT_FILENAME_EXTENSION_SEPARATOR = ".";
    public static final String KEY_RESOURCE_PATH = "path";
    public static final String RANGER_FILENAME_EXTENSION_SEPARATOR_PROP = "ranger.plugin.hdfs.filename.extension.separator";
    public static final String OPERATION_NAME_CREATE = "create";
    public static final String OPERATION_NAME_DELETE = "delete";
    public static final String OPERATION_NAME_RENAME = "rename";
    public static final String OPERATION_NAME_LISTSTATUS = "listStatus";
    public static final String OPERATION_NAME_MKDIRS = "mkdirs";
    public static final String OPERATION_NAME_GETEZFORPATH = "getEZForPath";
    private static final Set<String> OPTIMIZED_OPERATIONS = new HashSet<String>(){
        {
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_CREATE);
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_DELETE);
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_RENAME);
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_LISTSTATUS);
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_MKDIRS);
            this.add(RangerHdfsAuthorizer.OPERATION_NAME_GETEZFORPATH);
        }
    };
    private RangerHdfsPlugin rangerPlugin = null;
    private final Map<FsAction, Set<String>> access2ActionListMapper = new HashMap<FsAction, Set<String>>();
    private final Path addlConfigFile;
    private boolean AUTHZ_OPTIMIZATION_ENABLED = true;
    private final OptimizedAuthzContext OPT_BYPASS_AUTHZ = new OptimizedAuthzContext("", FsAction.NONE, FsAction.NONE, FsAction.NONE, AuthzStatus.ALLOW);

    public RangerHdfsAuthorizer() {
        this(null);
    }

    public RangerHdfsAuthorizer(Path addlConfigFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
        this.addlConfigFile = addlConfigFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.start()");
        }
        RangerHdfsPlugin plugin = new RangerHdfsPlugin(this.addlConfigFile);
        plugin.init();
        if (plugin.isOptimizeSubAccessAuthEnabled()) {
            LOG.info("ranger.optimize-subaccess-authorization is enabled");
        }
        LOG.info("Legacy way of authorizing sub-access requests will " + (plugin.isUseLegacySubAccessAuthorization() ? "" : "not ") + "be used");
        this.access2ActionListMapper.put(FsAction.NONE, new TreeSet());
        this.access2ActionListMapper.put(FsAction.ALL, Stream.of("read", "write", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.READ, Stream.of("read").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.READ_WRITE, Stream.of("read", "write").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.READ_EXECUTE, Stream.of("read", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.WRITE, Stream.of("write").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.WRITE_EXECUTE, Stream.of("write", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.access2ActionListMapper.put(FsAction.EXECUTE, Stream.of("execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        this.rangerPlugin = plugin;
        this.AUTHZ_OPTIMIZATION_ENABLED = plugin.getConfig().getBoolean("ranger.hdfs.authz.enable.optimization", false);
        LOG.info("AUTHZ_OPTIMIZATION_ENABLED:[" + this.AUTHZ_OPTIMIZATION_ENABLED + "]");
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.start()");
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.stop()");
        }
        RangerHdfsPlugin plugin = this.rangerPlugin;
        this.rangerPlugin = null;
        if (plugin != null) {
            plugin.cleanup();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.stop()");
        }
    }

    public INodeAttributes getAttributes(String fullPath, INodeAttributes inode) {
        return inode;
    }

    public INodeAttributes getAttributes(String[] pathElements, INodeAttributes inode) {
        return inode;
    }

    public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        RangerAccessControlEnforcer rangerAce = new RangerAccessControlEnforcer(defaultEnforcer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        return rangerAce;
    }

    public Configuration getConfig() {
        return this.rangerPlugin.getConfig();
    }

    static class OptimizedAuthzContext {
        private final String path;
        private final FsAction ancestorAccess;
        private final FsAction parentAccess;
        private final FsAction access;
        private AuthzStatus authzStatus;

        OptimizedAuthzContext(String path, FsAction ancestorAccess, FsAction parentAccess, FsAction access, AuthzStatus authzStatus) {
            this.path = path;
            this.ancestorAccess = ancestorAccess;
            this.parentAccess = parentAccess;
            this.access = access;
            this.authzStatus = authzStatus;
        }

        public String toString() {
            return "path=" + this.path + ", authzStatus=" + (Object)((Object)this.authzStatus);
        }
    }

    class RangerAccessControlEnforcer
    implements INodeAttributeProvider.AccessControlEnforcer {
        private final INodeAttributeProvider.AccessControlEnforcer defaultEnforcer;
        private Map<String, OptimizedAuthzContext> CACHE = null;

        public RangerAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
            }
            this.defaultEnforcer = defaultEnforcer;
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
            }
        }

        public void checkPermissionWithContext(INodeAttributeProvider.AuthorizationContext authzContext) throws AccessControlException {
            this.checkRangerPermission(authzContext.getFsOwner(), authzContext.getSupergroup(), authzContext.getCallerUgi(), authzContext.getInodeAttrs(), authzContext.getInodes(), authzContext.getPathByNameArr(), authzContext.getSnapshotId(), authzContext.getPath(), authzContext.getAncestorIndex(), authzContext.isDoCheckOwner(), authzContext.getAncestorAccess(), authzContext.getParentAccess(), authzContext.getAccess(), authzContext.getSubAccess(), authzContext.isIgnoreEmptyDir(), authzContext.getOperationName(), authzContext.getCallerContext());
        }

        public void checkPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
            this.checkRangerPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void checkRangerPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, String operationName, CallerContext callerContext) throws AccessControlException {
            INode inode;
            INode parent;
            INode ancestor;
            RangerPerfTracer perf;
            OptimizedAuthzContext optAuthzContext;
            AuthzContext context;
            String resourcePath;
            AuthzStatus authzStatus;
            block63: {
                INodeAttributes inodeAttribs;
                String parentPath;
                INodeAttributes parentAttribs;
                String ancestorPath;
                INodeAttributes ancestorAttribs;
                byte[][] components;
                boolean doNotGenerateAuditRecord;
                boolean useDefaultAuthorizerOnly;
                String providedPath;
                block66: {
                    FsAction action;
                    block67: {
                        block68: {
                            block64: {
                                block65: {
                                    authzStatus = AuthzStatus.NOT_DETERMINED;
                                    resourcePath = path;
                                    context = new AuthzContext(RangerHdfsAuthorizer.this.rangerPlugin, ugi, operationName, access == null && parentAccess == null && ancestorAccess == null && subAccess == null);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("==> RangerAccessControlEnforcer.checkRangerPermission(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", user=" + context.user + ", provided-path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", operationName=" + operationName + ", callerContext=" + callerContext + ")");
                                    }
                                    if (LOG.isDebugEnabled()) {
                                        LOG.info("operationName={}, path={}, user={}, ancestorIndex={}, ancestorAccess={}, parentAccess={}, access={}, subAccess={}", new Object[]{context.operationName, path, context.user, ancestorIndex, ancestorAccess, parentAccess, access, subAccess});
                                    }
                                    optAuthzContext = null;
                                    perf = null;
                                    if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                                        perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerHdfsAuthorizer.checkRangerPermission(provided-path=" + path + ")"));
                                    }
                                    try {
                                        block70: {
                                            int i;
                                            block69: {
                                                ancestor = null;
                                                parent = null;
                                                inode = null;
                                                providedPath = path;
                                                useDefaultAuthorizerOnly = false;
                                                doNotGenerateAuditRecord = false;
                                                if (context.plugin == null || ArrayUtils.isEmpty((Object[])inodes)) break block63;
                                                int sz = inodeAttrs.length;
                                                if (LOG.isTraceEnabled()) {
                                                    LOG.trace("Size of INodeAttrs array:[" + sz + "]");
                                                    LOG.trace("Size of INodes array:[" + inodes.length + "]");
                                                }
                                                components = new byte[sz][];
                                                for (i = 0; i < sz && inodeAttrs[i] != null; ++i) {
                                                    components[i] = inodeAttrs[i].getLocalNameBytes();
                                                }
                                                if (i != sz && LOG.isTraceEnabled()) {
                                                    LOG.trace("Input INodeAttributes array contains null at position " + i);
                                                    LOG.trace("Will use only first [" + i + "] components");
                                                }
                                                if (sz != 1 || inodes.length != 1 || inodes[0].getParent() == null) break block69;
                                                doNotGenerateAuditRecord = true;
                                                if (LOG.isTraceEnabled()) {
                                                    LOG.trace("Using the only inode in the array to figure out path to resource. No audit record will be generated for this authorization request");
                                                }
                                                resourcePath = inodes[0].getFullPathName();
                                                if (snapshotId != 0x7FFFFFFE) {
                                                    useDefaultAuthorizerOnly = true;
                                                    if (LOG.isTraceEnabled()) {
                                                        LOG.trace("path:[" + resourcePath + "] is for a snapshot, id=[" + snapshotId + "], default Authorizer will be used to authorize this request");
                                                    }
                                                    break block70;
                                                } else if (LOG.isTraceEnabled()) {
                                                    LOG.trace("path:[" + resourcePath + "] is not for a snapshot, id=[" + snapshotId + "]. It will be used to authorize this request");
                                                }
                                                break block70;
                                            }
                                            if (snapshotId != 0x7FFFFFFE) {
                                                resourcePath = DFSUtil.byteArray2PathString((byte[][])pathByNameArr);
                                                if (LOG.isTraceEnabled()) {
                                                    LOG.trace("pathByNameArr array is used to figure out path to resource, resourcePath:[" + resourcePath + "]");
                                                }
                                            } else {
                                                resourcePath = DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)i);
                                                if (LOG.isTraceEnabled()) {
                                                    LOG.trace("INodeAttributes array is used to figure out path to resource, resourcePath:[" + resourcePath + "]");
                                                }
                                            }
                                        }
                                        if (ancestorIndex >= inodes.length) {
                                            ancestorIndex = inodes.length - 1;
                                        }
                                        while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
                                            --ancestorIndex;
                                        }
                                        ancestor = inodes.length > ancestorIndex && ancestorIndex >= 0 ? inodes[ancestorIndex] : null;
                                        optAuthzContext = new OperationOptimizer(operationName, resourcePath, ancestorAccess, parentAccess, access, subAccess, components, inodeAttrs, ancestorIndex, ancestor, parent = inodes.length > 1 ? inodes[inodes.length - 2] : null, inode = inodes[inodes.length - 1]).optimize();
                                        if (optAuthzContext != RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ) break block64;
                                        authzStatus = AuthzStatus.ALLOW;
                                        if (context.auditHandler == null) break block65;
                                        context.auditHandler.flushAudit();
                                    }
                                    catch (Throwable throwable) {
                                        if (context.auditHandler != null) {
                                            context.auditHandler.flushAudit();
                                        }
                                        if (optAuthzContext != null && optAuthzContext != RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug("Updating OptimizedAuthzContext:[" + optAuthzContext + "] with authzStatus=" + authzStatus.name() + "]");
                                            }
                                            optAuthzContext.authzStatus = authzStatus;
                                        }
                                        RangerPerfTracer.log(perf);
                                        if (!LOG.isDebugEnabled()) throw throwable;
                                        LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
                                        throw throwable;
                                    }
                                }
                                if (optAuthzContext != null && optAuthzContext != RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Updating OptimizedAuthzContext:[" + optAuthzContext + "] with authzStatus=" + authzStatus.name() + "]");
                                    }
                                    optAuthzContext.authzStatus = authzStatus;
                                }
                                RangerPerfTracer.log((RangerPerfTracer)perf);
                                if (!LOG.isDebugEnabled()) return;
                                LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
                                return;
                            }
                            if (optAuthzContext == null || optAuthzContext.authzStatus == null) break block66;
                            authzStatus = optAuthzContext.authzStatus;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("OperationOptimizer.optimize() returned " + (Object)((Object)authzStatus) + ", operationName=" + operationName + " has been pre-computed. Returning without any access evaluation!");
                            }
                            if (authzStatus != AuthzStatus.ALLOW) break block67;
                            if (context.auditHandler == null) break block68;
                            context.auditHandler.flushAudit();
                        }
                        if (optAuthzContext != null && optAuthzContext != RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Updating OptimizedAuthzContext:[" + optAuthzContext + "] with authzStatus=" + authzStatus.name() + "]");
                            }
                            optAuthzContext.authzStatus = authzStatus;
                        }
                        RangerPerfTracer.log((RangerPerfTracer)perf);
                        if (!LOG.isDebugEnabled()) return;
                        LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
                        return;
                    }
                    if (access != null) {
                        action = access;
                        throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                    }
                    if (parentAccess != null) {
                        action = parentAccess;
                        throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                    }
                    if (ancestorAccess != null) {
                        action = ancestorAccess;
                        throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                    }
                    action = FsAction.EXECUTE;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                AuthzStatus authzStatus2 = authzStatus = useDefaultAuthorizerOnly ? AuthzStatus.NOT_DETERMINED : AuthzStatus.ALLOW;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OperationOptimizer.optimize() returned null, operationName=" + operationName + " needs to be evaluated!");
                }
                if (optAuthzContext != null) {
                    access = optAuthzContext.access;
                    parentAccess = optAuthzContext.parentAccess;
                    ancestorAccess = optAuthzContext.ancestorAccess;
                }
                boolean bl = context.isTraverseOnlyCheck = parentAccess == null && ancestorAccess == null && access == null && subAccess == null;
                RangerHdfsAuditHandler rangerHdfsAuditHandler = doNotGenerateAuditRecord ? null : (context.auditHandler = new RangerHdfsAuditHandler(providedPath, context.isTraverseOnlyCheck, context.plugin.getHadoopModuleName(), context.plugin.getExcludedUsers(), callerContext != null ? callerContext.toString() : null));
                if (authzStatus == AuthzStatus.ALLOW && context.isTraverseOnlyCheck) {
                    authzStatus = this.traverseOnlyCheck(inode, inodeAttrs, resourcePath, components, parent, ancestor, ancestorIndex, context);
                }
                if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parentAccess.implies(FsAction.WRITE) && parent != null && inode != null && parent.getFsPermission() != null && parent.getFsPermission().getStickyBit()) {
                    AuthzStatus authzStatus3 = authzStatus = StringUtils.equals((CharSequence)parent.getUserName(), (CharSequence)context.user) || StringUtils.equals((CharSequence)inode.getUserName(), (CharSequence)context.user) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
                }
                if (authzStatus == AuthzStatus.ALLOW && ancestorAccess != null && ancestor != null && (authzStatus = this.isAccessAllowed(ancestor, ancestorAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null, ancestorPath = ancestorAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : null, ancestorAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                    authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, null, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
                }
                if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parent != null && (authzStatus = this.isAccessAllowed(parent, parentAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null, parentPath = parentAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : null, parentAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                    authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, parentAccess, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
                }
                if (authzStatus == AuthzStatus.ALLOW && access != null && inode != null && (authzStatus = this.isAccessAllowed(inode, inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null, resourcePath, access, context)) == AuthzStatus.NOT_DETERMINED) {
                    authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, access, null, ignoreEmptyDir, ancestor, parent, inode, context);
                }
                if (authzStatus == AuthzStatus.ALLOW && subAccess != null && inode != null && inode.isDirectory()) {
                    Stack<SubAccessData> directories = new Stack<SubAccessData>();
                    directories.push(new SubAccessData(inode.asDirectory(), resourcePath, inodes, inodeAttrs));
                    while (!directories.isEmpty()) {
                        byte[][] dirComponents;
                        INode dirParent;
                        INode dirAncestor;
                        int dirAncestorIndex;
                        INode[] dirINodes;
                        INodeAttributes[] dirINodeAttrs;
                        INodeDirectory dirINode;
                        SubAccessData data = (SubAccessData)directories.pop();
                        ReadOnlyList cList = data.dir.getChildrenList(snapshotId);
                        if (cList.isEmpty() && ignoreEmptyDir) continue;
                        INodeDirectoryAttributes dirAttribs = data.dir.getSnapshotINode(snapshotId);
                        authzStatus = this.isAccessAllowed((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                        if (data.dir.equals((Object)inode)) {
                            dirINode = inode.asDirectory();
                            dirINodeAttrs = inodeAttrs;
                            dirINodes = inodes;
                            dirAncestorIndex = ancestorIndex;
                            dirAncestor = ancestor;
                            dirParent = parent;
                            dirComponents = pathByNameArr;
                        } else {
                            int idx;
                            dirINode = data.dir;
                            INodeAttributes[] curINodeAttributes = data.iNodeAttributes;
                            INode[] curINodes = data.inodes;
                            dirINodes = new INode[curINodes.length + 1];
                            for (idx = 0; idx < curINodes.length; ++idx) {
                                dirINodes[idx] = curINodes[idx];
                            }
                            dirINodes[idx] = dirINode;
                            dirINodeAttrs = new INodeAttributes[curINodeAttributes.length + 1];
                            for (idx = 0; idx < curINodeAttributes.length; ++idx) {
                                dirINodeAttrs[idx] = curINodeAttributes[idx];
                            }
                            dirINodeAttrs[idx] = dirAttribs;
                            for (dirAncestorIndex = dirINodes.length - 1; dirAncestorIndex >= 0 && dirINodes[dirAncestorIndex] == null; --dirAncestorIndex) {
                            }
                            dirAncestor = dirINodes.length > dirAncestorIndex && dirAncestorIndex >= 0 ? dirINodes[dirAncestorIndex] : null;
                            dirParent = dirINodes.length > 1 ? dirINodes[dirINodes.length - 2] : null;
                            dirComponents = dirINode.getPathComponents();
                        }
                        if (authzStatus == AuthzStatus.NOT_DETERMINED && !RangerHdfsAuthorizer.this.rangerPlugin.isUseLegacySubAccessAuthorization()) {
                            if (LOG.isDebugEnabled()) {
                                if (data.dir.equals((Object)inode)) {
                                    LOG.debug("Top level directory being processed for default authorizer call, [" + data.resourcePath + "]");
                                } else {
                                    LOG.debug("Sub directory being processed for default authorizer call, [" + data.resourcePath + "]");
                                }
                                LOG.debug("Calling default authorizer for hierarchy/subaccess with the following parameters");
                                LOG.debug("fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (dirINodes != null ? dirINodes.length : 0) + ", snapshotId=" + snapshotId + ", user=" + (ugi != null ? ugi.getShortUserName() : null) + ", provided-path=" + data.resourcePath + ", ancestorIndex=" + dirAncestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=null, parentAccess=null, access=null, subAccess=null, ignoreEmptyDir=" + ignoreEmptyDir + ", operationName=" + operationName + ", callerContext=null");
                            }
                            authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, dirINodeAttrs, dirINodes, dirComponents, snapshotId, data.resourcePath, dirAncestorIndex, doCheckOwner, null, null, null, null, ignoreEmptyDir, dirAncestor, dirParent, (INode)dirINode, context);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Default authorizer call returned : [" + (Object)((Object)authzStatus) + "]");
                            }
                        }
                        if (authzStatus != AuthzStatus.ALLOW) break;
                        AuthzStatus subDirAuthStatus = AuthzStatus.NOT_DETERMINED;
                        boolean optimizeSubAccessAuthEnabled = RangerHdfsAuthorizer.this.rangerPlugin.isOptimizeSubAccessAuthEnabled();
                        if (optimizeSubAccessAuthEnabled) {
                            subDirAuthStatus = this.isAccessAllowedForHierarchy((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                        }
                        if (subDirAuthStatus == AuthzStatus.ALLOW) continue;
                        for (INode child : cList) {
                            if (!child.isDirectory()) continue;
                            if (data.resourcePath.endsWith("/")) {
                                directories.push(new SubAccessData(child.asDirectory(), data.resourcePath + child.getLocalName(), dirINodes, dirINodeAttrs));
                                continue;
                            }
                            directories.push(new SubAccessData(child.asDirectory(), data.resourcePath + '/' + child.getLocalName(), dirINodes, dirINodeAttrs));
                        }
                    }
                    if (authzStatus == AuthzStatus.NOT_DETERMINED) {
                        authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, null, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
                    }
                }
                if (authzStatus == AuthzStatus.ALLOW && doCheckOwner) {
                    inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
                    String owner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
                    AuthzStatus authzStatus4 = authzStatus = StringUtils.equals((CharSequence)context.user, (CharSequence)owner) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
                }
            }
            if (authzStatus == AuthzStatus.NOT_DETERMINED) {
                authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
            }
            if (authzStatus != AuthzStatus.ALLOW) {
                FsAction action = access;
                if (action != null) throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                if (parentAccess != null) {
                    action = parentAccess;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                if (ancestorAccess != null) {
                    action = ancestorAccess;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                action = FsAction.EXECUTE;
                throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
            }
            if (context.auditHandler != null) {
                context.auditHandler.flushAudit();
            }
            if (optAuthzContext != null && optAuthzContext != RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating OptimizedAuthzContext:[" + optAuthzContext + "] with authzStatus=" + authzStatus.name() + "]");
                }
                optAuthzContext.authzStatus = authzStatus;
            }
            RangerPerfTracer.log((RangerPerfTracer)perf);
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
        }

        private AuthzStatus traverseOnlyCheck(INode inode, INodeAttributes[] inodeAttrs, String path, byte[][] components, INode parent, INode ancestor, int ancestorIndex, AuthzContext context) {
            AuthzStatus ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.traverseOnlyCheck(path=" + path + ", user=" + context.user + ", groups=" + context.userGroups + ", operationName=" + context.operationName + ")");
            }
            INode nodeToCheck = inode;
            INodeAttributes nodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
            boolean skipAuditOnAllow = false;
            String resourcePath = path;
            if (nodeToCheck == null || nodeToCheck.isFile()) {
                skipAuditOnAllow = true;
                if (parent != null) {
                    nodeToCheck = parent;
                    nodeAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null;
                    resourcePath = inodeAttrs.length > 0 ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : "/";
                } else if (ancestor != null) {
                    nodeToCheck = ancestor;
                    nodeAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null;
                    String string = resourcePath = nodeAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : "/";
                }
            }
            if (nodeToCheck != null) {
                if (resourcePath.length() > 1 && resourcePath.endsWith("/")) {
                    resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
                }
                ret = this.isAccessAllowedForTraversal(nodeToCheck, nodeAttribs, resourcePath, skipAuditOnAllow, context, context.operationName);
            } else {
                ret = AuthzStatus.ALLOW;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.traverseOnlyCheck(path=" + path + ", resourcePath=" + resourcePath + ", user=" + context.user + ", groups=" + context.userGroups + ", operationName=" + context.operationName + ") : " + (Object)((Object)ret));
            }
            return ret;
        }

        private AuthzStatus isAccessAllowedForTraversal(INode inode, INodeAttributes inodeAttribs, String path, boolean skipAuditOnAllow, AuthzContext context, String operation) {
            String pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            FsAction access = FsAction.EXECUTE;
            if (pathOwner == null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForTraversal(" + path + ", " + access + ", " + context.user + ", " + skipAuditOnAllow + ", " + context.operationName + ")");
            }
            RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, "execute", operation, context.user, context.userGroups);
            RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, null);
            context.saveResult(result);
            AuthzStatus ret = result != null && result.getIsAccessDetermined() && !result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW;
            if (ret == AuthzStatus.ALLOW && LOG.isDebugEnabled()) {
                LOG.debug("This request is for the first time allowed by Ranger policies. request:[" + (Object)((Object)request) + "]");
            }
            if ((ret == AuthzStatus.DENY || !skipAuditOnAllow && result != null && result.getIsAccessDetermined()) && context.auditHandler != null) {
                context.auditHandler.processResult(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForTraversal(" + path + ", " + access + ", " + context.user + ", " + skipAuditOnAllow + ", " + context.operationName + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AuthzStatus checkDefaultEnforcer(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, INode ancestor, INode parent, INode inode, AuthzContext context) throws AccessControlException {
            AuthzStatus authzStatus;
            block31: {
                RangerPerfTracer hadoopAuthPerf;
                block29: {
                    FsAction action;
                    INode nodeChecked;
                    block32: {
                        block30: {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("==> RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", isTraverseOnlyCheck=" + context.isTraverseOnlyCheck + ",ancestor=" + (ancestor == null ? null : ancestor.getFullPathName()) + ", parent=" + (parent == null ? null : parent.getFullPathName()) + ", inode=" + (inode == null ? null : inode.getFullPathName()) + ")");
                            }
                            authzStatus = AuthzStatus.NOT_DETERMINED;
                            if (!RangerHdfsAuthorizer.this.rangerPlugin.isHadoopAuthEnabled() || this.defaultEnforcer == null) break block31;
                            hadoopAuthPerf = null;
                            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                                hadoopAuthPerf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerAccessControlEnforcer.checkDefaultEnforcer(path=" + path + ")"));
                            }
                            try {
                                this.defaultEnforcer.checkPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
                                authzStatus = AuthzStatus.ALLOW;
                                if (context.auditHandler == null) break block29;
                                nodeChecked = inode;
                                action = access;
                                if (!context.isTraverseOnlyCheck) break block30;
                            }
                            catch (Throwable throwable) {
                                if (context.auditHandler != null) {
                                    INode nodeChecked2 = inode;
                                    FsAction action2 = access;
                                    if (context.isTraverseOnlyCheck) {
                                        if (nodeChecked2 == null || nodeChecked2.isFile()) {
                                            if (parent != null) {
                                                nodeChecked2 = parent;
                                            } else if (ancestor != null) {
                                                nodeChecked2 = ancestor;
                                            }
                                        }
                                        action2 = FsAction.EXECUTE;
                                    } else if (action2 == null || action2 == FsAction.NONE) {
                                        if (parentAccess != null && parentAccess != FsAction.NONE) {
                                            nodeChecked2 = parent;
                                            action2 = parentAccess;
                                        } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                                            nodeChecked2 = ancestor;
                                            action2 = ancestorAccess;
                                        } else if (subAccess != null && subAccess != FsAction.NONE) {
                                            action2 = subAccess;
                                        }
                                    }
                                    String pathChecked = nodeChecked2 != null ? nodeChecked2.getFullPathName() : path;
                                    boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                                    RangerAccessResult lastResult = context.getLastResult();
                                    if (lastResult != null) {
                                        lastResult.setIsAllowed(isAllowed);
                                        lastResult.setIsAccessDetermined(true);
                                        context.plugin.evalAuditPolicies(lastResult);
                                        context.auditHandler.processResult(lastResult);
                                    }
                                    context.auditHandler.logHadoopEvent(pathChecked, action2, isAllowed);
                                }
                                RangerPerfTracer.log(hadoopAuthPerf);
                                throw throwable;
                            }
                            if (nodeChecked == null || nodeChecked.isFile()) {
                                if (parent != null) {
                                    nodeChecked = parent;
                                } else if (ancestor != null) {
                                    nodeChecked = ancestor;
                                }
                            }
                            action = FsAction.EXECUTE;
                            break block32;
                        }
                        if (action == null || action == FsAction.NONE) {
                            if (parentAccess != null && parentAccess != FsAction.NONE) {
                                nodeChecked = parent;
                                action = parentAccess;
                            } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                                nodeChecked = ancestor;
                                action = ancestorAccess;
                            } else if (subAccess != null && subAccess != FsAction.NONE) {
                                action = subAccess;
                            }
                        }
                    }
                    String pathChecked = nodeChecked != null ? nodeChecked.getFullPathName() : path;
                    boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                    RangerAccessResult lastResult = context.getLastResult();
                    if (lastResult != null) {
                        lastResult.setIsAllowed(isAllowed);
                        lastResult.setIsAccessDetermined(true);
                        context.plugin.evalAuditPolicies(lastResult);
                        context.auditHandler.processResult(lastResult);
                    }
                    context.auditHandler.logHadoopEvent(pathChecked, action, isAllowed);
                }
                RangerPerfTracer.log((RangerPerfTracer)hadoopAuthPerf);
            }
            LOG.debug("<== RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", isTraverseOnlyCheck=" + context.isTraverseOnlyCheck + ",ancestor=" + (ancestor == null ? null : ancestor.getFullPathName()) + ", parent=" + (parent == null ? null : parent.getFullPathName()) + ", inode=" + (inode == null ? null : inode.getFullPathName()) + ") : " + (Object)((Object)authzStatus));
            return authzStatus;
        }

        private AuthzStatus isAccessAllowed(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
            Set accessTypes;
            String pathOwner;
            AuthzStatus ret = null;
            String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            if (pathOwner == null && inode != null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + ")");
            }
            if ((accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(access)) == null) {
                LOG.warn("RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + "): no Ranger accessType found for " + access);
                accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.NONE);
            }
            if (accessTypes.size() > 0) {
                RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, (String)accessTypes.iterator().next(), context.operationName, context.user, context.userGroups);
                if (accessTypes.size() > 1) {
                    Set allAccessTypeGroups = accessTypes.stream().map(Collections::singleton).collect(Collectors.toSet());
                    RangerAccessRequestUtil.setAllRequestedAccessTypeGroups((RangerAccessRequest)request, allAccessTypeGroups);
                    RangerAccessRequestUtil.setAllRequestedAccessTypes((Map)request.getContext(), (Set)accessTypes);
                    if (accessTypes.contains("execute")) {
                        RangerAccessRequestUtil.setIgnoreIfNotDeniedAccessTypes((Map)request.getContext(), (Set)((Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.EXECUTE)));
                    }
                }
                RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)context.auditHandler);
                context.saveResult(result);
                ret = result == null || !result.getIsAccessDetermined() ? AuthzStatus.NOT_DETERMINED : (!result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW);
                if (ret == AuthzStatus.ALLOW && LOG.isDebugEnabled()) {
                    LOG.debug("This request is for the first time allowed by Ranger policies. request:[" + (Object)((Object)request) + "]");
                }
            }
            if (ret == null) {
                ret = AuthzStatus.NOT_DETERMINED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        private AuthzStatus isAccessAllowedForHierarchy(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
            String pathOwner;
            AuthzStatus ret = null;
            String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            if (pathOwner == null && inode != null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + ")");
            }
            if (path != null) {
                String subDirPath;
                Set accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(access);
                if (accessTypes == null) {
                    LOG.warn("RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + "): no Ranger accessType found for " + access);
                    accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.NONE);
                }
                if ((subDirPath = path).charAt(subDirPath.length() - 1) != '/') {
                    subDirPath = subDirPath + Character.toString('/');
                }
                subDirPath = subDirPath + RangerHdfsAuthorizer.this.rangerPlugin.getRandomizedWildcardPathName();
                if (accessTypes.size() > 0) {
                    RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(null, subDirPath, pathOwner, access, (String)accessTypes.iterator().next(), context.operationName, context.user, context.userGroups);
                    if (accessTypes.size() > 1) {
                        Set allAccessTypeGroups = accessTypes.stream().map(Collections::singleton).collect(Collectors.toSet());
                        RangerAccessRequestUtil.setAllRequestedAccessTypeGroups((RangerAccessRequest)request, allAccessTypeGroups);
                        RangerAccessRequestUtil.setAllRequestedAccessTypes((Map)request.getContext(), (Set)accessTypes);
                        if (accessTypes.contains("execute")) {
                            RangerAccessRequestUtil.setIgnoreIfNotDeniedAccessTypes((Map)request.getContext(), (Set)((Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.EXECUTE)));
                        }
                    }
                    RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, null);
                    context.saveResult(result);
                    ret = result == null || !result.getIsAccessDetermined() ? AuthzStatus.NOT_DETERMINED : (!result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW);
                }
            }
            if (ret == null) {
                ret = AuthzStatus.NOT_DETERMINED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        class OperationOptimizer {
            private final String operationName;
            private final byte[][] components;
            private final INodeAttributes[] inodeAttrs;
            private final int ancestorIndex;
            private final INode ancestor;
            private final INode parent;
            private final INode inode;
            private String resourcePath;
            private FsAction ancestorAccess;
            private FsAction parentAccess;
            private FsAction access;
            private final FsAction subAccess;

            OperationOptimizer(String operationName, String resourcePath, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, byte[][] components, INodeAttributes[] inodeAttrs, int ancestorIndex, INode ancestor, INode parent, INode inode) {
                this.operationName = operationName;
                this.resourcePath = resourcePath;
                this.ancestorAccess = ancestorAccess;
                this.parentAccess = parentAccess;
                this.access = access;
                this.subAccess = subAccess;
                this.components = components;
                this.inodeAttrs = inodeAttrs;
                this.ancestorIndex = ancestorIndex;
                this.ancestor = ancestor;
                this.parent = parent;
                this.inode = inode;
            }

            OptimizedAuthzContext optimize() {
                if (!RangerHdfsAuthorizer.this.AUTHZ_OPTIMIZATION_ENABLED || !OPTIMIZED_OPERATIONS.contains(this.operationName)) {
                    return null;
                }
                return this.optimizeOp(this.operationName);
            }

            OptimizedAuthzContext optimizeOp(String operationName) {
                switch (operationName) {
                    case "create": {
                        return this.optimizeCreateOp();
                    }
                    case "delete": {
                        return this.optimizeDeleteOp();
                    }
                    case "rename": {
                        return this.optimizeRenameOp();
                    }
                    case "mkdirs": {
                        return this.optimizeMkdirsOp();
                    }
                    case "listStatus": {
                        return this.optimizeListStatusOp();
                    }
                    case "getEZForPath": {
                        return this.optimizeGetEZForPathOp();
                    }
                }
                return null;
            }

            private OptimizedAuthzContext optimizeCreateOp() {
                INode nodeToAuthorize = this.getINodeToAuthorize();
                if (nodeToAuthorize == null) {
                    return RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ;
                }
                if (!nodeToAuthorize.isDirectory() && this.access == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nodeToCheck is not a directory and access is null for a create operation! Optimization skipped");
                    }
                    return null;
                }
                return this.getOrCreateOptimizedAuthzContext();
            }

            private OptimizedAuthzContext optimizeDeleteOp() {
                int numOfRequestedAccesses = 0;
                if (this.ancestorAccess != null) {
                    ++numOfRequestedAccesses;
                }
                if (this.parentAccess != null) {
                    ++numOfRequestedAccesses;
                }
                if (this.access != null) {
                    ++numOfRequestedAccesses;
                }
                if (this.subAccess != null) {
                    ++numOfRequestedAccesses;
                }
                if (numOfRequestedAccesses == 0) {
                    return RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ;
                }
                this.parentAccess = FsAction.WRITE_EXECUTE;
                return this.getOrCreateOptimizedAuthzContext();
            }

            private OptimizedAuthzContext optimizeRenameOp() {
                INode nodeToAuthorize = this.getINodeToAuthorize();
                if (nodeToAuthorize == null) {
                    return RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ;
                }
                if (!nodeToAuthorize.isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nodeToCheck is not a directory for a rename operation! Optimization skipped");
                    }
                    return null;
                }
                return this.getOrCreateOptimizedAuthzContext();
            }

            private OptimizedAuthzContext optimizeMkdirsOp() {
                INode nodeToAuthorize = this.getINodeToAuthorize();
                if (nodeToAuthorize == null) {
                    return RangerHdfsAuthorizer.this.OPT_BYPASS_AUTHZ;
                }
                if (!nodeToAuthorize.isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nodeToCheck is not a directory for a mkdirs operation! Optimization skipped");
                    }
                    return null;
                }
                return this.getOrCreateOptimizedAuthzContext();
            }

            private OptimizedAuthzContext optimizeListStatusOp() {
                if (this.inode == null || this.inode.isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("inode is null or is a file for a listStatus/getEZForPath operation! Optimization skipped");
                    }
                    return null;
                }
                if (this.resourcePath.length() > 1 && this.resourcePath.endsWith("/")) {
                    this.resourcePath = this.resourcePath.substring(0, this.resourcePath.length() - 1);
                }
                this.access = FsAction.READ_EXECUTE;
                return this.getOrCreateOptimizedAuthzContext();
            }

            private OptimizedAuthzContext optimizeGetEZForPathOp() {
                if (this.inode == null || this.inode.isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("inode is null or is a file for a listStatus/getEZForPath operation! Optimization skipped");
                    }
                    return null;
                }
                this.access = FsAction.READ_EXECUTE;
                return this.getOrCreateOptimizedAuthzContext();
            }

            private INode getINodeToAuthorize() {
                INode ret = null;
                INode nodeToAuthorize = this.inode;
                if (nodeToAuthorize == null || nodeToAuthorize.isFile()) {
                    if (StringUtils.equals((CharSequence)this.operationName, (CharSequence)RangerHdfsAuthorizer.OPERATION_NAME_CREATE) && this.inode != null && this.access != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Create operation with non-null access is being authorized. authorize for write access for the file!!");
                        }
                    } else {
                        if (this.parent != null) {
                            nodeToAuthorize = this.parent;
                            this.resourcePath = this.inodeAttrs.length > 0 ? DFSUtil.byteArray2PathString((byte[][])this.components, (int)0, (int)(this.inodeAttrs.length - 1)) : "/";
                            this.parentAccess = FsAction.WRITE_EXECUTE;
                        } else if (this.ancestor != null) {
                            INodeAttributes nodeAttribs = this.inodeAttrs.length > this.ancestorIndex ? this.inodeAttrs[this.ancestorIndex] : null;
                            nodeToAuthorize = this.ancestor;
                            this.resourcePath = nodeAttribs != null ? DFSUtil.byteArray2PathString((byte[][])this.components, (int)0, (int)(this.ancestorIndex + 1)) : "/";
                            this.ancestorAccess = FsAction.WRITE_EXECUTE;
                        }
                        if (this.resourcePath.length() > 1 && this.resourcePath.endsWith("/")) {
                            this.resourcePath = this.resourcePath.substring(0, this.resourcePath.length() - 1);
                        }
                    }
                    ret = nodeToAuthorize;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("inode is not null and it is not a file for a create/rename/mkdirs operation! Optimization skipped");
                }
                return ret;
            }

            private OptimizedAuthzContext getOrCreateOptimizedAuthzContext() {
                OptimizedAuthzContext opContext;
                if (RangerAccessControlEnforcer.this.CACHE == null) {
                    RangerAccessControlEnforcer.this.CACHE = new HashMap();
                }
                if ((opContext = (OptimizedAuthzContext)RangerAccessControlEnforcer.this.CACHE.get(this.resourcePath)) == null) {
                    opContext = new OptimizedAuthzContext(this.resourcePath, this.ancestorAccess, this.parentAccess, this.access, null);
                    RangerAccessControlEnforcer.this.CACHE.put(this.resourcePath, opContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Added OptimizedAuthzContext:[" + opContext + "] to cache");
                    }
                }
                return opContext;
            }
        }

        class SubAccessData {
            final INodeDirectory dir;
            final String resourcePath;
            final INode[] inodes;
            final INodeAttributes[] iNodeAttributes;

            SubAccessData(INodeDirectory dir, String resourcePath, INode[] inodes, INodeAttributes[] iNodeAttributes) {
                this.dir = dir;
                this.resourcePath = resourcePath;
                this.iNodeAttributes = iNodeAttributes;
                this.inodes = inodes;
            }
        }
    }

    private static enum AuthzStatus {
        ALLOW,
        DENY,
        NOT_DETERMINED;

    }
}

