/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerAuthzResult {
    private String requestId;
    private AccessDecision decision;
    private Map<String, PermissionResult> permissions;

    public RangerAuthzResult() {
    }

    public RangerAuthzResult(String requestId) {
        this(requestId, null);
    }

    public RangerAuthzResult(String requestId, Map<String, PermissionResult> permissions) {
        this.requestId = requestId;
        this.permissions = permissions;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public AccessDecision getDecision() {
        return this.decision;
    }

    public void setDecision(AccessDecision decision) {
        this.decision = decision;
    }

    public Map<String, PermissionResult> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, PermissionResult> permissions) {
        this.permissions = permissions;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.decision, this.permissions});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerAuthzResult that = (RangerAuthzResult)o;
        return Objects.equals(this.requestId, that.requestId) && Objects.equals((Object)this.decision, (Object)that.decision) && Objects.equals(this.permissions, that.permissions);
    }

    public String toString() {
        return "RangerAuthzResult{requestId='" + this.requestId + '\'' + ", decision=" + (Object)((Object)this.decision) + ", permissions=" + this.permissions + '}';
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PolicyInfo {
        private Long id;
        private Long version;

        public PolicyInfo() {
        }

        public PolicyInfo(Long id, Long version) {
            this.id = id;
            this.version = version;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PolicyInfo that = (PolicyInfo)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public String toString() {
            return "PolicyInfo{id='" + this.id + '\'' + ", version=" + this.version + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RowFilterResult {
        private String filterExpr;
        private PolicyInfo policy;

        public RowFilterResult() {
        }

        public RowFilterResult(String filterExpr, PolicyInfo policy) {
            this.filterExpr = filterExpr;
            this.policy = policy;
        }

        public String getFilterExpr() {
            return this.filterExpr;
        }

        public void setFilterExpr(String filterExpr) {
            this.filterExpr = filterExpr;
        }

        public PolicyInfo getPolicy() {
            return this.policy;
        }

        public void setPolicy(PolicyInfo policy) {
            this.policy = policy;
        }

        public int hashCode() {
            return Objects.hash(this.filterExpr, this.policy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowFilterResult that = (RowFilterResult)o;
            return Objects.equals(this.filterExpr, that.filterExpr) && Objects.equals(this.policy, that.policy);
        }

        public String toString() {
            return "RowFilterResult{filterExpr='" + this.filterExpr + '\'' + ", policy=" + this.policy + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataMaskResult {
        private String maskType;
        private String maskedValue;
        private PolicyInfo policy;

        public DataMaskResult() {
        }

        public DataMaskResult(String maskType, String maskedValue, PolicyInfo policy) {
            this.maskType = maskType;
            this.maskedValue = maskedValue;
            this.policy = policy;
        }

        public String getMaskType() {
            return this.maskType;
        }

        public void setMaskType(String maskType) {
            this.maskType = maskType;
        }

        public String getMaskedValue() {
            return this.maskedValue;
        }

        public void setMaskedValue(String maskedValue) {
            this.maskedValue = maskedValue;
        }

        public PolicyInfo getPolicy() {
            return this.policy;
        }

        public void setPolicy(PolicyInfo policy) {
            this.policy = policy;
        }

        public int hashCode() {
            return Objects.hash(this.maskType, this.maskedValue, this.policy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataMaskResult that = (DataMaskResult)o;
            return Objects.equals(this.maskType, that.maskType) && Objects.equals(this.maskedValue, that.maskedValue) && Objects.equals(this.policy, that.policy);
        }

        public String toString() {
            return "DataMaskResult{maskType='" + this.maskType + '\'' + ", maskedValue='" + this.maskedValue + '\'' + ", policy='" + this.policy + '\'' + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AccessResult {
        AccessDecision decision;
        PolicyInfo policy;

        public AccessResult() {
        }

        public AccessResult(AccessDecision decision, PolicyInfo policy) {
            this.decision = decision;
            this.policy = policy;
        }

        public AccessDecision getDecision() {
            return this.decision;
        }

        public void setDecision(AccessDecision decision) {
            this.decision = decision;
        }

        public PolicyInfo getPolicy() {
            return this.policy;
        }

        public void setPolicy(PolicyInfo policy) {
            this.policy = policy;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.decision, this.policy});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessResult that = (AccessResult)o;
            return Objects.equals((Object)this.decision, (Object)that.decision) && Objects.equals(this.policy, that.policy);
        }

        public String toString() {
            return "AccessResult{decision=" + (Object)((Object)this.decision) + ", policy=" + this.policy + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResultInfo {
        private AccessResult access;
        private DataMaskResult dataMask;
        private RowFilterResult rowFilter;
        private Map<String, Object> additionalInfo;

        public ResultInfo() {
        }

        public ResultInfo(AccessResult access, DataMaskResult dataMask, RowFilterResult rowFilter, Map<String, Object> additionalInfo) {
            this.access = access;
            this.dataMask = dataMask;
            this.rowFilter = rowFilter;
            this.additionalInfo = additionalInfo;
        }

        public AccessResult getAccess() {
            return this.access;
        }

        public void setAccess(AccessResult access) {
            this.access = access;
        }

        public DataMaskResult getDataMask() {
            return this.dataMask;
        }

        public void setDataMask(DataMaskResult dataMask) {
            this.dataMask = dataMask;
        }

        public RowFilterResult getRowFilter() {
            return this.rowFilter;
        }

        public void setRowFilter(RowFilterResult rowFilter) {
            this.rowFilter = rowFilter;
        }

        public Map<String, Object> getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setAdditionalInfo(Map<String, Object> additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public int hashCode() {
            return Objects.hash(this.access, this.dataMask, this.rowFilter, this.additionalInfo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResultInfo that = (ResultInfo)o;
            return Objects.equals(this.access, that.access) && Objects.equals(this.dataMask, that.dataMask) && Objects.equals(this.rowFilter, that.rowFilter) && Objects.equals(this.additionalInfo, that.additionalInfo);
        }

        public String toString() {
            return "ResultInfo{access=" + this.access + ", dataMask=" + this.dataMask + ", rowFilter=" + this.rowFilter + ", additionalInfo=" + this.additionalInfo + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermissionResult {
        private String permission;
        private AccessResult access;
        private DataMaskResult dataMask;
        private RowFilterResult rowFilter;
        private Map<String, Object> additionalInfo;
        private Map<String, ResultInfo> subResources;

        public PermissionResult() {
        }

        public PermissionResult(String permission) {
            this(permission, null, null);
        }

        public PermissionResult(String permission, ResultInfo result) {
            this(permission, result, null);
        }

        public PermissionResult(String permission, ResultInfo result, Map<String, ResultInfo> subResources) {
            this.permission = permission;
            this.subResources = subResources;
            if (result != null) {
                this.access = result.getAccess();
                this.dataMask = result.getDataMask();
                this.rowFilter = result.getRowFilter();
                this.additionalInfo = result.getAdditionalInfo();
            }
        }

        public String getPermission() {
            return this.permission;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public AccessResult getAccess() {
            return this.access;
        }

        public void setAccess(AccessResult access) {
            this.access = access;
        }

        public DataMaskResult getDataMask() {
            return this.dataMask;
        }

        public void setDataMask(DataMaskResult dataMask) {
            this.dataMask = dataMask;
        }

        public RowFilterResult getRowFilter() {
            return this.rowFilter;
        }

        public void setRowFilter(RowFilterResult rowFilter) {
            this.rowFilter = rowFilter;
        }

        public Map<String, Object> getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setAdditionalInfo(Map<String, Object> additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public Map<String, ResultInfo> getSubResources() {
            return this.subResources;
        }

        public void setSubResources(Map<String, ResultInfo> subResources) {
            this.subResources = subResources;
        }

        public ResultInfo getSubResourceResult(String resourceName) {
            Map<String, ResultInfo> subResources = this.getSubResources();
            return subResources != null ? subResources.get(resourceName) : null;
        }

        public void addSubResourceResult(String resourceName, ResultInfo result) {
            if (this.subResources == null) {
                this.subResources = new HashMap<String, ResultInfo>();
            }
            this.subResources.put(resourceName, result);
        }

        public int hashCode() {
            return Objects.hash(this.permission, this.access, this.dataMask, this.rowFilter, this.additionalInfo, this.subResources);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PermissionResult that = (PermissionResult)o;
            return Objects.equals(this.permission, that.permission) && Objects.equals(this.access, that.access) && Objects.equals(this.dataMask, that.dataMask) && Objects.equals(this.rowFilter, that.rowFilter) && Objects.equals(this.additionalInfo, that.additionalInfo) && Objects.equals(this.subResources, that.subResources);
        }

        public String toString() {
            return "PermissionResult{permission='" + this.permission + '\'' + ", access=" + this.access + ", dataMask=" + this.dataMask + ", rowFilter=" + this.rowFilter + ", additionalInfo=" + this.additionalInfo + ", subResources=" + this.subResources + '}';
        }
    }

    public static enum AccessDecision {
        ALLOW,
        DENY,
        NOT_DETERMINED,
        PARTIAL;

    }
}

