/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerIpMatcher
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerIpMatcher.class);
    private List<String> _exactIps = new ArrayList<String>();
    private List<String> _wildCardIps = new ArrayList<String>();
    private boolean _allowAny;
    static final Pattern allWildcards = Pattern.compile("^((\\*(\\.\\*)*)|(\\*(:\\*)*))$");
    static final Pattern trailingWildcardsIp4 = Pattern.compile("(\\.\\*)+$");
    static final Pattern trailingWildcardsIp6 = Pattern.compile("(:\\*)+$");

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.init(" + this.condition + ")");
        }
        super.init();
        if (this.condition == null) {
            LOG.debug("init: null policy condition! Will match always!");
            this._allowAny = true;
        } else if (CollectionUtils.isEmpty(this.condition.getValues())) {
            LOG.debug("init: empty conditions collection on policy condition!  Will match always!");
            this._allowAny = true;
        } else if (this.condition.getValues().contains("*")) {
            this._allowAny = true;
            LOG.debug("init: wildcard value found.  Will match always.");
        } else {
            for (String ip : this.condition.getValues()) {
                String digestedIp = this.digestPolicyIp(ip);
                if (digestedIp.isEmpty()) {
                    LOG.debug("init: digested ip was empty! Will match always");
                    this._allowAny = true;
                    continue;
                }
                if (digestedIp.equals(ip)) {
                    this._exactIps.add(ip);
                    continue;
                }
                this._wildCardIps.add(digestedIp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.init(" + this.condition + "): exact-ips[" + this._exactIps + "], wildcard-ips[" + this._wildCardIps + "]");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.isMatched(" + request + ")");
        }
        boolean ipMatched = true;
        if (this._allowAny) {
            LOG.debug("isMatched: allowAny flag is true.  Matched!");
        } else {
            String requestIp = this.extractIp(request);
            if (requestIp == null) {
                LOG.debug("isMatched: couldn't get ip address from request.  Ok.  Implicitly matched!");
            } else {
                boolean bl = ipMatched = this.isWildcardMatched(this._wildCardIps, requestIp) || this.isExactlyMatched(this._exactIps, requestIp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.isMatched(" + request + "): " + ipMatched);
        }
        return ipMatched;
    }

    String digestPolicyIp(String policyIp) {
        String result;
        Matcher matcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.digestPolicyIp(" + policyIp + ")");
        }
        if ((matcher = allWildcards.matcher(policyIp)).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("digestPolicyIp: policyIP[" + policyIp + "] all wildcards.");
            }
            result = "";
        } else if (policyIp.contains(".")) {
            matcher = trailingWildcardsIp4.matcher(policyIp);
            result = matcher.replaceFirst(".");
        } else {
            matcher = trailingWildcardsIp6.matcher(policyIp);
            result = matcher.replaceFirst(":").toLowerCase();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.digestPolicyIp(" + policyIp + "): " + policyIp);
        }
        return result;
    }

    boolean isWildcardMatched(List<String> ips, String requestIp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.isWildcardMatched(" + ips + ", " + requestIp + ")");
        }
        boolean matchFound = false;
        Iterator<String> iterator = ips.iterator();
        while (iterator.hasNext() && !matchFound) {
            String ip = iterator.next();
            if (requestIp.contains(".") && requestIp.startsWith(ip)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wildcard Policy IP[" + ip + "] matches request IPv4[" + requestIp + "].");
                }
                matchFound = true;
                continue;
            }
            if (requestIp.toLowerCase().startsWith(ip)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wildcard Policy IP[" + ip + "] matches request IPv6[" + requestIp + "].");
                }
                matchFound = true;
                continue;
            }
            LOG.debug("Wildcard policy IP[" + ip + "] did not match request IP[" + requestIp + "].");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.isWildcardMatched(" + ips + ", " + requestIp + "): " + matchFound);
        }
        return matchFound;
    }

    boolean isExactlyMatched(List<String> ips, String requestIp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.isExactlyMatched(" + ips + ", " + requestIp + ")");
        }
        boolean matchFound = false;
        matchFound = requestIp.contains(".") ? ips.contains(requestIp) : ips.contains(requestIp.toLowerCase());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.isExactlyMatched(" + ips + ", " + requestIp + "): " + matchFound);
        }
        return matchFound;
    }

    String extractIp(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerIpMatcher.extractIp(" + request + ")");
        }
        String ip = null;
        if (request == null) {
            LOG.debug("isMatched: Unexpected: null request object!");
        } else {
            ip = request.getClientIPAddress();
            if (ip == null) {
                LOG.debug("isMatched: Unexpected: Client ip in request object is null!");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerIpMatcher.extractIp(" + request + "): " + ip);
        }
        return ip;
    }
}

