/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kafka.client;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.services.kafka.client.ServiceKafkaClient;

public class ServiceKafkaConnectionMgr {
    private static final String SEPARATOR = ",";
    private static final String KEY_SASL_MECHANISM = "sasl.mechanism";
    private static final String KEY_KAFKA_KEYTAB = "kafka.keytab";
    private static final String KEY_KAFKA_PRINCIPAL = "kafka.principal";

    public static ServiceKafkaClient getKafkaClient(String serviceName, Map<String, String> configs) throws Exception {
        String error = ServiceKafkaConnectionMgr.getServiceConfigValidationErrors(configs);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            error = "JAAS configuration missing or not correct in Ranger Kafka Service..." + error;
            throw new Exception(error);
        }
        ServiceKafkaClient serviceKafkaClient = new ServiceKafkaClient(serviceName, configs);
        return serviceKafkaClient;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        ServiceKafkaClient serviceKafkaClient = ServiceKafkaConnectionMgr.getKafkaClient(serviceName, configs);
        return serviceKafkaClient.connectionTest();
    }

    private static String getServiceConfigValidationErrors(Map<String, String> configs) {
        StringBuilder ret = new StringBuilder();
        String bootstrap_servers = configs.get("bootstrap.servers");
        String security_protocol = configs.get("security.protocol");
        String sasl_mechanism = configs.get(KEY_SASL_MECHANISM);
        String kafka_keytab = configs.get(KEY_KAFKA_KEYTAB);
        String kafka_principal = configs.get(KEY_KAFKA_PRINCIPAL);
        if (StringUtils.isEmpty((CharSequence)bootstrap_servers)) {
            ret.append("bootstrap.servers");
        }
        if (StringUtils.isEmpty((CharSequence)security_protocol)) {
            if (StringUtils.isNotBlank((CharSequence)ret.toString())) {
                ret.append(SEPARATOR).append("security.protocol");
            } else {
                ret.append("security.protocol");
            }
        }
        if (StringUtils.isEmpty((CharSequence)sasl_mechanism)) {
            if (StringUtils.isNotBlank((CharSequence)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_SASL_MECHANISM);
            } else {
                ret.append(KEY_SASL_MECHANISM);
            }
        }
        if (StringUtils.isEmpty((CharSequence)kafka_keytab)) {
            if (StringUtils.isNotBlank((CharSequence)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_KAFKA_KEYTAB);
            } else {
                ret.append(KEY_KAFKA_KEYTAB);
            }
        }
        if (StringUtils.isEmpty((CharSequence)kafka_principal)) {
            if (StringUtils.isNotBlank((CharSequence)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_KAFKA_PRINCIPAL);
            } else {
                ret.append(KEY_KAFKA_PRINCIPAL);
            }
        }
        return ret.toString();
    }
}

