/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kylin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.apache.ranger.services.kylin.client.json.model.KylinProjectResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(KylinClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String KYLIN_LIST_API_ENDPOINT = "/kylin/api/projects";
    private static final String ERROR_MESSAGE = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private String kylinUrl;
    private String userName;
    private String password;

    public KylinClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "kylin-client");
        this.kylinUrl = configs.get("kylin.url");
        this.userName = configs.get("username");
        this.password = configs.get("password");
        if (StringUtils.isEmpty((CharSequence)this.kylinUrl)) {
            LOG.error("No value found for configuration 'kylin.url'. Kylin resource lookup will fail.");
        }
        if (StringUtils.isEmpty((CharSequence)this.userName)) {
            LOG.error("No value found for configuration 'username'. Kylin resource lookup will fail.");
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            LOG.error("No value found for configuration 'password'. Kylin resource lookup will fail.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kylin client is build with url [" + this.kylinUrl + "], user: [" + this.userName + "], password: [*********].");
        }
    }

    public List<String> getProjectList(final String projectMatching, final List<String> existingProjects) {
        Subject subj;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting kylin project list for projectMatching: " + projectMatching + ", existingProjects: " + existingProjects);
        }
        if ((subj = this.getLoginSubject()) == null) {
            return Collections.emptyList();
        }
        List<String> ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                ClientResponse response = KylinClient.getClientResponse(KylinClient.this.kylinUrl, KylinClient.this.userName, KylinClient.this.password);
                List projectResponses = KylinClient.this.getKylinProjectResponse(response);
                if (CollectionUtils.isEmpty((Collection)projectResponses)) {
                    return Collections.emptyList();
                }
                List projects = KylinClient.getProjectFromResponse(projectMatching, existingProjects, projectResponses);
                return projects;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting kylin project list result: " + ret);
        }
        return ret;
    }

    private static ClientResponse getClientResponse(String kylinUrl, String userName, String password) {
        ClientResponse response = null;
        Object[] kylinUrls = kylinUrl.trim().split("[,;]");
        if (ArrayUtils.isEmpty((Object[])kylinUrls)) {
            return null;
        }
        Client client = Client.create();
        String decryptedPwd = PasswordUtils.getDecryptPassword((String)password);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, decryptedPwd));
        for (Object currentUrl : kylinUrls) {
            if (StringUtils.isBlank((CharSequence)currentUrl)) continue;
            String url = ((String)currentUrl).trim() + KYLIN_LIST_API_ENDPOINT;
            try {
                response = KylinClient.getProjectResponse(url, client);
                if (response == null) continue;
                if (response.getStatus() == 200) break;
                response.close();
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting kylin response, kylinUrl: " + url;
                LOG.error(msgDesc, t);
            }
        }
        client.destroy();
        return response;
    }

    private List<KylinProjectResponse> getKylinProjectResponse(ClientResponse response) {
        List projectResponses;
        block9: {
            projectResponses = null;
            try {
                if (response != null) {
                    if (response.getStatus() == 200) {
                        String jsonString = (String)response.getEntity(String.class);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        projectResponses = (List)gson.fromJson(jsonString, new TypeToken<List<KylinProjectResponse>>(){}.getType());
                        break block9;
                    }
                    String msgDesc = "Unable to get a valid response for expected mime type : [application/json], kylinUrl: " + this.kylinUrl + " - got http response code " + response.getStatus();
                    LOG.error(msgDesc);
                    HadoopException hdpException = new HadoopException(msgDesc);
                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                    throw hdpException;
                }
                String msgDesc = "Unable to get a valid response for expected mime type : [application/json], kylinUrl: " + this.kylinUrl + " - got null response.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            catch (HadoopException he) {
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting kylin project response, kylinUrl: " + this.kylinUrl;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return projectResponses;
    }

    private static ClientResponse getProjectResponse(String url, Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getProjectResponse():calling " + url);
        }
        WebResource webResource = client.resource(url);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
        if (response != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getProjectResponse():response.getStatus()= " + response.getStatus());
            }
            if (response.getStatus() != 200) {
                LOG.warn("getProjectResponse():response.getStatus()= " + response.getStatus() + " for URL " + url + ", failed to get kylin project list.");
                String jsonString = (String)response.getEntity(String.class);
                LOG.warn(jsonString);
            }
        }
        return response;
    }

    private static List<String> getProjectFromResponse(String projectMatching, List<String> existingProjects, List<KylinProjectResponse> projectResponses) {
        ArrayList<String> projcetNames = new ArrayList<String>();
        for (KylinProjectResponse project : projectResponses) {
            String projectName = project.getName();
            if (CollectionUtils.isNotEmpty(existingProjects) && existingProjects.contains(projectName) || !StringUtils.isEmpty((CharSequence)projectMatching) && !projectMatching.startsWith("*") && !projectName.toLowerCase().startsWith(projectMatching.toLowerCase())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getProjectFromResponse(): Adding kylin project " + projectName);
            }
            projcetNames.add(projectName);
        }
        return projcetNames;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        KylinClient kylinClient = KylinClient.getKylinClient(serviceName, configs);
        List<String> strList = kylinClient.getProjectList(null, null);
        boolean connectivityStatus = false;
        if (CollectionUtils.isNotEmpty(strList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionTest list size" + strList.size() + " kylin projects");
            }
            connectivityStatus = true;
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any kylin projects using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + ERROR_MESSAGE), null, null, responseData);
        }
        return responseData;
    }

    public static KylinClient getKylinClient(String serviceName, Map<String, String> configs) {
        KylinClient kylinClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting KylinClient for datasource: " + serviceName);
        }
        if (MapUtils.isEmpty(configs)) {
            String msgDesc = "Could not connect kylin as connection configMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
            throw hdpException;
        }
        kylinClient = new KylinClient(serviceName, configs);
        return kylinClient;
    }
}

