/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.api;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authz.api.RangerAuthzApiErrorCode;
import org.apache.ranger.authz.api.RangerAuthzErrorCode;
import org.apache.ranger.authz.api.RangerAuthzException;
import org.apache.ranger.authz.model.RangerAccessContext;
import org.apache.ranger.authz.model.RangerAccessInfo;
import org.apache.ranger.authz.model.RangerAuthzRequest;
import org.apache.ranger.authz.model.RangerAuthzResult;
import org.apache.ranger.authz.model.RangerMultiAuthzRequest;
import org.apache.ranger.authz.model.RangerMultiAuthzResult;
import org.apache.ranger.authz.model.RangerResourceInfo;
import org.apache.ranger.authz.model.RangerResourcePermissions;
import org.apache.ranger.authz.model.RangerUserInfo;

public abstract class RangerAuthorizer {
    protected final Properties properties;

    protected RangerAuthorizer(Properties properties) {
        this.properties = properties;
    }

    public abstract void init() throws RangerAuthzException;

    public abstract void close() throws RangerAuthzException;

    public abstract RangerAuthzResult authorize(RangerAuthzRequest var1) throws RangerAuthzException;

    public abstract RangerMultiAuthzResult authorize(RangerMultiAuthzRequest var1) throws RangerAuthzException;

    public abstract RangerResourcePermissions getResourcePermissions(RangerResourceInfo var1, RangerAccessContext var2) throws RangerAuthzException;

    protected void validateRequest(RangerAuthzRequest request) throws RangerAuthzException {
        this.validateUserInfo(request.getUser());
        this.validateAccessInfo(request.getAccess());
        this.validateAccessContext(request.getContext());
    }

    protected void validateRequest(RangerMultiAuthzRequest request) throws RangerAuthzException {
        this.validateUserInfo(request.getUser());
        if (request.getAccesses() == null || request.getAccesses().isEmpty()) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_ACCESS_INFO_MISSING);
        }
        for (RangerAccessInfo access : request.getAccesses()) {
            this.validateAccessInfo(access);
        }
        this.validateAccessContext(request.getContext());
    }

    protected void validateUserInfo(RangerUserInfo user) throws RangerAuthzException {
        if (user == null || StringUtils.isBlank((CharSequence)user.getName())) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_USER_INFO_MISSING);
        }
    }

    protected void validateAccessInfo(RangerAccessInfo access) throws RangerAuthzException {
        if (access == null) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_ACCESS_INFO_MISSING);
        }
        this.validateResourceInfo(access.getResource());
        if (access.getPermissions() == null || access.getPermissions().isEmpty()) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_PERMISSIONS_EMPTY);
        }
    }

    protected void validateResourceInfo(RangerResourceInfo resource) throws RangerAuthzException {
        if (resource == null) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_RESOURCE_INFO_MISSING);
        }
        if (resource.getName() == null || resource.getName().isEmpty()) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_RESOURCE_NAME_MISSING);
        }
        if (resource.getSubResources() != null && !resource.getSubResources().isEmpty() && resource.getNameMatchScope() != null && !RangerResourceInfo.ResourceMatchScope.SELF.equals((Object)resource.getNameMatchScope())) {
            throw new RangerAuthzException((RangerAuthzErrorCode)RangerAuthzApiErrorCode.INVALID_REQUEST_NAME_MATCH_SCOPE_INVALID, new Object[]{resource.getNameMatchScope()});
        }
    }

    protected void validateAccessContext(RangerAccessContext context) throws RangerAuthzException {
        if (context == null) {
            throw new RangerAuthzException(RangerAuthzApiErrorCode.INVALID_REQUEST_ACCESS_CONTEXT_MISSING);
        }
        if (context.getAccessTime() <= 0L) {
            context.setAccessTime(System.currentTimeMillis());
        }
        if (context.getAdditionalInfo() == null) {
            context.setAdditionalInfo(new HashMap<String, Object>());
        }
    }
}

