/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class TagPredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        super.addPredicates(filter, predicates);
        this.addPredicateForTagDefId(filter.getParam("tagDefId"), predicates);
        this.addPredicateForTagDefGuid(filter.getParam("tagDefGuid"), predicates);
        this.addPredicateForTagId(filter.getParam("tagId"), predicates);
        this.addPredicateForTagGuid(filter.getParam("tagGuid"), predicates);
        this.addPredicateForTagType(filter.getParam("tagType"), predicates);
        this.addPredicateForResourceId(filter.getParam("resourceId"), predicates);
        this.addPredicateForResourceGuid(filter.getParam("resourceGuid"), predicates);
        this.addPredicateForServiceResourceServiceName(filter.getParam("resourceServiceName"), predicates);
        this.addPredicateForResourceSignature(filter.getParam("resourceSignature"), predicates);
        this.addPredicateForTagResourceMapId(filter.getParam("tagResourceMapId"), predicates);
    }

    private Predicate addPredicateForTagDefId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)tagDef.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagDefGuid(final String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals((CharSequence)guid, (CharSequence)tagDef.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)tag.getId().toString());
                } else if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)tagResourceMap.getTagId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagGuid(final String guid, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)guid)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals((CharSequence)guid, (CharSequence)tag.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagType(final String type, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagDef) {
                    RangerTagDef tagDef = (RangerTagDef)object;
                    ret = StringUtils.equals((CharSequence)type, (CharSequence)tagDef.getName());
                } else if (object instanceof RangerTag) {
                    RangerTag tag = (RangerTag)object;
                    ret = StringUtils.equals((CharSequence)type, (CharSequence)tag.getType());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)resource.getId().toString());
                } else if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)tagResourceMap.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceGuid(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)resource.getGuid());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceResourceServiceName(final String serviceName, List<Predicate> predicates) {
        if (serviceName == null || StringUtils.isEmpty((CharSequence)serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals((CharSequence)resource.getServiceName(), (CharSequence)serviceName);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(final String signature, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)signature)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerServiceResource) {
                    RangerServiceResource resource = (RangerServiceResource)object;
                    ret = StringUtils.equals((CharSequence)signature, (CharSequence)resource.getResourceSignature());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagResourceMapId(final String id, List<Predicate> predicates) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret = false;
                if (object == null) {
                    return ret;
                }
                if (object instanceof RangerTagResourceMap) {
                    RangerTagResourceMap tagResourceMap = (RangerTagResourceMap)object;
                    ret = StringUtils.equals((CharSequence)id, (CharSequence)tagResourceMap.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

