/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasHbaseResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_HBASE_NAMESPACE = "hbase_namespace";
    public static final String ENTITY_TYPE_HBASE_TABLE = "hbase_table";
    public static final String ENTITY_TYPE_HBASE_COLUMN_FAMILY = "hbase_column_family";
    public static final String ENTITY_TYPE_HBASE_COLUMN = "hbase_column";
    public static final String RANGER_TYPE_HBASE_TABLE = "table";
    public static final String RANGER_TYPE_HBASE_COLUMN_FAMILY = "column-family";
    public static final String RANGER_TYPE_HBASE_COLUMN = "column";
    public static final String RANGER_NAMESPACE_TABLE_DELIMITER = ":";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"hbase_table", "hbase_column_family", "hbase_column"};

    public AtlasHbaseResourceMapper() {
        super("hbase", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String clusterName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            throw new Exception("attribute 'qualifiedName' not found in entity");
        }
        String resourceStr = this.getResourceNameFromQualifiedName(qualifiedName);
        if (StringUtils.isEmpty((CharSequence)resourceStr)) {
            this.throwExceptionWithMessage("resource not found in attribute 'qualifiedName': " + qualifiedName);
        }
        if (StringUtils.isEmpty((CharSequence)(clusterName = this.getClusterNameFromQualifiedName(qualifiedName)))) {
            this.throwExceptionWithMessage("cluster-name not found in attribute 'qualifiedName': " + qualifiedName);
        }
        String entityType = entity.getTypeName();
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (StringUtils.equals((CharSequence)entityType, (CharSequence)ENTITY_TYPE_HBASE_NAMESPACE)) {
            String namespaceName;
            if (StringUtils.isNotEmpty((CharSequence)resourceStr) && StringUtils.isNotEmpty((CharSequence)(namespaceName = StringUtils.strip((String)resourceStr)))) {
                elements.put(RANGER_TYPE_HBASE_TABLE, new RangerPolicy.RangerPolicyResource(namespaceName + RANGER_NAMESPACE_TABLE_DELIMITER + "*"));
            }
        } else if (StringUtils.equals((CharSequence)entityType, (CharSequence)ENTITY_TYPE_HBASE_TABLE)) {
            if (StringUtils.isNotEmpty((CharSequence)resourceStr)) {
                elements.put(RANGER_TYPE_HBASE_TABLE, new RangerPolicy.RangerPolicyResource(resourceStr));
            }
        } else if (StringUtils.equals((CharSequence)entityType, (CharSequence)ENTITY_TYPE_HBASE_COLUMN_FAMILY)) {
            String[] resources = resourceStr.split("\\.");
            String tblName = null;
            String familyName = null;
            if (resources.length == 2) {
                tblName = resources[0];
                familyName = resources[1];
            } else if (resources.length > 2) {
                StringBuilder tblNameBuf = new StringBuilder(resources[0]);
                for (int i = 1; i < resources.length - 1; ++i) {
                    tblNameBuf.append(QUALIFIED_NAME_DELIMITER_CHAR).append(resources[i]);
                }
                tblName = tblNameBuf.toString();
                familyName = resources[resources.length - 1];
            }
            if (StringUtils.isNotEmpty((CharSequence)tblName) && StringUtils.isNotEmpty((CharSequence)familyName)) {
                elements.put(RANGER_TYPE_HBASE_TABLE, new RangerPolicy.RangerPolicyResource(tblName));
                elements.put(RANGER_TYPE_HBASE_COLUMN_FAMILY, new RangerPolicy.RangerPolicyResource(familyName));
            }
        } else if (StringUtils.equals((CharSequence)entityType, (CharSequence)ENTITY_TYPE_HBASE_COLUMN)) {
            String[] resources = resourceStr.split("\\.");
            String tblName = null;
            String familyName = null;
            String colName = null;
            if (resources.length == 3) {
                tblName = resources[0];
                familyName = resources[1];
                colName = resources[2];
            } else if (resources.length > 3) {
                StringBuilder tblNameBuf = new StringBuilder(resources[0]);
                for (int i = 1; i < resources.length - 2; ++i) {
                    tblNameBuf.append(QUALIFIED_NAME_DELIMITER_CHAR).append(resources[i]);
                }
                tblName = tblNameBuf.toString();
                familyName = resources[resources.length - 2];
                colName = resources[resources.length - 1];
            }
            if (StringUtils.isNotEmpty((CharSequence)tblName) && StringUtils.isNotEmpty((CharSequence)familyName) && StringUtils.isNotEmpty((CharSequence)colName)) {
                elements.put(RANGER_TYPE_HBASE_TABLE, new RangerPolicy.RangerPolicyResource(tblName));
                elements.put(RANGER_TYPE_HBASE_COLUMN_FAMILY, new RangerPolicy.RangerPolicyResource(familyName));
                elements.put(RANGER_TYPE_HBASE_COLUMN, new RangerPolicy.RangerPolicyResource(colName));
            }
        } else {
            this.throwExceptionWithMessage("unrecognized entity-type: " + entityType);
        }
        if (elements.isEmpty()) {
            this.throwExceptionWithMessage("invalid qualifiedName for entity-type '" + entityType + "': " + qualifiedName);
        }
        return new RangerServiceResource(entityGuid, serviceName, elements);
    }
}

