/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;

public class AtlasKafkaResourceMapper
extends AtlasResourceMapper {
    public static final String ENTITY_TYPE_KAFKA_TOPIC = "kafka_topic";
    public static final String RANGER_TYPE_KAFKA_TOPIC = "topic";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"kafka_topic"};

    public AtlasKafkaResourceMapper() {
        super("kafka", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String clusterName;
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        String topic = this.getResourceNameFromQualifiedName(qualifiedName);
        if (StringUtils.isEmpty((CharSequence)topic)) {
            this.throwExceptionWithMessage("topic not found in attribute 'qualifiedName'");
        }
        if (StringUtils.isEmpty((CharSequence)(clusterName = this.getClusterNameFromQualifiedName(qualifiedName)))) {
            clusterName = this.defaultClusterName;
        }
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            this.throwExceptionWithMessage("attribute 'qualifiedName' not found in entity");
        }
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        Boolean isExcludes = Boolean.FALSE;
        Boolean isRecursive = Boolean.TRUE;
        elements.put(RANGER_TYPE_KAFKA_TOPIC, new RangerPolicy.RangerPolicyResource(topic, isExcludes, isRecursive));
        String entityGuid = entity.getGuid();
        String serviceName = this.getRangerServiceName(clusterName);
        return new RangerServiceResource(entityGuid, serviceName, elements);
    }
}

