/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlasResourceMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasResourceMapper.class);
    public static final String TAGSYNC_DEFAULT_CLUSTER_NAME = "ranger.tagsync.atlas.default.cluster.name";
    public static final String ENTITY_ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    public static final String QUALIFIED_NAME_DELIMITER = "\\.";
    public static final Character QUALIFIED_NAME_DELIMITER_CHAR = Character.valueOf('.');
    public static final String TAGSYNC_SERVICENAME_MAPPER_PROP_PREFIX = "ranger.tagsync.atlas.";
    public static final String TAGSYNC_SERVICENAME_MAPPER_PROP_SUFFIX = ".ranger.service";
    public static final String TAGSYNC_ATLAS_CLUSTER_IDENTIFIER = ".instance.";
    public static final String TAGSYNC_DEFAULT_CLUSTERNAME_AND_COMPONENTNAME_SEPARATOR = "_";
    public static final String CLUSTER_DELIMITER = "@";
    protected final String componentName;
    protected final String[] supportedEntityTypes;
    protected Properties properties;
    protected String defaultClusterName;

    public AtlasResourceMapper(String componentName, String[] supportedEntityTypes) {
        this.componentName = componentName;
        this.supportedEntityTypes = supportedEntityTypes;
    }

    public final String getComponentName() {
        return this.componentName;
    }

    public final String[] getSupportedEntityTypes() {
        return this.supportedEntityTypes;
    }

    public String getRangerServiceName(String clusterName) {
        String ret = this.getCustomRangerServiceName(clusterName);
        if (StringUtils.isBlank((CharSequence)ret)) {
            ret = clusterName + TAGSYNC_DEFAULT_CLUSTERNAME_AND_COMPONENTNAME_SEPARATOR + this.componentName;
        }
        return ret;
    }

    public void initialize(Properties properties) {
        this.properties = properties;
        this.defaultClusterName = properties != null ? properties.getProperty(TAGSYNC_DEFAULT_CLUSTER_NAME) : null;
    }

    public abstract RangerServiceResource buildResource(RangerAtlasEntity var1) throws Exception;

    protected String getCustomRangerServiceName(String atlasInstanceName) {
        if (this.properties != null) {
            String propName = TAGSYNC_SERVICENAME_MAPPER_PROP_PREFIX + this.componentName + TAGSYNC_ATLAS_CLUSTER_IDENTIFIER + atlasInstanceName + TAGSYNC_SERVICENAME_MAPPER_PROP_SUFFIX;
            return this.properties.getProperty(propName);
        }
        return null;
    }

    protected String getResourceNameFromQualifiedName(String qualifiedName) {
        if (StringUtils.isNotBlank((CharSequence)qualifiedName)) {
            int idx = qualifiedName.lastIndexOf(CLUSTER_DELIMITER);
            if (idx != -1) {
                return qualifiedName.substring(0, idx);
            }
            return qualifiedName;
        }
        return null;
    }

    protected String getClusterNameFromQualifiedName(String qualifiedName) {
        int idx;
        if (StringUtils.isNotBlank((CharSequence)qualifiedName) && (idx = qualifiedName.lastIndexOf(CLUSTER_DELIMITER)) != -1 && qualifiedName.length() > idx) {
            return qualifiedName.substring(idx + 1);
        }
        return null;
    }

    protected void throwExceptionWithMessage(String msg) throws Exception {
        LOG.error(msg);
        throw new Exception(msg);
    }
}

