/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ranger.authz.model.RangerAuthzResult;
import org.apache.ranger.authz.model.RangerResourceInfo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerResourcePermissions {
    private RangerResourceInfo resource;
    private Map<String, Map<String, RangerAuthzResult.PermissionResult>> users;
    private Map<String, Map<String, RangerAuthzResult.PermissionResult>> groups;
    private Map<String, Map<String, RangerAuthzResult.PermissionResult>> roles;

    public RangerResourcePermissions() {
    }

    public RangerResourcePermissions(RangerResourceInfo resource, Map<String, Map<String, RangerAuthzResult.PermissionResult>> users, Map<String, Map<String, RangerAuthzResult.PermissionResult>> groups, Map<String, Map<String, RangerAuthzResult.PermissionResult>> roles) {
        this.resource = resource;
        this.users = users;
        this.groups = groups;
        this.roles = roles;
    }

    public RangerResourceInfo getResource() {
        return this.resource;
    }

    public void setResource(RangerResourceInfo resource) {
        this.resource = resource;
    }

    public Map<String, Map<String, RangerAuthzResult.PermissionResult>> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, Map<String, RangerAuthzResult.PermissionResult>> users) {
        this.users = users;
    }

    public Map<String, Map<String, RangerAuthzResult.PermissionResult>> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, Map<String, RangerAuthzResult.PermissionResult>> groups) {
        this.groups = groups;
    }

    public Map<String, Map<String, RangerAuthzResult.PermissionResult>> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, Map<String, RangerAuthzResult.PermissionResult>> roles) {
        this.roles = roles;
    }

    public Map<String, RangerAuthzResult.PermissionResult> getUserPermissions(String user) {
        return this.users == null ? null : this.users.get(user);
    }

    public void setUserPermissions(String user, Map<String, RangerAuthzResult.PermissionResult> permissions) {
        if (permissions == null) {
            if (this.users != null) {
                this.users.remove(user);
            }
        } else {
            if (this.users == null) {
                this.users = new HashMap<String, Map<String, RangerAuthzResult.PermissionResult>>();
            }
            this.users.put(user, permissions);
        }
    }

    public Map<String, RangerAuthzResult.PermissionResult> getGroupPermissions(String group) {
        return this.groups == null ? null : this.groups.get(group);
    }

    public void setGroupPermissions(String group, Map<String, RangerAuthzResult.PermissionResult> permissions) {
        if (permissions == null) {
            if (this.groups != null) {
                this.groups.remove(group);
            }
        } else {
            if (this.groups == null) {
                this.groups = new HashMap<String, Map<String, RangerAuthzResult.PermissionResult>>();
            }
            this.groups.put(group, permissions);
        }
    }

    public Map<String, RangerAuthzResult.PermissionResult> getRolePermissions(String role) {
        return this.roles == null ? null : this.roles.get(role);
    }

    public void setRolePermissions(String role, Map<String, RangerAuthzResult.PermissionResult> permissions) {
        if (permissions == null) {
            if (this.roles != null) {
                this.roles.remove(role);
            }
        } else {
            if (this.roles == null) {
                this.roles = new HashMap<String, Map<String, RangerAuthzResult.PermissionResult>>();
            }
            this.roles.put(role, permissions);
        }
    }

    public RangerAuthzResult.PermissionResult getUserPermission(String user, String permission) {
        Map<String, RangerAuthzResult.PermissionResult> userPermissions = this.getUserPermissions(user);
        return userPermissions == null ? null : userPermissions.get(permission);
    }

    public void setUserPermission(String user, String permission, RangerAuthzResult.PermissionResult result) {
        Map<String, RangerAuthzResult.PermissionResult> userPermissions = this.getUserPermissions(user);
        if (result == null) {
            if (userPermissions != null) {
                userPermissions.remove(permission);
            }
        } else if (userPermissions == null) {
            userPermissions = new HashMap<String, RangerAuthzResult.PermissionResult>();
            userPermissions.put(permission, result);
            this.setUserPermissions(user, userPermissions);
        } else {
            userPermissions.put(permission, result);
        }
    }

    public RangerAuthzResult.PermissionResult getGroupPermission(String group, String permission) {
        Map<String, RangerAuthzResult.PermissionResult> groupPermissions = this.getGroupPermissions(group);
        return groupPermissions == null ? null : groupPermissions.get(permission);
    }

    public void setGroupPermission(String group, String permission, RangerAuthzResult.PermissionResult result) {
        Map<String, RangerAuthzResult.PermissionResult> groupPermissions = this.getGroupPermissions(group);
        if (result == null) {
            if (groupPermissions != null) {
                groupPermissions.remove(permission);
            }
        } else if (groupPermissions == null) {
            groupPermissions = new HashMap<String, RangerAuthzResult.PermissionResult>();
            groupPermissions.put(permission, result);
            this.setGroupPermissions(group, groupPermissions);
        } else {
            groupPermissions.put(permission, result);
        }
    }

    public RangerAuthzResult.PermissionResult getRolePermission(String role, String permission) {
        Map<String, RangerAuthzResult.PermissionResult> rolePermissions = this.getRolePermissions(role);
        return rolePermissions == null ? null : rolePermissions.get(permission);
    }

    public void setRolePermission(String role, String permission, RangerAuthzResult.PermissionResult result) {
        Map<String, RangerAuthzResult.PermissionResult> rolePermissions = this.getRolePermissions(role);
        if (result == null) {
            if (rolePermissions != null) {
                rolePermissions.remove(permission);
            }
        } else if (rolePermissions == null) {
            rolePermissions = new HashMap<String, RangerAuthzResult.PermissionResult>();
            rolePermissions.put(permission, result);
            this.setRolePermissions(role, rolePermissions);
        } else {
            rolePermissions.put(permission, result);
        }
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.users, this.groups, this.roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerResourcePermissions that = (RangerResourcePermissions)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.users, that.users) && Objects.equals(this.groups, that.groups) && Objects.equals(this.roles, that.roles);
    }

    public String toString() {
        return "RangerResourcePermissions{resource=" + this.resource + ", users=" + this.users + ", groups=" + this.groups + ", roles=" + this.roles + '}';
    }
}

