/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.admin.client.RangerPolicySource;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFolderPolicySource
extends RangerPolicySource {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFolderPolicySource.class);
    private String prefix;
    private String prefixWithAppId;
    private ServicePolicies policies;
    private RangerRoles roles;
    private RangerUserStore userStore;
    private ServiceTags tags;
    private long lastPoliciesFileModifiedTime = -1L;
    private long lastRolesFileModifiedTime = -1L;
    private long lastUserStoreFileModifiedTime = -1L;
    private long lastTagsFileModifiedTime = -1L;

    @Override
    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        super.init(serviceName, appId, configPropertyPrefix, config);
        String directory = config.get(configPropertyPrefix + ".policy.source.local_folder.path");
        if (StringUtils.isBlank((CharSequence)directory)) {
            directory = "";
        } else if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        this.prefix = directory + serviceName;
        this.prefixWithAppId = StringUtils.isBlank((CharSequence)appId) ? null : directory + appId + "_" + serviceName;
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadPolicies();
        return lastKnownVersion == -1L || this.policies == null || this.policies.getPolicyVersion() == null || !this.policies.getPolicyVersion().equals(lastKnownVersion) ? this.policies : null;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownVersion, long lastActivationTimeInMills) throws Exception {
        this.loadRoles();
        return lastKnownVersion == -1L || this.roles == null || this.roles.getRoleVersion() == null || !this.roles.getRoleVersion().equals(lastKnownVersion) ? this.roles : null;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadTags();
        return lastKnownVersion == -1L || this.tags == null || this.tags.getTagVersion() == null || !this.tags.getTagVersion().equals(lastKnownVersion) ? this.tags : null;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadUserStore();
        return lastKnownVersion == -1L || this.userStore == null || this.userStore.getUserStoreVersion() == null || !this.userStore.getUserStoreVersion().equals(lastKnownVersion) ? this.userStore : null;
    }

    private void loadPolicies() throws Exception {
        File srcFile = this.getSourceFile(".json");
        if (this.policies == null || srcFile.lastModified() != this.lastPoliciesFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.policies = (ServicePolicies)this.gson.fromJson((Reader)reader, ServicePolicies.class);
                this.lastPoliciesFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadRoles() throws Exception {
        File srcFile = this.getSourceFile("_roles.json");
        if (this.roles == null || srcFile.lastModified() != this.lastRolesFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.roles = (RangerRoles)this.gson.fromJson((Reader)reader, RangerRoles.class);
                this.lastRolesFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadTags() throws Exception {
        File srcFile = this.getSourceFile("_tag.json");
        if (this.tags == null || srcFile.lastModified() != this.lastTagsFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.tags = (ServiceTags)this.gson.fromJson((Reader)reader, ServiceTags.class);
                this.lastTagsFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadUserStore() throws Exception {
        File srcFile = this.getSourceFile("_userstore.json");
        if (this.userStore == null || srcFile.lastModified() != this.lastUserStoreFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.userStore = (RangerUserStore)this.gson.fromJson((Reader)reader, RangerUserStore.class);
                this.lastUserStoreFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private File getSourceFile(String suffix) throws Exception {
        boolean isReadable;
        if (StringUtils.isBlank((CharSequence)this.prefix)) {
            throw new Exception(LocalFolderPolicySource.class.getName() + ": not initialized");
        }
        File src = new File(this.prefix + suffix);
        boolean bl = isReadable = src.exists() && src.canRead();
        if (!isReadable && StringUtils.isNotBlank((CharSequence)this.prefixWithAppId)) {
            src = new File(this.prefixWithAppId + suffix);
            boolean bl2 = isReadable = src.exists() && src.canRead();
        }
        if (!isReadable) {
            LOG.error("{}{}: file not found or not readable", (Object)this.prefix, (Object)suffix);
            throw new Exception(this.prefix + suffix + ": file not found or not readable");
        }
        return src;
    }
}

