/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRolesProvider;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRefresher
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyRefresher.class);
    private static final Logger PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private final RangerBasePlugin plugIn;
    private final String serviceType;
    private final String serviceName;
    private final RangerAdminClient rangerAdmin;
    private final RangerRolesProvider rolesProvider;
    private final long pollingIntervalMs;
    private final String cacheFileName;
    private final String cacheDir;
    private final BlockingQueue<DownloadTrigger> policyDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private Timer policyDownloadTimer;
    private long lastKnownVersion = -1L;
    private long lastActivationTimeInMillis;
    private boolean policiesSetInPlugin;
    private boolean serviceDefSetInPlugin;

    public PolicyRefresher(RangerBasePlugin plugIn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + plugIn.getServiceName() + ").PolicyRefresher()");
        }
        RangerPluginConfig pluginConfig = plugIn.getConfig();
        String propertyPrefix = pluginConfig.getPropertyPrefix();
        this.plugIn = plugIn;
        this.serviceType = plugIn.getServiceType();
        this.serviceName = plugIn.getServiceName();
        this.cacheDir = pluginConfig.get(propertyPrefix + ".policy.cache.dir");
        String appId = StringUtils.isEmpty((CharSequence)plugIn.getAppId()) ? this.serviceType : plugIn.getAppId();
        String cacheFilename = String.format("%s_%s.json", appId, this.serviceName);
        cacheFilename = cacheFilename.replace(File.separatorChar, '_');
        this.cacheFileName = cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
        RangerPluginContext pluginContext = plugIn.getPluginContext();
        RangerAdminClient adminClient = pluginContext.getAdminClient();
        this.rangerAdmin = adminClient != null ? adminClient : pluginContext.createAdminClient(pluginConfig);
        this.rolesProvider = new RangerRolesProvider(this.getServiceType(), appId, this.getServiceName(), this.rangerAdmin, this.cacheDir, pluginConfig);
        this.pollingIntervalMs = pluginConfig.getLong(propertyPrefix + ".policy.pollIntervalMs", 30000L);
        this.setName("PolicyRefresher(serviceName=" + this.serviceName + ")-" + this.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").PolicyRefresher()");
        }
    }

    public RangerBasePlugin getPlugin() {
        return this.plugIn;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerAdminClient getRangerAdminClient() {
        return this.rangerAdmin;
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    public void startRefresher() {
        this.loadRoles();
        this.loadPolicy();
        this.initRefresher();
    }

    public void stopRefresher() {
        Timer policyDownloadTimer = this.policyDownloadTimer;
        this.policyDownloadTimer = null;
        if (policyDownloadTimer != null) {
            policyDownloadTimer.cancel();
        }
        if (super.isAlive()) {
            super.interrupt();
            boolean setInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    LOG.warn("PolicyRefresher(serviceName=" + this.serviceName + "): error while waiting for thread to exit", (Throwable)excp);
                    LOG.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                    setInterrupted = true;
                }
            }
            if (setInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").run()");
        }
        while (true) {
            DownloadTrigger trigger = null;
            try {
                trigger = this.policyDownloadQueue.take();
                this.loadRoles();
                this.loadPolicy();
                continue;
            }
            catch (InterruptedException excp) {
                LOG.info("PolicyRefresher(serviceName=" + this.serviceName + ").run(): interrupted! Exiting thread", (Throwable)excp);
            }
            finally {
                if (trigger == null) continue;
                trigger.signalCompletion();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").run()");
        }
    }

    public void syncPoliciesWithAdmin(DownloadTrigger token) throws InterruptedException {
        this.policyDownloadQueue.put(token);
        token.waitForCompletion();
    }

    private void loadPolicy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicy(serviceName=" + this.serviceName + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        try {
            ServicePolicies svcPolicies = this.loadPolicyfromPolicyAdmin();
            if (svcPolicies == null && !this.policiesSetInPlugin) {
                svcPolicies = this.loadFromCache();
            }
            if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
            }
            if (svcPolicies != null) {
                this.plugIn.setPolicies(svcPolicies);
                this.policiesSetInPlugin = true;
                this.serviceDefSetInPlugin = false;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = svcPolicies.getPolicyVersion() != null ? svcPolicies.getPolicyVersion() : -1L;
            } else if (!this.policiesSetInPlugin && !this.serviceDefSetInPlugin) {
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (!this.serviceDefSetInPlugin) {
                this.disableCache();
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
            }
        }
        catch (Exception excp) {
            LOG.error("Encountered unexpected exception, ignoring..", (Throwable)excp);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()");
        }
    }

    private ServicePolicies loadPolicyfromPolicyAdmin() throws RangerServiceNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()");
        }
        ServicePolicies svcPolicies = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicyFromPolicyAdmin(serviceName=" + this.serviceName + ")");
        }
        try {
            boolean isUpdated;
            svcPolicies = this.rangerAdmin.getServicePoliciesIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = svcPolicies != null;
            if (isUpdated) {
                long newVersion;
                long l = newVersion = svcPolicies.getPolicyVersion() == null ? -1L : svcPolicies.getPolicyVersion();
                if (!StringUtils.equals((CharSequence)this.serviceName, (CharSequence)svcPolicies.getServiceName())) {
                    LOG.warn("PolicyRefresher(serviceName=" + this.serviceName + "): ignoring unexpected serviceName '" + svcPolicies.getServiceName() + "' in service-store");
                    svcPolicies.setServiceName(this.serviceName);
                }
                LOG.info("PolicyRefresher(serviceName=" + this.serviceName + "): found updated version. lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + newVersion);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("PolicyRefresher(serviceName=" + this.serviceName + ").run(): no update found. lastKnownVersion=" + this.lastKnownVersion);
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            LOG.error("PolicyRefresher(serviceName=" + this.serviceName + "): failed to find service. Will clean up local cache of policies (" + this.lastKnownVersion + ")", (Throwable)snfe);
            throw snfe;
        }
        catch (Exception excp) {
            LOG.error("PolicyRefresher(serviceName=" + this.serviceName + "): failed to refresh policies. Will continue to use last known version of policies (" + this.lastKnownVersion + ")", (Throwable)excp);
            svcPolicies = null;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()");
        }
        return svcPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServicePolicies loadFromCache() {
        ServicePolicies policies;
        block18: {
            File cacheFile;
            block19: {
                RangerPerfTracer perf;
                FileReader reader;
                block17: {
                    policies = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()");
                    }
                    File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
                    if (cacheFile == null || !cacheFile.isFile() || !cacheFile.canRead()) break block19;
                    reader = null;
                    perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadFromCache(serviceName=" + this.serviceName + ")");
                    }
                    try {
                        reader = new FileReader(cacheFile);
                        policies = JsonUtils.jsonToObject(reader, ServicePolicies.class);
                        if (policies == null) break block17;
                        if (!StringUtils.equals((CharSequence)this.serviceName, (CharSequence)policies.getServiceName())) {
                            LOG.warn("ignoring unexpected serviceName '" + policies.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'");
                            policies.setServiceName(this.serviceName);
                        }
                        this.lastKnownVersion = policies.getPolicyVersion() == null ? -1L : policies.getPolicyVersion();
                    }
                    catch (Exception excp) {
                        try {
                            LOG.error("failed to load policies from cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                        }
                        catch (Throwable throwable) {
                            RangerPerfTracer.log(perf);
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Exception excp2) {
                                    LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp2);
                                }
                            }
                            throw throwable;
                        }
                        RangerPerfTracer.log(perf);
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Exception excp3) {
                                LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp3);
                            }
                        }
                        break block18;
                    }
                }
                RangerPerfTracer.log(perf);
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                    }
                }
                break block18;
            }
            LOG.warn("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()");
        }
        return policies;
    }

    public void saveToCache(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()");
        }
        boolean doPreserveDeltas = this.plugIn.getConfig().getBoolean(this.plugIn.getConfig().getPropertyPrefix() + ".preserve.deltas", false);
        if (policies != null) {
            Throwable throwable;
            FileWriter writer;
            RangerPerfTracer perf;
            File cacheFile = null;
            File backupCacheFile = null;
            if (this.cacheDir != null) {
                String realCacheDirName = CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) ? this.cacheDir + File.separator + "deltas" : this.cacheDir;
                String backupCacheFileName = this.cacheFileName + "_" + policies.getPolicyVersion();
                String realCacheFileName = CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) ? backupCacheFileName : this.cacheFileName;
                File cacheDirTmp = new File(realCacheDirName);
                if (cacheDirTmp.exists()) {
                    cacheFile = new File(realCacheDirName + File.separator + realCacheFileName);
                } else {
                    try {
                        if (!cacheDirTmp.mkdirs() && !cacheDirTmp.exists()) {
                            LOG.error("Cannot create cache directory: {}", (Object)realCacheDirName);
                        }
                        cacheFile = new File(realCacheDirName + File.separator + realCacheFileName);
                    }
                    catch (SecurityException ex) {
                        LOG.error("Cannot create cache directory", (Throwable)ex);
                    }
                }
                if (CollectionUtils.isEmpty(policies.getPolicyDeltas())) {
                    backupCacheFile = new File(realCacheDirName + File.separator + backupCacheFileName);
                }
            }
            if (cacheFile != null) {
                perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                try {
                    writer = new FileWriter(cacheFile);
                    throwable = null;
                    try {
                        JsonUtils.objectToWriter(writer, policies);
                        this.deleteOldestVersionCacheFileInCacheDirectory(cacheFile.getParentFile());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)writer).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Writer)writer).close();
                            }
                        }
                    }
                }
                catch (Exception excp) {
                    LOG.error("failed to save policies to cache file '" + cacheFile.getAbsolutePath() + "'", (Throwable)excp);
                }
                RangerPerfTracer.log(perf);
            }
            if (doPreserveDeltas && backupCacheFile != null) {
                perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                try {
                    writer = new FileWriter(backupCacheFile);
                    throwable = null;
                    try {
                        JsonUtils.objectToWriter(writer, policies);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (writer != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)writer).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((Writer)writer).close();
                            }
                        }
                    }
                }
                catch (Exception excp) {
                    LOG.error("failed to save policies to cache file '" + backupCacheFile.getAbsolutePath() + "'", (Throwable)excp);
                }
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.info("policies is null. Nothing to save in cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()");
        }
    }

    private void deleteOldestVersionCacheFileInCacheDirectory(File cacheDirectory) {
        int maxVersionsToPreserve = this.plugIn.getConfig().getInt(this.plugIn.getConfig().getPropertyPrefix() + "max.versions.to.preserve", 1);
        FileFilter logFileFilter = file -> file.getName().matches(".+json_.+");
        File[] filesInParent = cacheDirectory.listFiles(logFileFilter);
        ArrayList<Long> policyVersions = new ArrayList<Long>();
        if (filesInParent != null && filesInParent.length > 0) {
            for (File f : filesInParent) {
                Long policyVersion;
                String fileName = f.getName();
                int policyVersionIdx = fileName.lastIndexOf("json_");
                if (policyVersionIdx == -1 || policyVersionIdx + 5 >= fileName.length()) {
                    LOG.warn("Invalid cache file name format: {}", (Object)fileName);
                    continue;
                }
                String policyVersionStr = fileName.substring(policyVersionIdx + 5);
                try {
                    policyVersion = Long.valueOf(policyVersionStr);
                    policyVersions.add(policyVersion);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Cannot parse version from file: {}", (Object)fileName, (Object)e);
                }
                policyVersion = Long.valueOf(policyVersionStr);
                policyVersions.add(policyVersion);
            }
        } else {
            LOG.info("No files matching '.+json_*' found");
        }
        if (!policyVersions.isEmpty()) {
            policyVersions.sort(new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    return o1 < o2 ? -1 : 1;
                }
            });
        }
        if (policyVersions.size() > maxVersionsToPreserve) {
            String fileName = this.cacheFileName + "_" + Long.toString((Long)policyVersions.get(0));
            String pathName = cacheDirectory.getAbsolutePath() + File.separator + fileName;
            File toDelete = new File(pathName);
            if (toDelete.exists()) {
                boolean isDeleted = toDelete.delete();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("file :[" + pathName + "] is deleted" + isDeleted);
                }
            } else {
                LOG.info("File: " + pathName + " does not exist!");
            }
        }
    }

    private void disableCache() {
        File cacheFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")");
        }
        File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn("Cleaning up local cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
            } else {
                LOG.warn("Moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No local policy cache found. No need to disable it!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")");
        }
    }

    private void loadRoles() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadRoles()");
        }
        this.rolesProvider.loadUserGroupRoles(this.plugIn);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadRoles()");
        }
    }

    private void initRefresher() {
        LOG.debug("==> PolicyRefresher(serviceName={}).initRefresher()", (Object)this.serviceName);
        try {
            super.start();
        }
        catch (IllegalStateException e) {
            LOG.error("Failed to start PolicyRefresher thread for serviceName={}", (Object)this.serviceName, (Object)e);
            throw e;
        }
        this.policyDownloadTimer = new Timer("policyDownloadTimer", true);
        try {
            this.policyDownloadTimer.schedule((TimerTask)new DownloaderTask(this.policyDownloadQueue), this.pollingIntervalMs, this.pollingIntervalMs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled policyDownloadRefresher to download policies every " + this.pollingIntervalMs + " milliseconds");
            }
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            LOG.error("Error scheduling policyDownloadTimer:", (Throwable)e);
            LOG.error("*** Policies will NOT be downloaded every " + this.pollingIntervalMs + " milliseconds ***");
            this.policyDownloadTimer.cancel();
            this.policyDownloadTimer = null;
        }
        LOG.debug("<== PolicyRefresher(serviceName={}).initRefresher()", (Object)this.serviceName);
    }
}

